/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.monitor;

import com.mongodb.DBObject;
import com.mongodb.Mongo;
import org.springframework.data.mongodb.monitor.AbstractMonitor;
import org.springframework.jmx.export.annotation.ManagedMetric;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.jmx.support.MetricType;

@ManagedResource(description="Assertion Metrics")
public class AssertMetrics
extends AbstractMonitor {
    public AssertMetrics(Mongo mongo) {
        this.mongo = mongo;
    }

    @ManagedMetric(metricType=MetricType.COUNTER, displayName="Regular")
    public int getRegular() {
        return this.getBtree("regular");
    }

    @ManagedMetric(metricType=MetricType.COUNTER, displayName="Warning")
    public int getWarning() {
        return this.getBtree("warning");
    }

    @ManagedMetric(metricType=MetricType.COUNTER, displayName="Msg")
    public int getMsg() {
        return this.getBtree("msg");
    }

    @ManagedMetric(metricType=MetricType.COUNTER, displayName="User")
    public int getUser() {
        return this.getBtree("user");
    }

    @ManagedMetric(metricType=MetricType.GAUGE, displayName="Rollovers")
    public int getRollovers() {
        return this.getBtree("rollovers");
    }

    private int getBtree(String key) {
        DBObject asserts = (DBObject)this.getServerStatus().get("asserts");
        return (Integer)asserts.get(key);
    }
}

