/*
 * Decompiled with CFR 0.152.
 */
package su.artix.yuki.provider;

import java.util.List;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.swt.widgets.Item;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ssa.cashadmin.excep.ExecuteQueryException;
import su.artix.yuki.model.ModelActivator;
import su.artix.yuki.view.ExtendedColumn;

public class DirectoryCellModifier
implements ICellModifier {
    private static final Logger log = LoggerFactory.getLogger(DirectoryCellModifier.class);
    private ColumnViewer viewer;
    private Class clazz;
    private List<ExtendedColumn> columns;

    public DirectoryCellModifier(Class clazz, ColumnViewer viewer, List<ExtendedColumn> columns) {
        this.viewer = viewer;
        this.clazz = clazz;
        this.columns = columns;
    }

    public boolean canModify(Object element, String property) {
        log.trace("property={}", (Object)property);
        return this.columns.get(this.columns.indexOf(new ExtendedColumn(property))).isEditable();
    }

    public Object getValue(Object element, String property) {
        if (element == null || property == null) {
            return null;
        }
        Object obj = PojoProperties.value((String)property).getValue(element);
        if (PojoProperties.value((Class)this.clazz, (String)property).getValueType().equals(Boolean.class) && obj == null) {
            obj = false;
        }
        return obj;
    }

    public void modify(Object element, String property, Object value) {
        if (element != null) {
            Object obj = ((Item)element).getData();
            PojoProperties.value((String)property).setValue(obj, value);
            try {
                ModelActivator.getDefault().getModelProvider().getDirectoryModel(this.clazz).doUpdate(obj);
            }
            catch (ExecuteQueryException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

