/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.artixadmin.editors.connect;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import ru.ssa.artixadmin.ArtixAdminActivator;
import ru.ssa.artixadmin.editors.connect.UserConnecting;
import su.artix.cashserver.core.cashregistry.domain.WebUser;

public class UserConnectDialog
extends Dialog {
    private Text loginText;
    private Text passwordText;
    private WebUser webUser;
    final boolean cashserver;

    public UserConnectDialog(boolean cashserver) {
        super(Display.getDefault().getActiveShell());
        this.cashserver = cashserver;
    }

    protected Control createDialogArea(Composite parent) {
        String user;
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().margins(10, 5).numColumns(2).applyTo(composite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        Label loginLabel = new Label(composite, 0);
        loginLabel.setText("\u041b\u043e\u0433\u0438\u043d");
        this.loginText = new Text(composite, 2048);
        String authNameKey = "yuki.user";
        String passwordKey = "yuki.password";
        if (!this.cashserver) {
            authNameKey = String.valueOf(authNameKey) + "_cash";
            passwordKey = String.valueOf(passwordKey) + "_cash";
        }
        if ((user = System.getProperty(authNameKey)) != null) {
            this.loginText.setText(user);
        }
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.loginText);
        Label passwordLabel = new Label(composite, 0);
        passwordLabel.setText("\u041f\u0430\u0440\u043e\u043b\u044c");
        this.passwordText = new Text(composite, 0x400800);
        String password = System.getProperty(passwordKey);
        if (password != null) {
            this.passwordText.setText(password);
        }
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.passwordText);
        return parent;
    }

    protected void okPressed() {
        ArtixAdminActivator.getDefault().setLoadCursor(true);
        String authName = this.loginText.getText();
        String authPassword = this.passwordText.getText();
        this.webUser = UserConnecting.auth(authName, authPassword);
        if (this.webUser != null) {
            super.okPressed();
        }
        ArtixAdminActivator.getDefault().setLoadCursor(false);
    }

    public WebUser getWebUser() {
        return this.webUser;
    }

    protected boolean isResizable() {
        return true;
    }
}

