/*
 * Decompiled with CFR 0.152.
 */
package su.artix.discountmanager.dialogs.clients;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ssa.cashadmin.domain.Additionalcard;
import ru.ssa.cashadmin.domain.Card;
import ru.ssa.cashadmin.domain.Client;
import ru.ssa.cashadmin.domain.ClientAdditionalInfo;
import ru.ssa.cashadmin.domain.ClientServerV144;
import ru.ssa.cashadmin.excep.ExecuteQueryException;
import su.artix.artixadmin.connection.ArtixAdminContextHolder;
import su.artix.discountmanager.Activator;
import su.artix.discountmanager.dialogs.clients.ClientAdditionalCardEditPanel;
import su.artix.discountmanager.dialogs.clients.ClientBasicEditPanel;
import su.artix.discountmanager.dialogs.clients.ClientCardEditPanel;
import su.artix.discountmanager.dialogs.clients.ClientEditPanel;
import su.artix.yuki.editors.DialogMode;
import su.artix.yuki.editors.DirectoryEditDialog;
import su.artix.yuki.editors.EditorComposite;
import su.artix.yuki.model.ModelActivator;
import su.artix.yuki.model.directory.DirectoryAction;
import su.artix.yuki.model.directory.DirectoryEditModel;

public class ClientDialog
extends DirectoryEditDialog<Client> {
    private static final Logger log = LoggerFactory.getLogger(ClientDialog.class);
    private EditorComposite<Client> panel;

    public ClientDialog(Shell parentShell, Client model, DialogMode dialogMode) {
        super(parentShell, (Object)model, dialogMode);
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        super.setTitle("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u043a\u043b\u0438\u0435\u043d\u0442\u0430", "\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043a\u043b\u0438\u0435\u043d\u0442\u0430");
        super.setMessage("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u043a\u043b\u0438\u0435\u043d\u0442\u0430", "\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043a\u043b\u0438\u0435\u043d\u0442\u0430", 1);
        return contents;
    }

    protected EditorComposite<Client> getEditPanel(Composite parent, Client model) {
        IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
        boolean useClientAdditionalInfo = preferenceStore.getBoolean("CLIENT_ADDITIONAL_INFO_INSTEAD_TEXT");
        if (useClientAdditionalInfo && ArtixAdminContextHolder.isCashserver() && model != null && model.getIdClient() != null && ClientServerV144.class.isAssignableFrom(model.getClass()) && this.getDialogMode() != DialogMode.CREATE) {
            DirectoryEditModel directoryModel = ModelActivator.getDefault().getModelProvider().getDirectoryModel(ClientAdditionalInfo.class);
            ((ClientServerV144)model).setClientAdditionalInfo((ClientAdditionalInfo)directoryModel.getById((Object)model.getIdClient()));
        }
        this.panel = new ClientEditPanel(parent, 0, model);
        this.panel.setParentDialog((DirectoryEditDialog)this);
        this.panel.initialize();
        return this.panel;
    }

    public boolean close() {
        this.panel.dispose();
        return super.close();
    }

    protected void doAfterSave(Client domain, DialogMode dialogMode) {
        ClientAdditionalCardEditPanel addclientCardEditPanel;
        ClientCardEditPanel clientCardEditPanel;
        super.doAfterSave((Object)domain, dialogMode);
        IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
        boolean useClientAdditionalInfo = preferenceStore.getBoolean("CLIENT_ADDITIONAL_INFO_INSTEAD_TEXT");
        if (useClientAdditionalInfo && ArtixAdminContextHolder.isCashserver() && domain != null && StringUtils.isNotEmpty((String)domain.getIdClient()) && ClientServerV144.class.isAssignableFrom(domain.getClass())) {
            ClientServerV144 client = (ClientServerV144)domain;
            DirectoryEditModel directoryModel = ModelActivator.getDefault().getModelProvider().getDirectoryModel(ClientAdditionalInfo.class);
            if (dialogMode == DialogMode.COPY) {
                client.setClientAdditionalInfo(null);
            } else if (client.getClientAdditionalInfo() != null && StringUtils.isNotEmpty((String)client.getClientAdditionalInfo().getIdClient())) {
                try {
                    directoryModel.update((Object)client.getClientAdditionalInfo());
                }
                catch (ExecuteQueryException e) {
                    log.error("Can't update clientAdditionalInfo for idClient = {}", (Object)client.getClientAdditionalInfo().getIdClient(), (Object)e);
                }
            }
            String text = ((ClientBasicEditPanel)((ClientEditPanel)this.panel).getBasicPanel()).getAdditionalInfo().getText();
            if ((StringUtils.isNotEmpty((String)text) || StringUtils.isNotEmpty((String)domain.getText())) && client.getClientAdditionalInfo() == null) {
                ClientAdditionalInfo additionalInfo = new ClientAdditionalInfo();
                additionalInfo.setIdClient(domain.getIdClient());
                additionalInfo.setInformation(StringUtils.isEmpty((String)text) ? domain.getText() : text);
                try {
                    directoryModel.save((Object)additionalInfo);
                }
                catch (ExecuteQueryException e) {
                    log.error("Can't save clientAdditionalInfo for idClient = {}", (Object)client.getClientAdditionalInfo().getIdClient(), (Object)e);
                }
            }
        }
        if ((clientCardEditPanel = (ClientCardEditPanel)((ClientEditPanel)this.panel).getCardPanel()) != null) {
            Map<Card, String> map = ((ClientCardEditPanel)((ClientEditPanel)this.panel).getCardPanel()).getCardContentProvider().getMap();
            HashMap<Card, String> cardsForUpdate = new HashMap<Card, String>();
            DirectoryEditModel cardDirectoryModel = ModelActivator.getDefault().getModelProvider().getDirectoryModel(Card.class);
            for (Map.Entry<Card, String> entry : map.entrySet()) {
                DirectoryAction action = DirectoryAction.valueOf((String)entry.getValue());
                if (action.equals((Object)DirectoryAction.NONE)) continue;
                Card cardFromBase = (Card)cardDirectoryModel.getById((Object)entry.getKey().getIdCard());
                switch (action) {
                    case UPDATE: {
                        cardFromBase.setClient(domain);
                        break;
                    }
                    case REMOVE: {
                        cardFromBase.setClient(null);
                        break;
                    }
                    case ADD: {
                        cardFromBase.setClient(domain);
                        break;
                    }
                }
                cardsForUpdate.put(cardFromBase, DirectoryAction.UPDATE.toString());
            }
            DirectoryEditModel directoryModel = ModelActivator.getDefault().getModelProvider().getDirectoryModel(Card.class);
            directoryModel.updateActionsMap(cardsForUpdate);
            for (Card card : cardsForUpdate.keySet()) {
                directoryModel.firePropertyChange(DirectoryAction.REFRESH_SINGLE_ITEM, (Object)card, null);
            }
        }
        if ((addclientCardEditPanel = (ClientAdditionalCardEditPanel)((ClientEditPanel)this.panel).getAdditionalcardPanel()) != null) {
            Map<Additionalcard, String> map = addclientCardEditPanel.getCardContentProvider().getMap();
            HashMap<Additionalcard, String> cardsForUpdate = new HashMap<Additionalcard, String>();
            DirectoryEditModel cardDirectoryModel = ModelActivator.getDefault().getModelProvider().getDirectoryModel(Additionalcard.class);
            for (Map.Entry<Additionalcard, String> entry : map.entrySet()) {
                DirectoryAction action = DirectoryAction.valueOf((String)entry.getValue());
                if (action.equals((Object)DirectoryAction.NONE)) continue;
                Additionalcard cardFromBase = (Additionalcard)cardDirectoryModel.getById((Object)entry.getKey().getAdditionalnumber());
                switch (action) {
                    case UPDATE: {
                        cardFromBase.setClient(domain);
                        break;
                    }
                    case REMOVE: {
                        cardFromBase.setClient(null);
                        break;
                    }
                    case ADD: {
                        cardFromBase.setClient(domain);
                        break;
                    }
                }
                cardsForUpdate.put(cardFromBase, DirectoryAction.UPDATE.toString());
            }
            DirectoryEditModel directoryModel = ModelActivator.getDefault().getModelProvider().getDirectoryModel(Additionalcard.class);
            directoryModel.updateActionsMap(cardsForUpdate);
            for (Additionalcard card : cardsForUpdate.keySet()) {
                directoryModel.firePropertyChange(DirectoryAction.REFRESH_SINGLE_ITEM, (Object)card, null);
            }
        }
    }
}

