/*
 * Decompiled with CFR 0.152.
 */
package su.artix.discountmanager.providers.accounting;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import su.artix.cashserver.rest.client.IClientGetter;
import su.artix.cashserver.rest.domain.ShopInfo;
import su.artix.discountmanager.Activator;

public class ExctendedBonusInfoProvider {
    private Map<String, String> shopCodes = new HashMap<String, String>();
    private Map<String, String> cashCodes = new HashMap<String, String>();
    public boolean inited = false;

    public String getShop(String sessionId) {
        String result = "";
        if (this.inited && StringUtils.isNotEmpty((String)sessionId)) {
            if (StringUtils.startsWith((String)sessionId, (String)"kkm")) {
                result = sessionId.substring(3, 6);
            } else {
                String[] arr = StringUtils.split((String)sessionId, (String)"$");
                if (arr.length > 0) {
                    result = StringUtils.defaultString((String)this.shopCodes.get(arr[0]));
                }
            }
        }
        return result;
    }

    public String getCash(String sessionId) {
        String result = "";
        if (this.inited && StringUtils.isNotEmpty((String)sessionId)) {
            if (StringUtils.startsWith((String)sessionId, (String)"kkm")) {
                result = sessionId.substring(6, 8);
            } else {
                String[] arr = StringUtils.split((String)sessionId, (String)"$");
                if (arr.length > 0) {
                    result = StringUtils.defaultString((String)this.cashCodes.get(arr[0]));
                }
            }
        }
        return result;
    }

    public String getShift(String sessionId) {
        String[] arr;
        String result = "";
        if (this.inited && StringUtils.isNotEmpty((String)sessionId) && (arr = StringUtils.split((String)sessionId, (String)".")).length > 1) {
            result = StringUtils.defaultString((String)arr[1]);
        }
        return result;
    }

    public String getCheck(String sessionId) {
        String[] arr;
        String result = "";
        if (this.inited && StringUtils.isNotEmpty((String)sessionId) && (arr = StringUtils.split((String)sessionId, (String)".")).length > 2) {
            result = StringUtils.defaultString((String)arr[2]);
        }
        return result;
    }

    public void init() {
        if (System.getProperty("yuki.supportRestIp") != null) {
            IClientGetter clientGetter = Activator.getDefault().getBeanByClass(IClientGetter.class, "supportClientGetter");
            HashMap<String, String> shopIds = new HashMap<String, String>();
            for (ShopInfo info : clientGetter.getClient().getShopsEntity().getShopInfosList()) {
                shopIds.put(info.getId(), info.getShopCode());
            }
            for (ShopInfo info : clientGetter.getClient().getCashesEntity().getCashes()) {
                this.cashCodes.put(info.getId(), info.getCashCode());
                this.shopCodes.put(info.getId(), (String)shopIds.get(info.getParentShop()));
            }
            this.inited = true;
        }
    }
}

