/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.artixadmin.action.menutree;

import java.awt.Menu;
import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ssa.artixadmin.ArtixAdminActivator;
import ru.ssa.cashadmin.dao.SessionManager;
import ru.ssa.cashadmin.domain.DomainCollections;
import ru.ssa.cashadmin.domain.advanced.HierarchicalMenuItem;
import ru.ssa.cashadmin.domain.utils.JaxbUtil;
import ru.ssa.cashadmin.domain.utils.RefreshUtil;
import su.artix.yuki.action.DirectoryExportAction;
import su.artix.yuki.model.ModelActivator;
import su.artix.yuki.view.XMLFileDialog;

public class ExportMenuTreeAction
extends Action {
    public static final String ID = "ru.ssa.artixadmin.action.menutree.ExportMenuAction";
    private static final Logger log = LoggerFactory.getLogger(DirectoryExportAction.class);

    public ExportMenuTreeAction() {
        this(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
    }

    public ExportMenuTreeAction(IWorkbenchWindow window) {
        super("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u043c\u0435\u043d\u044e \u0432 \u0444\u0430\u0439\u043b");
        this.setId(ID);
        if (window == null) {
            throw new IllegalArgumentException();
        }
        this.setToolTipText("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u043c\u0435\u043d\u044e \u0432 \u0444\u0430\u0439\u043b");
    }

    public ExportMenuTreeAction(ImageDescriptor imageDescriptor) {
        this();
        this.setImageDescriptor(imageDescriptor);
    }

    public void run() {
        HierarchicalMenuItem model = ModelActivator.getDefault().getModelProvider().getHierarchicalMenuItemModel().getCurrentModel();
        String xmlFileName = new XMLFileDialog(8192).open();
        if (xmlFileName != null) {
            try {
                try {
                    SessionManager.flushSession(Menu.class);
                    SessionManager.openSession(Menu.class);
                    ArtixAdminActivator.getDefault().setLoadCursor(true);
                    this.refresh(model);
                    ArrayList<HierarchicalMenuItem> collection = new ArrayList<HierarchicalMenuItem>();
                    collection.add(model);
                    DomainCollections domainCollections = new DomainCollections(collection);
                    JaxbUtil.INSTANCE.exportToXML(xmlFileName, domainCollections);
                    SessionManager.closeSession(Menu.class);
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                    ArtixAdminActivator.getDefault().setLoadCursor(false);
                }
            }
            finally {
                ArtixAdminActivator.getDefault().setLoadCursor(false);
            }
        }
    }

    public void refresh(HierarchicalMenuItem item) {
        RefreshUtil.refresh((Object)item.getCmaction());
        if (item.getMenuitem() != null) {
            RefreshUtil.refresh((Object)item.getMenuitem().getCmactioncode());
        }
        for (HierarchicalMenuItem action : item.getActions()) {
            this.refresh(action);
        }
        for (HierarchicalMenuItem action : item.getMenues()) {
            this.refresh(action);
        }
    }
}

