/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.artixadmin.provider.goods;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanComparator;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import ru.ssa.cashadmin.domain.Barcodes;
import ru.ssa.cashadmin.domain.Invent;
import ru.ssa.cashadmin.domain.Prices;
import ru.ssa.cashadmin.utils.AdditionalCriteria;
import ru.ssa.cashadmin.utils.ArtixFilter;
import su.artix.yuki.model.ModelActivator;
import su.artix.yuki.model.directory.DirectoryAction;
import su.artix.yuki.provider.IOrderedContentProvider;

public class PricesContentProvider
implements IStructuredContentProvider,
IOrderedContentProvider {
    private final Map<Prices, String> map = new HashMap<Prices, String>();
    private boolean ascending = true;
    private String sortBy;
    private final TableViewer tableViewer;

    public PricesContentProvider(Invent model, TableViewer tableViewer) {
        this.tableViewer = tableViewer;
        this.sortBy = "barcode";
        if (model.getCode() != null) {
            ArtixFilter barcodesFilter = new ArtixFilter(Barcodes.class);
            barcodesFilter.setAdditionalCriteria(new AdditionalCriteria(AdditionalCriteria.Type.EQ, new Object[]{"code", model.getCode()}));
            List barcodesList = ModelActivator.getDefault().getModelProvider().getDirectoryModel(Barcodes.class).getList(this.sortBy, this.ascending, (Object)barcodesFilter);
            ArrayList<String> set = new ArrayList<String>();
            set.add(model.getCode());
            for (Barcodes barcode : barcodesList) {
                set.add(barcode.getBarcode());
            }
            ArtixFilter pricesFilter = new ArtixFilter(Prices.class);
            pricesFilter.setAdditionalCriteria(new AdditionalCriteria(AdditionalCriteria.Type.IN, new Object[]{"barcode", set.toArray()}));
            List objects = ModelActivator.getDefault().getModelProvider().getDirectoryModel(Prices.class).getList(this.sortBy, this.ascending, (Object)pricesFilter);
            for (Prices object : objects) {
                this.map.put(object, DirectoryAction.NONE.toString());
            }
        }
        this.sortBy = "effectivedate";
        this.ascending = false;
    }

    public Map<Prices, String> getMap() {
        return this.map;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        viewer.refresh();
    }

    public String getSortProperty() {
        return this.sortBy;
    }

    public void setSortProperty(String sortby) {
        this.sortBy = sortby;
        this.tableViewer.setInput((Object)sortby);
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public void setAscending(boolean ascending) {
        this.ascending = ascending;
    }

    public Object[] getElements(Object inputElement) {
        ArrayList<Prices> prices = new ArrayList<Prices>();
        for (Prices key : this.map.keySet()) {
            if (this.map.get(key).equals(DirectoryAction.REMOVE.toString())) continue;
            prices.add(key);
        }
        BeanComparator comp = new BeanComparator(this.sortBy);
        if (!this.ascending) {
            Collections.sort(prices, Collections.reverseOrder(comp));
        } else {
            Collections.sort(prices, comp);
        }
        return prices.toArray();
    }
}

