/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.artixadmin.provider.goods;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import ru.ssa.cashadmin.LibActivator;
import ru.ssa.cashadmin.domain.Invent;
import ru.ssa.cashadmin.domain.Kitgoods;
import su.artix.yuki.model.ModelActivator;
import su.artix.yuki.provider.IOrderedContentProvider;

public class TmcKitgoodsContentProvider
implements IStructuredContentProvider,
IOrderedContentProvider {
    private List<Kitgoods> kitgoodsResult = new ArrayList<Kitgoods>();
    private boolean ascending = true;
    private String sortBy;
    private final TableViewer tableViewer;

    public TmcKitgoodsContentProvider(Invent model, TableViewer tableViewer) {
        this.tableViewer = tableViewer;
        this.sortBy = "campaignid";
        Kitgoods kitgoods = (Kitgoods)LibActivator.getDefault().getActualClassResolver().getInstance(Kitgoods.class);
        kitgoods.setGoodscode(model.getCode());
        List kitgoodsList = ModelActivator.getDefault().getModelProvider().getDirectoryModel(Kitgoods.class).getList((Object)kitgoods);
        for (Kitgoods kitgood : kitgoodsList) {
            boolean containKitgood = false;
            if (kitgood.getKit() == null || kitgood.getKit().getCampaign() == null) continue;
            if (this.kitgoodsResult.isEmpty()) {
                this.kitgoodsResult.add(kitgood);
                continue;
            }
            int i = 0;
            while (i < this.kitgoodsResult.size()) {
                if (this.kitgoodsResult.get(i).getKitid().equals(kitgood.getKitid())) {
                    BigDecimal initQuantity = this.kitgoodsResult.get(i).getQuantity();
                    if (initQuantity == null) {
                        initQuantity = BigDecimal.ZERO;
                    }
                    if (kitgood.getQuantity() != null) {
                        initQuantity = initQuantity.add(kitgood.getQuantity());
                    }
                    this.kitgoodsResult.get(i).setQuantity(initQuantity);
                    containKitgood = true;
                    break;
                }
                containKitgood = false;
                ++i;
            }
            if (containKitgood) continue;
            this.kitgoodsResult.add(kitgood);
        }
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getElements(Object inputElement) {
        Collections.sort(this.kitgoodsResult, new Comparator<Kitgoods>(){

            @Override
            public int compare(Kitgoods o1, Kitgoods o2) {
                int result = 0;
                if (TmcKitgoodsContentProvider.this.sortBy.equals("campaignid")) {
                    result = o1.getKit().getCampaignid().compareTo(o2.getKit().getCampaignid());
                } else if (TmcKitgoodsContentProvider.this.sortBy.equals("campaignname")) {
                    result = o1.getKit().getCampaign().getName().compareTo(o2.getKit().getCampaign().getName());
                } else if (TmcKitgoodsContentProvider.this.sortBy.equals("kitname")) {
                    result = o1.getKit().getName().compareTo(o2.getKit().getName());
                }
                return TmcKitgoodsContentProvider.this.ascending ? result : result * -1;
            }
        });
        return this.kitgoodsResult.toArray();
    }

    public String getSortProperty() {
        return this.sortBy;
    }

    public void setSortProperty(String sortby) {
        this.sortBy = sortby;
        this.tableViewer.setInput(null);
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public void setAscending(boolean ascending) {
        this.ascending = ascending;
    }
}

