/*
 * Decompiled with CFR 0.152.
 */
package su.artix.discountmanager.comport;

import gnu.io.CommPort;
import gnu.io.CommPortIdentifier;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.SerialPortEventListener;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import su.artix.discountmanager.comport.SerialReader;

public class CommPortProvider {
    private static final Logger log = LoggerFactory.getLogger(CommPortProvider.class);
    private SerialPort serialPort;

    public List<String> discovering() throws PortInUseException, IOException, UnsupportedCommOperationException {
        Enumeration portEnum = CommPortIdentifier.getPortIdentifiers();
        ArrayList<String> names = new ArrayList<String>();
        while (portEnum.hasMoreElements()) {
            CommPortIdentifier portIdentifier = (CommPortIdentifier)portEnum.nextElement();
            if (portIdentifier.getPortType() != 1) continue;
            names.add(portIdentifier.getName());
            log.trace("FOUND PORT {} Owned {}", (Object)portIdentifier.getName(), (Object)portIdentifier.isCurrentlyOwned());
        }
        return names;
    }

    public void connect(String portName, SerialReader listener) throws Exception {
        CommPortIdentifier portIdentifier = CommPortIdentifier.getPortIdentifier((String)portName);
        if (portIdentifier.isCurrentlyOwned()) {
            log.error("Error: Port is currently in use");
        } else {
            CommPort commPort = portIdentifier.open(this.getClass().getName(), 2000);
            this.serialPort = (SerialPort)commPort;
            this.serialPort.setSerialPortParams(9600, 8, 1, 0);
            InputStream in = this.serialPort.getInputStream();
            listener.setIn(in);
            this.serialPort.addEventListener((SerialPortEventListener)listener);
            this.serialPort.notifyOnDataAvailable(true);
        }
    }

    public void disconnect() {
        if (this.serialPort != null) {
            this.serialPort.removeEventListener();
            this.serialPort.close();
        }
    }
}

