/*
 * Decompiled with CFR 0.152.
 */
package su.artix.discountmanager.controls;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class EnablerCheckBoxControl {
    private Button checkBox;
    private Control toDisable;
    private boolean hideDisabled;
    private boolean invertable;

    public EnablerCheckBoxControl(Composite parent, boolean hideDisabled, Control toDisable, boolean invertable) {
        this(parent, hideDisabled, toDisable);
        this.invertable = invertable;
    }

    public EnablerCheckBoxControl(Composite parent, boolean hideDisabled, Control toDisable) {
        this.checkBox = new Button(parent, 32);
        this.toDisable = toDisable;
        this.hideDisabled = hideDisabled;
        this.invertable = false;
        this.checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                if (EnablerCheckBoxControl.this.toDisable != null) {
                    EnablerCheckBoxControl.this.setEnabled(EnablerCheckBoxControl.this.checkBox.getSelection());
                }
            }
        });
    }

    public void setText(String text) {
        this.checkBox.setText(text);
    }

    public EnablerCheckBoxControl(Composite parent, boolean hideDisabled) {
        this(parent, hideDisabled, null);
    }

    public EnablerCheckBoxControl(Composite parent) {
        this(parent, false, null);
    }

    public Control getToDisable() {
        return this.toDisable;
    }

    public void setToDisable(Control toDisable) {
        this.toDisable = toDisable;
    }

    public void setEnabled(boolean enabled) {
        this.checkBox.setSelection(enabled);
        if (this.toDisable != null) {
            if (this.invertable) {
                this.toDisable.setEnabled(!enabled);
            } else {
                this.toDisable.setEnabled(enabled);
            }
            if (this.hideDisabled) {
                this.toDisable.setVisible(enabled);
            }
        }
    }

    public boolean getEnabled() {
        return this.checkBox.getSelection();
    }

    public Button getCheckBox() {
        return this.checkBox;
    }
}

