/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.cashadmin.domain;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildNumber {
    private static final Logger log = LoggerFactory.getLogger(BuildNumber.class);
    private String buildNumber;
    private Integer number;
    private BuildType buildType;

    private BuildNumber(String buildNumber) {
        this.buildNumber = buildNumber;
    }

    public Integer getNumber() {
        return this.number;
    }

    public BuildType getBuildType() {
        return this.buildType;
    }

    private void parse() {
        if (this.buildNumber != null && !this.buildNumber.isEmpty()) {
            this.buildNumber = this.buildNumber.trim();
            int index = this.buildNumber.indexOf(45);
            if (index == -1) {
                try {
                    this.number = Integer.parseInt(this.buildNumber);
                }
                catch (NumberFormatException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
                this.number = 0;
                this.buildType = BuildType.unknown;
            } else {
                try {
                    this.number = Integer.parseInt(this.buildNumber.substring(0, index));
                }
                catch (NumberFormatException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
                this.number = 0;
                String type = this.buildNumber.substring(index + 1, this.buildNumber.length());
                this.buildType = BuildType.stable.toString().equals(type) ? BuildType.stable : (BuildType.testing.toString().equals(type) ? BuildType.testing : BuildType.unknown);
            }
        } else {
            this.number = 0;
            this.buildType = BuildType.unknown;
        }
    }

    public static BuildNumber parse(String buildNumber) {
        BuildNumber bn = new BuildNumber(buildNumber);
        bn.parse();
        return bn;
    }

    public static enum BuildType {
        stable,
        testing,
        unknown;

    }
}

