/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.flatButton;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.mihalis.opal.utils.SWTGraphicUtil;

public class FlatButton
extends Canvas {
    private static final int DEFAULT_PADDING = 5;
    private Image image;
    private String text;
    private boolean selection;
    private int alignment;
    private final List<SelectionListener> listeners = new ArrayList<SelectionListener>();
    private boolean mouseIn;
    private Color backgroundColor;
    private Color selectedColor;
    private Color selectedTextColor;
    private Color mouseOverColor;

    public FlatButton(Composite composite, int n) {
        super(composite, n);
        this.buildAlignmentFromStyle(n);
        this.addListeners();
        this.initializeDefaultColors();
    }

    private void buildAlignmentFromStyle(int n) {
        this.alignment = (n & 0x4000) == 16384 ? 16384 : ((n & 0x20000) == 131072 ? 131072 : 0x1000000);
    }

    private void addListeners() {
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                FlatButton.this.paintControl(paintEvent);
            }
        });
        this.addListener(6, new Listener(){

            public void handleEvent(Event event) {
                FlatButton.this.mouseIn = true;
                FlatButton.this.redraw();
            }
        });
        this.addListener(7, new Listener(){

            public void handleEvent(Event event) {
                FlatButton.this.mouseIn = false;
                FlatButton.this.redraw();
            }
        });
        this.addListener(4, new Listener(){

            public void handleEvent(Event event) {
                boolean bl = true;
                FlatButton.this.selection = !FlatButton.this.selection;
                for (SelectionListener selectionListener : FlatButton.this.listeners) {
                    SelectionEvent selectionEvent = new SelectionEvent(event);
                    selectionListener.widgetSelected(selectionEvent);
                    bl = bl && selectionEvent.doit;
                }
                if (!bl) {
                    FlatButton.this.selection = !FlatButton.this.selection;
                }
            }
        });
    }

    private void initializeDefaultColors() {
        this.backgroundColor = this.getDisplay().getSystemColor(1);
        this.selectedColor = new Color((Device)this.getDisplay(), 0, 112, 192);
        this.selectedTextColor = this.getDisplay().getSystemColor(1);
        this.mouseOverColor = new Color((Device)this.getDisplay(), 235, 234, 226);
        SWTGraphicUtil.addDisposer((Widget)this, (Resource)this.selectedColor);
        SWTGraphicUtil.addDisposer((Widget)this, (Resource)this.mouseOverColor);
        SWTGraphicUtil.addDisposer((Widget)this, (Resource)this.image);
    }

    private void paintControl(PaintEvent paintEvent) {
        GC gC = paintEvent.gc;
        this.drawBackground(gC);
        if (this.image != null) {
            this.drawImage(gC);
        }
        if (this.text != null) {
            this.drawText(gC);
        }
    }

    private void drawBackground(GC gC) {
        Color color = this.selection ? this.selectedColor : (this.mouseIn ? this.mouseOverColor : this.backgroundColor);
        gC.setBackground(color);
        gC.fillRectangle(this.getClientArea());
    }

    private void drawImage(GC gC) {
        Rectangle rectangle = this.getClientArea();
        Point point = new Point(this.image.getBounds().width, this.image.getBounds().height);
        int n = this.alignment == 16384 ? 5 : (this.alignment == 131072 ? rectangle.width - point.x - 5 : (rectangle.width - point.x) / 2);
        gC.drawImage(this.image, n, 5);
    }

    private void drawText(GC gC) {
        Rectangle rectangle = this.getClientArea();
        if (this.selection) {
            gC.setForeground(this.selectedTextColor);
        } else {
            gC.setForeground(this.getForeground());
        }
        gC.setFont(this.getFont());
        Point point = gC.stringExtent(this.text);
        int n = this.alignment == 16384 ? 5 : (this.alignment == 131072 ? rectangle.width - point.x - 5 : (rectangle.width - point.x) / 2);
        int n2 = this.image == null ? 5 : 10 + this.image.getBounds().height;
        gC.drawString(this.text, n, n2, true);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        this.listeners.add(selectionListener);
    }

    public Point computeSize(int n, int n2, boolean bl) {
        Rectangle rectangle;
        int n3 = 10;
        int n4 = 15;
        if (this.image != null) {
            rectangle = this.image.getBounds();
            n3 += rectangle.width;
            n4 += rectangle.height;
        }
        if (this.text != null) {
            rectangle = new GC((Drawable)this);
            Point point = rectangle.stringExtent(this.text);
            rectangle.dispose();
            n3 = Math.max(n3, point.x + 10);
            n4 += point.y;
        }
        return new Point(Math.max(n3, n), Math.max(n4, n2));
    }

    public int getAlignment() {
        this.checkWidget();
        return this.alignment;
    }

    public Color getBackgroundColor() {
        this.checkWidget();
        return this.backgroundColor;
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    public Color getMouseOverColor() {
        this.checkWidget();
        return this.mouseOverColor;
    }

    public Color getSelectedColor() {
        this.checkWidget();
        return this.selectedColor;
    }

    public Color getSelectedTextColor() {
        return this.selectedTextColor;
    }

    public boolean getSelection() {
        this.checkWidget();
        return this.selection;
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        this.listeners.remove(selectionListener);
    }

    public void setAlignment(int n) {
        this.checkWidget();
        if ((n & 0x1024000) == 0) {
            return;
        }
        this.alignment = n;
        this.redraw();
    }

    public void setBackgroundColor(Color color) {
        this.checkWidget();
        this.backgroundColor = color;
    }

    public void setImage(Image image) {
        this.checkWidget();
        this.image = image;
        this.redraw();
    }

    public void setMouseOverColor(Color color) {
        this.checkWidget();
        this.mouseOverColor = color;
    }

    public void setSelectedColor(Color color) {
        this.checkWidget();
        this.selectedColor = color;
    }

    public void setSelectedTextColor(Color color) {
        this.selectedTextColor = color;
    }

    public void setSelection(boolean bl) {
        this.checkWidget();
        this.selection = bl;
        this.redraw();
    }

    public void setText(String string) {
        this.checkWidget();
        this.text = string;
        this.redraw();
    }
}

