/*
 * Decompiled with CFR 0.152.
 */
package su.artix.accounting.domain;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.index.Indexed;
import su.artix.accounting.domain.AssetGroupTransaction;
import su.artix.accounting.domain.BeginAssetGroupTransaction;
import su.artix.accounting.domain.EndAssetGroupTransaction;
import su.artix.accounting.domain.Terminal;
import su.artix.accounting.domain.WidthAssetGroupTransaction;

@Entity
@Table(name="assetGroup")
public class AssetGroup
implements Serializable {
    private static final long serialVersionUID = -1057381199530027251L;
    @Id
    private String internalId;
    @Indexed
    private String groupId;
    private List<AssetGroupTransaction> changeOperations;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Indexed
    private Date begin;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Indexed
    private Date end;
    private int weight;
    @Indexed
    private boolean groupChanged = false;

    @javax.persistence.Id
    public String getInternalId() {
        return this.internalId;
    }

    public void setInternalId(String internalId) {
        this.internalId = internalId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public Date getBegin() {
        return this.begin;
    }

    public void setBegin(Date begin, Terminal terminal) {
        BeginAssetGroupTransaction dateTransaction = new BeginAssetGroupTransaction();
        dateTransaction.setDate(begin);
        dateTransaction.setTerminal(terminal);
        dateTransaction.setDateOfOperation(new Date());
        this.getChangeOperations().add(dateTransaction);
        this.begin = begin;
    }

    public Date getEnd() {
        return this.end;
    }

    public void setEnd(Date end, Terminal terminal) {
        EndAssetGroupTransaction dateTransaction = new EndAssetGroupTransaction();
        dateTransaction.setDate(end);
        dateTransaction.setTerminal(terminal);
        dateTransaction.setDateOfOperation(new Date());
        this.getChangeOperations().add(dateTransaction);
        this.end = end;
    }

    public void setWeight(Integer weight, Terminal terminal) {
        WidthAssetGroupTransaction weightTransaction = new WidthAssetGroupTransaction();
        weightTransaction.setWeight(weight);
        weightTransaction.setDateOfOperation(new Date());
        weightTransaction.setTerminal(terminal);
        this.getChangeOperations().add(weightTransaction);
        this.weight = weight;
    }

    public void setBegin(Date begin) {
        this.begin = begin;
    }

    public void setEnd(Date end) {
        this.end = end;
    }

    public void setWeight(Integer weight) {
        this.weight = weight;
    }

    public Integer getWeight() {
        return this.weight;
    }

    @OneToMany(cascade={CascadeType.ALL})
    @JoinColumn(name="group_id")
    public List<AssetGroupTransaction> getChangeOperations() {
        if (this.changeOperations == null) {
            this.changeOperations = new ArrayList<AssetGroupTransaction>();
        }
        return this.changeOperations;
    }

    public void setChangeOperations(List<AssetGroupTransaction> changeOperations) {
        this.changeOperations = changeOperations;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.begin == null ? 0 : this.begin.hashCode());
        result = 31 * result + (this.end == null ? 0 : this.end.hashCode());
        result = 31 * result + (this.groupId == null ? 0 : this.groupId.hashCode());
        result = 31 * result + (this.internalId == null ? 0 : this.internalId.hashCode());
        result = 31 * result + this.weight;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AssetGroup other = (AssetGroup)obj;
        if (this.begin == null ? other.begin != null : !this.begin.equals(other.begin)) {
            return false;
        }
        if (this.end == null ? other.end != null : !this.end.equals(other.end)) {
            return false;
        }
        if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
            return false;
        }
        if (this.internalId == null ? other.internalId != null : !this.internalId.equals(other.internalId)) {
            return false;
        }
        return this.weight == other.weight;
    }

    @Transient
    public boolean isGroupChanged() {
        return this.groupChanged;
    }

    public void setGroupChanged(boolean groupChanged) {
        this.groupChanged = groupChanged;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AssetGroup [internalId=");
        builder.append(this.internalId);
        builder.append(", groupId=");
        builder.append(this.groupId);
        builder.append(", begin=");
        builder.append(this.begin);
        builder.append(", end=");
        builder.append(this.end);
        builder.append(", weight=");
        builder.append(this.weight);
        builder.append("]");
        return builder.toString();
    }
}

