/*
 * Decompiled with CFR 0.152.
 */
package su.artix.cashserver.rest.client.entities;

import java.util.ArrayList;
import java.util.List;
import org.springframework.core.ParameterizedTypeReference;
import su.artix.cashserver.core.cashregistry.domain.SecurityRole;
import su.artix.cashserver.core.cashregistry.domain.WebUser;
import su.artix.cashserver.rest.client.RestInvoker;
import su.artix.cashserver.rest.client.RestInvokerManager;
import su.artix.cashserver.rest.domain.WebUserInfo;

public class WebUsersRestClient {
    private static final String WEB_USERS_URL = "webUsers";
    private final RestInvokerManager restInvokerManager;

    public WebUsersRestClient(RestInvokerManager restInvokerManager) {
        this.restInvokerManager = restInvokerManager;
    }

    private static WebUserInfo convertWebUserToWebUserInfo(WebUser webUser) {
        WebUserInfo info = new WebUserInfo();
        info.setName(webUser.getName());
        info.setPassword(webUser.getPassword());
        info.setUserRights(webUser.getUserRights());
        info.setClusterId(webUser.getClusterId());
        info.setMysqlLogin(webUser.getMysqlLogin());
        info.setMysqlPassword(webUser.getMysqlPassword());
        info.setBasePrefix(webUser.getBasePrefix());
        info.setDeptCode(webUser.getDeptCode());
        info.setSecurityRoleIds(new ArrayList());
        for (SecurityRole role : webUser.getSecurityRoles()) {
            if (role == null) continue;
            info.getSecurityRoleIds().add(role.getRoleName());
        }
        return info;
    }

    public Long countWebUsers() {
        return this.restInvokerManager.getRestInvoker().invokeGet("webUsers/count", Long.class);
    }

    public Boolean existsWebUser(String name) {
        return this.restInvokerManager.getRestInvoker().invokeGet(RestInvoker.urlBuild("webUsers/{0}/exists", name), Boolean.class);
    }

    public List<WebUser> getWebUsers() {
        ParameterizedTypeReference<List<WebUser>> returnTypeRef = new ParameterizedTypeReference<List<WebUser>>(){};
        return this.restInvokerManager.getRestInvoker().invokeGet(WEB_USERS_URL, returnTypeRef);
    }

    public List<WebUser> getWebUsers(int page, int size) {
        ParameterizedTypeReference<List<WebUser>> returnTypeRef = new ParameterizedTypeReference<List<WebUser>>(){};
        return this.restInvokerManager.getRestInvoker().invokeGet("webUsers?page=" + page + "&size=" + size, returnTypeRef);
    }

    public void addWebUser(WebUser webUser) {
        this.restInvokerManager.getRestInvoker().invokePost(WEB_USERS_URL, WebUsersRestClient.convertWebUserToWebUserInfo(webUser));
    }

    public WebUser getWebUser(String name) {
        return this.restInvokerManager.getRestInvoker().invokeGet(RestInvoker.urlBuild("webUsers/{0}", name), WebUser.class);
    }

    public WebUser getWebUser(String name, String password) {
        return this.restInvokerManager.getRestInvoker().invokeGet(RestInvoker.urlBuild("webUsers/{0}/{1}", name, password), WebUser.class);
    }

    public void updateWebUser(String name, WebUser webUser) {
        this.restInvokerManager.getRestInvoker().invokePut(RestInvoker.urlBuild("webUsers/{0}", name), WebUsersRestClient.convertWebUserToWebUserInfo(webUser));
    }

    public void removeWebUser(String name) {
        this.restInvokerManager.getRestInvoker().invokeDelete(RestInvoker.urlBuild("webUsers/{0}", name));
    }
}

