/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.query;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.query.Param;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.ParameterOutOfBoundsException;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parameters
implements Iterable<Parameter> {
    public static final List<Class<?>> TYPES = Arrays.asList(Pageable.class, Sort.class);
    private static final String ALL_OR_NOTHING = String.format("Either use @%s on all parameters except %s and %s typed once, or none at all!", Param.class.getSimpleName(), Pageable.class.getSimpleName(), Sort.class.getSimpleName());
    private final int pageableIndex;
    private final int sortIndex;
    private final List<Parameter> parameters;
    private final ParameterNameDiscoverer discoverer = new LocalVariableTableParameterNameDiscoverer();

    public Parameters(Method method) {
        Assert.notNull((Object)method);
        this.parameters = new ArrayList<Parameter>();
        List<Class<?>> types = Arrays.asList(method.getParameterTypes());
        for (int i = 0; i < types.size(); ++i) {
            MethodParameter parameter = new MethodParameter(method, i);
            parameter.initParameterNameDiscovery(this.discoverer);
            this.parameters.add(this.createParameter(parameter));
        }
        this.pageableIndex = types.indexOf(Pageable.class);
        this.sortIndex = types.indexOf(Sort.class);
        this.assertEitherAllParamAnnotatedOrNone();
    }

    private Parameters(List<Parameter> originals) {
        this.parameters = new ArrayList<Parameter>();
        int pageableIndexTemp = -1;
        int sortIndexTemp = -1;
        for (int i = 0; i < originals.size(); ++i) {
            Parameter original = originals.get(i);
            this.parameters.add(original);
            pageableIndexTemp = original.isPageable() ? i : -1;
            sortIndexTemp = original.isSort() ? i : -1;
        }
        this.pageableIndex = pageableIndexTemp;
        this.sortIndex = sortIndexTemp;
    }

    protected Parameter createParameter(MethodParameter parameter) {
        return new Parameter(parameter);
    }

    public boolean hasPageableParameter() {
        return this.pageableIndex != -1;
    }

    public int getPageableIndex() {
        return this.pageableIndex;
    }

    public int getSortIndex() {
        return this.sortIndex;
    }

    public boolean hasSortParameter() {
        return this.sortIndex != -1;
    }

    public boolean potentiallySortsDynamically() {
        return this.hasSortParameter() || this.hasPageableParameter();
    }

    public Parameter getParameter(int index) {
        try {
            return this.parameters.get(index);
        }
        catch (IndexOutOfBoundsException e) {
            throw new ParameterOutOfBoundsException(e);
        }
    }

    public boolean hasParameterAt(int position) {
        try {
            return null != this.getParameter(position);
        }
        catch (ParameterOutOfBoundsException e) {
            return false;
        }
    }

    public boolean hasSpecialParameter() {
        return this.hasSortParameter() || this.hasPageableParameter();
    }

    public int getNumberOfParameters() {
        return this.parameters.size();
    }

    public Parameters getBindableParameters() {
        ArrayList<Parameter> bindables = new ArrayList<Parameter>();
        for (Parameter candidate : this) {
            if (!candidate.isBindable()) continue;
            bindables.add(candidate);
        }
        return new Parameters(bindables);
    }

    public Parameter getBindableParameter(int bindableIndex) {
        return this.getBindableParameters().getParameter(bindableIndex);
    }

    private void assertEitherAllParamAnnotatedOrNone() {
        boolean nameFound = false;
        for (Parameter parameter : this.getBindableParameters()) {
            if (parameter.isNamedParameter()) {
                Assert.isTrue((nameFound || parameter.isFirst() ? 1 : 0) != 0, (String)ALL_OR_NOTHING);
                nameFound = true;
                continue;
            }
            Assert.isTrue((!nameFound ? 1 : 0) != 0, (String)ALL_OR_NOTHING);
        }
    }

    public static boolean isBindable(Class<?> type) {
        return !TYPES.contains(type);
    }

    @Override
    public Iterator<Parameter> iterator() {
        return this.parameters.iterator();
    }
}

