/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.ganttchart;

import java.util.Calendar;
import org.eclipse.nebula.widgets.ganttchart.ColorCache;
import org.eclipse.nebula.widgets.ganttchart.DateHelper;
import org.eclipse.nebula.widgets.ganttchart.GanttChart;
import org.eclipse.nebula.widgets.ganttchart.GanttComposite;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Rectangle;

public final class GanttPhase {
    private Calendar _startDate;
    private Calendar _endDate;
    private String _title;
    private boolean _locked;
    private Color _headerBgColor;
    private Color _headerFgColor;
    private Color _headerTextColor = ColorCache.getWhite();
    private Color _bodyTopColor;
    private Color _bodyBottomColor;
    private int _alpha = 255;
    private Object _data;
    private boolean _hidden;
    private boolean _resizable = true;
    private boolean _moveable = true;
    private boolean _drawBorders = true;
    private int _borderWidth = 1;
    private Color _borderColor;
    private long _start;
    private long _end;
    private Font _headerFont;
    private boolean _allowZeroWidth;
    private Rectangle _headerBounds;
    private Rectangle _bounds;
    private int _dDayStart;
    private int _dDayEnd;
    private GanttChart _parentChart;
    private GanttComposite _parentComposite;
    private int _daysBtwStartEnd;
    private Calendar _dragStartCal;
    private Calendar _dragEndCal;
    private long _dragStartLong;
    private long _dragEndLong;

    GanttPhase() {
        this._headerFgColor = ColorCache.getColor(74, 123, 173);
        this._headerBgColor = ColorCache.getColor(42, 83, 125);
        this._bodyTopColor = ColorCache.getColor(217, 238, 167);
        this._bodyBottomColor = ColorCache.getColor(155, 178, 99);
        this._borderColor = ColorCache.getColor(19, 50, 81);
    }

    public GanttPhase(GanttChart parent, String title) {
        this(parent, null, null, title);
    }

    public GanttPhase(GanttChart parent, Calendar start, Calendar end, String title) {
        this();
        this._parentChart = parent;
        this._title = title;
        this._parentComposite = parent.getGanttComposite();
        this.setStartDate(start);
        this.setEndDate(end);
        this._parentComposite.addPhase(this);
        this.updateDaysBetweenStartAndEnd();
    }

    public Calendar getStartDate() {
        return this._startDate;
    }

    public void setStartDate(Calendar startDate) {
        if (startDate == null) {
            this._startDate = null;
            this._start = -1L;
            return;
        }
        this._startDate = DateHelper.getNewCalendar(startDate);
        this._start = this._startDate.getTimeInMillis();
        this.updateDaysBetweenStartAndEnd();
    }

    public Calendar getEndDate() {
        return this._endDate;
    }

    public void setEndDate(Calendar endDate) {
        if (endDate == null) {
            this._endDate = null;
            this._end = -1L;
            return;
        }
        this._endDate = DateHelper.getNewCalendar(endDate);
        this._end = this._endDate.getTimeInMillis();
        this.updateDaysBetweenStartAndEnd();
    }

    public String getTitle() {
        return this._title;
    }

    public void setTitle(String title) {
        this._title = title;
    }

    public boolean isLocked() {
        return this._locked;
    }

    public void setLocked(boolean locked) {
        this._locked = locked;
    }

    public Color getHeaderBackgroundColor() {
        return this._headerBgColor;
    }

    public void setHeaderBackgroundColor(Color color) {
        this._headerBgColor = color;
    }

    public Color getHeaderForegroundColor() {
        return this._headerFgColor;
    }

    public void setHeaderForegroundColor(Color color) {
        this._headerFgColor = color;
    }

    public Color getBodyTopColor() {
        return this._bodyTopColor;
    }

    public void setBodyTopColor(Color bodyTopColor) {
        this._bodyTopColor = bodyTopColor;
    }

    public Color getBodyBottomColor() {
        return this._bodyBottomColor;
    }

    public void setBodyBottomColor(Color bodyBottomColor) {
        this._bodyBottomColor = bodyBottomColor;
    }

    public int getAlpha() {
        return this._alpha;
    }

    public void setAlpha(int alpha) {
        this._alpha = alpha;
    }

    public Object getData() {
        return this._data;
    }

    public void setData(Object data) {
        this._data = data;
    }

    public boolean isHidden() {
        return this._hidden;
    }

    public void setHidden(boolean hidden) {
        this._hidden = hidden;
    }

    public boolean isResizable() {
        return this._resizable;
    }

    public void setResizable(boolean resizable) {
        this._resizable = resizable;
    }

    public boolean isMoveable() {
        return this._moveable;
    }

    public void setMoveable(boolean moveable) {
        this._moveable = moveable;
    }

    public Font getHeaderFont() {
        return this._headerFont;
    }

    public void setHeaderFont(Font headerFont) {
        this._headerFont = headerFont;
    }

    public boolean isDrawBorders() {
        return this._drawBorders;
    }

    public void setDrawBorders(boolean drawBorders) {
        this._drawBorders = drawBorders;
    }

    public int getBorderWidth() {
        return this._borderWidth;
    }

    public void setBorderWidth(int borderWidth) {
        this._borderWidth = borderWidth;
    }

    public Color getBorderColor() {
        return this._borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this._borderColor = borderColor;
    }

    public void setStart(long start) {
        this._start = start;
    }

    public void setEnd(long end) {
        this._end = end;
    }

    public Color getHeaderTextColor() {
        return this._headerTextColor;
    }

    public void setHeaderTextColor(Color headerTextColor) {
        this._headerTextColor = headerTextColor;
    }

    public int getDDayStart() {
        return this._dDayStart;
    }

    public int getDDayRevisedStart() {
        return (int)DateHelper.daysBetween(this._parentComposite.getDDayCalendar(), this._startDate);
    }

    public int getDDayRevisedEnd() {
        return (int)DateHelper.daysBetween(this._parentComposite.getDDayCalendar(), this._endDate);
    }

    public void setDDayStart(int day) {
        this._dDayStart = day;
        this._startDate = this._parentComposite.getDDayCalendar();
        this._startDate.add(5, day);
        this.updateDaysBetweenStartAndEnd();
    }

    public int getDDayEnd() {
        return this._dDayEnd;
    }

    public void setDDayEnd(int day) {
        this._dDayEnd = day;
        this._endDate = this._parentComposite.getDDayCalendar();
        this._endDate.add(5, day);
        this.updateDaysBetweenStartAndEnd();
    }

    private void updateDaysBetweenStartAndEnd() {
        Calendar start = this.getStartDate();
        Calendar end = this.getEndDate();
        if (start == null || end == null) {
            this._daysBtwStartEnd = -1;
            return;
        }
        this._daysBtwStartEnd = (int)DateHelper.daysBetween(start, end);
        if (this._parentComposite.getCurrentView() == 5) {
            this._dDayStart = (int)DateHelper.daysBetween(this._parentComposite.getDDayCalendar(), start);
            this._dDayEnd = (int)DateHelper.daysBetween(this._parentComposite.getDDayCalendar(), end);
            --this._dDayStart;
        }
    }

    boolean isAllowZeroWidth() {
        return this._allowZeroWidth;
    }

    void setAllowZeroWidth(boolean allowZeroWidth) {
        this._allowZeroWidth = allowZeroWidth;
    }

    Rectangle getHeaderBounds() {
        return this._headerBounds;
    }

    void setHeaderBounds(Rectangle headerBounds) {
        this._headerBounds = headerBounds;
    }

    Rectangle getBounds() {
        return this._bounds;
    }

    void setBounds(Rectangle bounds) {
        this._bounds = bounds;
    }

    long getStart() {
        return this._start;
    }

    long getEnd() {
        return this._end;
    }

    boolean isDisplayable() {
        return this._startDate != null && this._endDate != null;
    }

    boolean overlaps(GanttPhase other) {
        return other.getStart() > this._start && other.getEnd() < this._end || other.getStart() < this._start && other.getEnd() > this._start;
    }

    boolean willOverlapResize(GanttPhase other, int calType, int val, boolean start) {
        Calendar temp = DateHelper.getNewCalendar(this._startDate);
        if (start) {
            temp.add(calType, val);
        }
        Calendar tempEnd = DateHelper.getNewCalendar(this._endDate);
        if (!start) {
            temp.add(calType, val);
        }
        long startMillis = temp.getTimeInMillis();
        long endMillis = tempEnd.getTimeInMillis();
        if (start) {
            return startMillis < other.getEnd();
        }
        return endMillis >= other.getStart() && other.getStart() >= this._startDate.getTimeInMillis();
    }

    void move(int calType, int val) {
        this._startDate.add(calType, val);
        this._endDate.add(calType, val);
        this._start = this._startDate.getTimeInMillis();
        this._end = this._endDate.getTimeInMillis();
        this.updateDaysBetweenStartAndEnd();
    }

    void moveStart(int calType, int val) {
        Calendar temp = DateHelper.getNewCalendar(this._startDate);
        temp.add(calType, val);
        Calendar tempEnd = DateHelper.getNewCalendar(this._endDate);
        if (!this.isAllowZeroWidth()) {
            tempEnd.add(calType, -1);
        }
        if (temp.after(tempEnd)) {
            return;
        }
        this.setStartDate(temp);
        this.updateDaysBetweenStartAndEnd();
    }

    void moveEnd(int calType, int val) {
        Calendar temp = DateHelper.getNewCalendar(this._endDate);
        temp.add(calType, val);
        Calendar tempStart = DateHelper.getNewCalendar(this._startDate);
        if (!this.isAllowZeroWidth()) {
            tempStart.add(calType, 1);
        }
        if (temp.before(tempStart)) {
            return;
        }
        this.setEndDate(temp);
        this.updateDaysBetweenStartAndEnd();
    }

    int getDaysBetweenStartAndEnd() {
        return this._daysBtwStartEnd;
    }

    void markDragStart() {
        this._dragStartLong = this._start;
        this._dragEndLong = this._end;
        this._dragStartCal = DateHelper.getNewCalendar(this._startDate);
        this._dragEndCal = DateHelper.getNewCalendar(this._endDate);
    }

    void undoLastDragDrop() {
        this._start = this._dragStartLong;
        this._end = this._dragEndLong;
        this.setStartDate(this._dragStartCal);
        this.setEndDate(this._dragEndCal);
        this.updateDaysBetweenStartAndEnd();
    }
}

