/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.dynamictablecolumns;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TreeColumn;
import org.mihalis.opal.dynamictablecolumns.DynamicColumnData;
import org.mihalis.opal.dynamictablecolumns.DynamicLength;
import org.mihalis.opal.dynamictablecolumns.DynamicLengthMeasure;

public class DynamicTableColumnLayout
extends Layout {
    private final List<DynamicColumnData> mcolumns = new LinkedList<DynamicColumnData>();
    private final List<DynamicColumnData> pcolumns = new LinkedList<DynamicColumnData>();
    private final Map<TableColumn, DynamicColumnData> mapColumnData = new HashMap<TableColumn, DynamicColumnData>();
    private final Map<Composite, Listener> installedListeners = new HashMap<Composite, Listener>();
    private int totalFixedWidth = 0;
    private double totalPerctWidth = 0.0;

    public void setColumnData(DynamicColumnData dynamicColumnData) {
        this.mapColumnData.put(dynamicColumnData.getTableColumn(), dynamicColumnData);
        this.mcolumns.add(dynamicColumnData);
        if (dynamicColumnData.getPreferredLength().getMeasure() == DynamicLengthMeasure.PERCENTAGE) {
            this.pcolumns.add(dynamicColumnData);
        }
    }

    public void setColumnData(TableColumn tableColumn, String string, String string2) {
        this.setColumnData(new DynamicColumnData(tableColumn, string, string2));
    }

    public void setColumnData(TableColumn tableColumn, String string) {
        this.setColumnData(new DynamicColumnData(tableColumn, string));
    }

    protected Point computeSize(final Composite composite, int n, int n2, boolean bl) {
        Object object;
        if (this.installedListeners.get(composite) == null) {
            object = new Listener(){

                public void handleEvent(Event event) {
                    composite.layout();
                }
            };
            composite.addListener(11, (Listener)object);
            this.installedListeners.put(composite, (Listener)object);
        }
        object = composite.getChildren()[0];
        Point point = object.computeSize(n, n2);
        int n3 = Math.max(0, point.x);
        int n4 = Math.max(0, point.y);
        if (n != -1) {
            n3 = n;
        }
        if (n2 != -1) {
            n4 = n2;
        }
        return new Point(n3, n4);
    }

    protected void layout(Composite composite, boolean bl) {
        DynamicLength dynamicLength;
        Rectangle rectangle = composite.getClientArea();
        Scrollable scrollable = this.getControl(composite);
        scrollable.setBounds(rectangle);
        Rectangle rectangle2 = scrollable.getClientArea();
        this.totalFixedWidth = 0;
        this.totalPerctWidth = 0.0;
        for (DynamicColumnData object : this.mcolumns) {
            if (!object.isVisible()) continue;
            DynamicLength dynamicLength2 = object.getPreferredLength();
            dynamicLength = object.getMinLength();
            if (dynamicLength2.getValue() != 0.0) {
                this.addTotalLength(dynamicLength2);
                continue;
            }
            this.addTotalLength(dynamicLength);
        }
        Integer n = rectangle2.width - this.totalFixedWidth;
        for (DynamicColumnData dynamicColumnData : this.mcolumns) {
            if (dynamicColumnData.isVisible()) {
                dynamicLength = dynamicColumnData.getPreferredLength();
                Double d = dynamicLength.getValue();
                DynamicLengthMeasure dynamicLengthMeasure = dynamicLength.getMeasure();
                DynamicLength dynamicLength3 = dynamicColumnData.getMinLength();
                Double d2 = dynamicLength3.getValue();
                switch (dynamicLengthMeasure) {
                    case PIXEL: {
                        this.updateColumnWidth(dynamicColumnData, Math.max(d, d2));
                        break;
                    }
                    case PERCENTAGE: {
                        double d3 = d / this.totalPerctWidth;
                        int n2 = (int)(d3 * (double)n.intValue());
                        this.updateColumnWidth(dynamicColumnData, Math.max((double)n2, d2));
                    }
                }
                continue;
            }
            this.updateColumnWidth(dynamicColumnData, 0.0);
        }
    }

    private boolean addTotalLength(DynamicLength dynamicLength) {
        switch (dynamicLength.getMeasure()) {
            case PIXEL: {
                this.totalFixedWidth = (int)((double)this.totalFixedWidth + dynamicLength.getValue());
                break;
            }
            case PERCENTAGE: {
                this.totalPerctWidth += dynamicLength.getValue().doubleValue();
            }
        }
        return dynamicLength.getValue() != 0.0;
    }

    public void redistributePercentage(TableColumn tableColumn, Double d) {
        int n = this.pcolumns.size() - 1;
        for (DynamicColumnData dynamicColumnData : this.pcolumns) {
            DynamicLength dynamicLength = dynamicColumnData.getPreferredLength();
            if (tableColumn == dynamicColumnData.getTableColumn()) continue;
            dynamicLength.setValue(dynamicLength.getValue() + d / (double)n);
        }
    }

    private void updateColumnWidth(DynamicColumnData dynamicColumnData, Double d) {
        TableColumn tableColumn = dynamicColumnData.getTableColumn();
        TreeColumn treeColumn = dynamicColumnData.getTreeColumn();
        if (tableColumn != null) {
            tableColumn.setWidth(d.intValue());
        } else if (treeColumn != null) {
            treeColumn.setWidth(d.intValue());
        } else {
            throw new IllegalStateException("No valid to set the column width!");
        }
    }

    public DynamicColumnData getColumnData(TableColumn tableColumn) {
        return this.mapColumnData.get(tableColumn);
    }

    Scrollable getControl(Composite composite) {
        return (Scrollable)composite.getChildren()[0];
    }
}

