/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.header;

import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.mihalis.opal.utils.SWTGraphicUtil;

public class Header
extends Composite {
    private Image image;
    private String title;
    private String description;
    private Font titleFont;
    private Color titleColor;
    private Image previousGeneratedImage;
    private Color gradientEnd;
    private Color gradientStart;
    private Color separatorColor;

    public Header(Composite composite, int n) {
        super(composite, n);
        this.initFontAndColors();
        this.setBackgroundMode(2);
        this.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                Header.this.redrawComposite();
            }
        });
    }

    private void initFontAndColors() {
        Color color;
        Color color2;
        Color color3;
        Font font;
        FontData fontData;
        FontData[] fontDataArray = this.getFont().getFontData();
        if (fontDataArray != null && fontDataArray.length > 0) {
            fontData = fontDataArray[0];
            fontData.setStyle(1);
            fontData.setHeight(fontData.getHeight() + 2);
            font = new Font((Device)this.getDisplay(), fontData);
        } else {
            font = null;
        }
        this.titleFont = font;
        SWTGraphicUtil.addDisposer((Widget)this, font);
        fontData = new Color((Device)this.getDisplay(), 0, 88, 150);
        this.titleColor = fontData;
        SWTGraphicUtil.addDisposer((Widget)this, (Resource)fontData);
        this.gradientEnd = color3 = new Color((Device)this.getDisplay(), 239, 239, 239);
        SWTGraphicUtil.addDisposer((Widget)this, (Resource)color3);
        this.gradientStart = color2 = new Color((Device)this.getDisplay(), 255, 255, 255);
        SWTGraphicUtil.addDisposer((Widget)this, (Resource)color2);
        this.separatorColor = color = new Color((Device)this.getDisplay(), 229, 229, 229);
        SWTGraphicUtil.addDisposer((Widget)this, (Resource)color);
    }

    private void redrawComposite() {
        for (Control control : this.getChildren()) {
            control.dispose();
        }
        int n = 1;
        if (this.image != null) {
            ++n;
        }
        super.setLayout((Layout)new GridLayout(n, false));
        this.createContent();
        this.drawBackground();
    }

    private void createContent() {
        if (this.title != null) {
            this.createTitle();
        }
        if (this.image != null) {
            this.createImage();
        }
        if (this.description != null) {
            this.createDescription();
        }
    }

    private void createTitle() {
        Label label = new Label((Composite)this, 0);
        label.setLayoutData((Object)new GridData(4, 1, true, false));
        label.setFont(this.titleFont);
        label.setForeground(this.titleColor);
        label.setText(this.title);
    }

    private void createImage() {
        int n = 1;
        if (this.title != null && this.description != null) {
            ++n;
        }
        Label label = new Label((Composite)this, 0);
        label.setLayoutData((Object)new GridData(4, 1, false, true, 1, n));
        label.setImage(this.image);
    }

    private void createDescription() {
        StyledText styledText = new StyledText((Composite)this, 72);
        styledText.setLayoutData((Object)new GridData(4, 4, true, true));
        styledText.setEnabled(false);
        styledText.setFont(this.getFont());
        styledText.setForeground(this.getForeground());
        styledText.setText(this.description);
        SWTGraphicUtil.applyHTMLFormating(styledText);
    }

    private void drawBackground() {
        Display display = this.getDisplay();
        Rectangle rectangle = this.getClientArea();
        Image image = new Image((Device)display, Math.max(1, rectangle.width), Math.max(1, rectangle.height));
        GC gC = new GC((Drawable)image);
        gC.setForeground(this.gradientStart);
        gC.setBackground(this.gradientEnd);
        gC.fillGradientRectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height, false);
        gC.setForeground(this.separatorColor);
        gC.drawLine(rectangle.x, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width, rectangle.y + rectangle.height - 1);
        gC.dispose();
        this.setBackgroundImage(image);
        if (this.previousGeneratedImage != null) {
            this.previousGeneratedImage.dispose();
        }
        this.previousGeneratedImage = image;
    }

    public void setLayout(Layout layout) {
        throw new UnsupportedOperationException("Not supported");
    }

    public String getDescription() {
        this.checkWidget();
        return this.description;
    }

    public Color getGradientEnd() {
        this.checkWidget();
        return this.gradientEnd;
    }

    public Color getGradientStart() {
        this.checkWidget();
        return this.gradientStart;
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    public Color getSeparatorColor() {
        this.checkWidget();
        return this.separatorColor;
    }

    public String getTitle() {
        this.checkWidget();
        return this.title;
    }

    public Color getTitleColor() {
        this.checkWidget();
        return this.titleColor;
    }

    public Font getTitleFont() {
        this.checkWidget();
        return this.titleFont;
    }

    public void setDescription(String string) {
        this.checkWidget();
        this.description = string;
    }

    public void setGradientEnd(Color color) {
        this.checkWidget();
        this.gradientEnd = color;
    }

    public void setGradientStart(Color color) {
        this.checkWidget();
        this.gradientStart = color;
    }

    public void setImage(Image image) {
        this.checkWidget();
        this.image = image;
    }

    public void setSeparatorColor(Color color) {
        this.separatorColor = color;
    }

    public void setTitle(String string) {
        this.checkWidget();
        this.title = string;
    }

    public void setTitleColor(Color color) {
        this.checkWidget();
        this.titleColor = color;
    }

    public void setTitleFont(Font font) {
        this.checkWidget();
        this.titleFont = font;
    }
}

