/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.infinitePanel;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.mihalis.opal.utils.SWTGraphicUtil;

public class InfiniteProgressPanel {
    private static final String INFINITE_PANEL_KEY = "org.mihalis.opal.InfinitePanel.InfiniteProgressPanel";
    private static final int NUMBER_OF_STEPS = 10;
    private final Shell parent;
    private Shell shellHover;
    private String text;
    private Font textFont;
    private Color textColor;
    private float fps;
    private int barsCount;
    private int lineWidth;
    private int alpha;
    private Color defaultColor;
    private Color selectionColor;
    private int currentPosition;
    private Thread animatorThread;
    private Canvas canvas;
    private boolean fadeIn;
    private boolean fadeOut;
    private int fadeOutCounter;

    private InfiniteProgressPanel(Shell shell) {
        if (shell == null) {
            SWT.error((int)4);
        }
        if (shell.isDisposed()) {
            SWT.error((int)5);
        }
        this.parent = shell;
        if (shell.getData(INFINITE_PANEL_KEY) != null) {
            throw new IllegalArgumentException("This shell has already an infinite panel attached on it !");
        }
        this.text = null;
        this.textFont = null;
        this.barsCount = 14;
        this.fps = 15.0f;
        this.lineWidth = 16;
        this.alpha = 200;
        this.fadeIn = false;
        this.fadeOut = false;
        this.fadeOutCounter = 0;
        shell.setData(INFINITE_PANEL_KEY, (Object)this);
        this.parent.addListener(26, new Listener(){

            public void handleEvent(Event event) {
                if (InfiniteProgressPanel.this.shellHover != null && !InfiniteProgressPanel.this.shellHover.isDisposed() && !InfiniteProgressPanel.this.shellHover.isVisible()) {
                    InfiniteProgressPanel.this.shellHover.setVisible(true);
                    InfiniteProgressPanel.this.shellHover.setActive();
                }
            }
        });
    }

    public void start() {
        if (this.parent.isDisposed()) {
            SWT.error((int)24);
        }
        this.currentPosition = 0;
        this.fadeIn = true;
        this.fadeOut = false;
        this.fadeOutCounter = 0;
        if (this.defaultColor == null) {
            this.defaultColor = SWTGraphicUtil.getDefaultColor((Control)this.parent, 200, 200, 200);
        }
        if (this.selectionColor == null) {
            this.selectionColor = this.parent.getDisplay().getSystemColor(2);
        }
        this.createShell();
        this.createAndRunAnimatorThread();
    }

    private void createShell() {
        this.shellHover = new Shell(this.parent, 81928);
        this.shellHover.setLayout((Layout)new FillLayout());
        this.shellHover.setAlpha(0);
        this.shellHover.addListener(2, new Listener(){

            public void handleEvent(Event event) {
                event.doit = false;
            }
        });
        this.shellHover.addListener(27, new Listener(){

            public void handleEvent(Event event) {
                InfiniteProgressPanel.this.shellHover.setVisible(false);
            }
        });
        this.shellHover.setBounds(this.shellHover.getDisplay().map((Control)this.parent, null, this.parent.getClientArea()));
        this.canvas = new Canvas((Composite)this.shellHover, 0x20040000);
        this.canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                InfiniteProgressPanel.this.paintCanvas(paintEvent);
            }
        });
        this.shellHover.open();
    }

    private void createAndRunAnimatorThread() {
        this.animatorThread = new Thread(){

            @Override
            public void run() {
                while (!Thread.interrupted()) {
                    InfiniteProgressPanel.this.currentPosition = (InfiniteProgressPanel.this.currentPosition + 1) % InfiniteProgressPanel.this.barsCount;
                    if (InfiniteProgressPanel.this.fadeOut) {
                        InfiniteProgressPanel.this.fadeOutCounter++;
                    }
                    InfiniteProgressPanel.this.shellHover.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            InfiniteProgressPanel.this.canvas.redraw();
                        }
                    });
                    try {
                        5.sleep(InfiniteProgressPanel.this.fadeOut ? 20L : (long)(1000.0f / InfiniteProgressPanel.this.fps));
                    }
                    catch (InterruptedException interruptedException) {
                        break;
                    }
                }
            }
        };
        this.animatorThread.start();
    }

    private void paintCanvas(PaintEvent paintEvent) {
        Rectangle rectangle = ((Canvas)paintEvent.widget).getClientArea();
        GC gC = paintEvent.gc;
        this.handleFadeIn();
        this.handleFadeOut();
        this.drawBackground(rectangle, gC);
        this.drawTicker(rectangle, gC);
        this.drawText(rectangle, gC);
    }

    private void handleFadeIn() {
        if (this.fadeIn) {
            if (this.currentPosition == 10) {
                this.fadeIn = false;
                this.shellHover.setAlpha(this.alpha);
            } else {
                this.shellHover.setAlpha(this.currentPosition * this.alpha / 10);
            }
        }
    }

    private void handleFadeOut() {
        if (this.fadeOut) {
            if (this.fadeOutCounter == 10) {
                if (this.animatorThread != null) {
                    this.animatorThread.interrupt();
                    this.animatorThread = null;
                }
                if (!this.shellHover.isDisposed()) {
                    this.shellHover.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!InfiniteProgressPanel.this.shellHover.isDisposed()) {
                                InfiniteProgressPanel.this.shellHover.dispose();
                            }
                        }
                    });
                }
            }
            this.shellHover.setAlpha(255 - this.fadeOutCounter * this.alpha / 10);
        }
    }

    private void drawBackground(Rectangle rectangle, GC gC) {
        gC.setBackground(this.shellHover.getDisplay().getSystemColor(1));
        gC.fillRectangle(rectangle);
    }

    private void drawTicker(Rectangle rectangle, GC gC) {
        int n = rectangle.width / 2;
        int n2 = rectangle.height / 2;
        int n3 = (int)((float)Math.min(rectangle.width, rectangle.height) * 0.6f) / 2;
        int n4 = (int)((float)n3 * 0.5f);
        double d = 1.5707963267948966;
        gC.setLineCap(2);
        gC.setLineWidth(this.lineWidth);
        gC.setAntialias(1);
        double d2 = Math.PI * 2 / (double)this.barsCount;
        for (int i = 0; i < this.barsCount; ++i) {
            if (i == this.currentPosition) {
                gC.setForeground(this.selectionColor);
            } else {
                gC.setForeground(this.defaultColor);
            }
            gC.drawLine((int)((double)n + (double)n4 * Math.cos(d)), (int)((double)n2 - (double)n4 * Math.sin(d)), (int)((double)n + (double)n3 * Math.cos(d)), (int)((double)n2 - (double)n3 * Math.sin(d)));
            d -= d2;
        }
    }

    private void drawText(Rectangle rectangle, GC gC) {
        if (this.text == null || "".equals(this.text)) {
            return;
        }
        Font font = this.textFont == null ? this.parent.getDisplay().getSystemFont() : this.textFont;
        Color color = this.textColor == null ? this.parent.getDisplay().getSystemColor(2) : this.textColor;
        gC.setForeground(color);
        gC.setFont(font);
        gC.setTextAntialias(1);
        Point point = gC.textExtent(this.text, 1);
        int n = point.x;
        int n2 = point.y;
        gC.drawString(this.text, (rectangle.width - n) / 2, (rectangle.height - n2) / 2, true);
    }

    public void stop() {
        if (this.shellHover.isDisposed() || this.shellHover.getDisplay().isDisposed()) {
            return;
        }
        this.fadeOut = true;
    }

    public static InfiniteProgressPanel getInfiniteProgressPanelFor(final Shell shell) {
        if (shell == null) {
            SWT.error((int)4);
        }
        if (shell.isDisposed()) {
            SWT.error((int)24);
        }
        if (shell.getDisplay().isDisposed()) {
            SWT.error((int)45);
        }
        final InfiniteProgressPanel[] infiniteProgressPanelArray = new InfiniteProgressPanel[1];
        shell.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                Object object = shell.getData(InfiniteProgressPanel.INFINITE_PANEL_KEY);
                if (object != null && object instanceof InfiniteProgressPanel) {
                    infiniteProgressPanelArray[0] = (InfiniteProgressPanel)object;
                }
            }
        });
        if (infiniteProgressPanelArray[0] == null) {
            return new InfiniteProgressPanel(shell);
        }
        return infiniteProgressPanelArray[0];
    }

    public static boolean hasInfiniteProgressPanel(Shell shell) {
        return InfiniteProgressPanel.getInfiniteProgressPanelFor(shell) != null;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public void setAlpha(int n) {
        if (n < 0 || n > 255) {
            SWT.error((int)5);
        }
        this.checkIfAnimationIsRunning();
        this.alpha = n;
    }

    private void checkIfAnimationIsRunning() {
        if (this.animatorThread != null) {
            SWT.error((int)5, null, (String)"Can not change this value when an animation is running");
        }
    }

    public int getBarsCount() {
        return this.barsCount;
    }

    public void setBarsCount(int n) {
        this.checkIfAnimationIsRunning();
        this.barsCount = n;
    }

    public Color getDefaultColor() {
        return this.defaultColor;
    }

    public void setDefaultColor(Color color) {
        this.checkIfAnimationIsRunning();
        SWTGraphicUtil.safeDispose((Resource)this.defaultColor);
        this.defaultColor = color;
    }

    public float getFps() {
        return this.fps;
    }

    public void setFps(float f) {
        this.checkIfAnimationIsRunning();
        this.fps = f;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(int n) {
        this.checkIfAnimationIsRunning();
        this.lineWidth = n;
    }

    public Color getSelectionColor() {
        return this.selectionColor;
    }

    public void setSelectionColor(Color color) {
        this.checkIfAnimationIsRunning();
        this.selectionColor = color;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.checkIfAnimationIsRunning();
        this.text = string;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color color) {
        this.checkIfAnimationIsRunning();
        this.textColor = color;
    }

    public Font getTextFont() {
        return this.textFont;
    }

    public void setTextFont(Font font) {
        this.checkIfAnimationIsRunning();
        this.textFont = font;
    }
}

