/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.promptSupport;

import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.mihalis.opal.promptSupport.BaseFocusControlListener;
import org.mihalis.opal.promptSupport.FocusControlListenerFactory;

public class PromptSupport {
    private static final String KEY = "org.mihalis.opal.promptSupport.PromptSupport";
    static final String BACKGROUND = "org.mihalis.opal.promptSupport.PromptSupport.background";
    static final String FOREGROUND = "org.mihalis.opal.promptSupport.PromptSupport.foreground";
    static final String STYLE = "org.mihalis.opal.promptSupport.PromptSupport.style";
    static final String BEHAVIOR = "org.mihalis.opal.promptSupport.PromptSupport.behavior";
    static final String PROMPT = "org.mihalis.opal.promptSupport.PromptSupport.prompt";
    static final String SET = "org.mihalis.opal.promptSupport.PromptSupport.set";

    public static void init(String string, Color color, Color color2, Control control) {
        if (string != null && string.length() > 0) {
            PromptSupport.setPrompt(string, control);
        }
        if (color != null) {
            PromptSupport.setForeground(color, control);
        }
        if (color2 != null) {
            PromptSupport.setBackground(color2, control);
        }
    }

    public static Color getBackground(Control control) {
        Color color = (Color)control.getData(BACKGROUND);
        return color == null ? control.getBackground() : color;
    }

    public static void setBackground(Color color, Control control) {
        PromptSupport.checkControl(control);
        control.setData(BACKGROUND, (Object)color);
    }

    public static FocusBehavior getFocusBehavior(Control control) {
        FocusBehavior focusBehavior = (FocusBehavior)((Object)control.getData(BEHAVIOR));
        return focusBehavior == null ? FocusBehavior.HIDE_PROMPT : focusBehavior;
    }

    public static void setFocusBehavior(FocusBehavior focusBehavior, Control control) {
        PromptSupport.checkControl(control);
        control.setData(BEHAVIOR, (Object)focusBehavior);
    }

    public static int getFontStyle(Control control) {
        Integer n = (Integer)control.getData(STYLE);
        return n == null ? 2 : n;
    }

    public static void setFontStyle(int n, Control control) {
        PromptSupport.checkControl(control);
        control.setData(STYLE, (Object)n);
    }

    public static Color getForeground(Control control) {
        Color color = (Color)control.getData(FOREGROUND);
        return color == null ? control.getForeground() : color;
    }

    public static void setForeground(Color color, Control control) {
        PromptSupport.checkControl(control);
        control.setData(FOREGROUND, (Object)color);
    }

    public static String getPrompt(Control control) {
        return (String)control.getData(PROMPT);
    }

    public static void setPrompt(String string, Control control) {
        boolean bl;
        PromptSupport.checkControl(control);
        boolean bl2 = bl = control.getData(SET) == null ? false : (Boolean)control.getData(SET);
        if (bl) {
            throw new IllegalArgumentException("A prompt has already been set on this control !");
        }
        control.setData(PROMPT, (Object)string);
        BaseFocusControlListener baseFocusControlListener = FocusControlListenerFactory.getFocusControlListenerFor(control);
        control.addFocusListener((FocusListener)baseFocusControlListener);
        control.addControlListener((ControlListener)baseFocusControlListener);
        control.setData(SET, (Object)true);
    }

    private static void checkControl(Control control) {
        if (!(control instanceof Text || control instanceof Combo || control instanceof StyledText || control instanceof CCombo)) {
            throw new IllegalArgumentException("PromptSupport can only be used on a Text, a Combo, a StyledText or a CCombo widget.");
        }
    }

    public static enum FocusBehavior {
        HIGHLIGHT_PROMPT,
        HIDE_PROMPT;

    }
}

