/*
 * Decompiled with CFR 0.152.
 */
package su.artix.artixadmin.connection;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.datasource.AbstractDataSource;
import org.springframework.jdbc.datasource.lookup.DataSourceLookup;
import org.springframework.jdbc.datasource.lookup.JndiDataSourceLookup;
import org.springframework.util.Assert;
import su.artix.artixadmin.connection.ArtixAdminContextHolder;
import su.artix.artixadmin.connection.ManagedDataSource;

public class ArtixAdminRoutingDataSource
extends AbstractDataSource
implements ManagedDataSource {
    private static final Logger log = LoggerFactory.getLogger(ArtixAdminRoutingDataSource.class);
    private boolean lenientFallback = true;
    private DataSourceLookup dataSourceLookup = new JndiDataSourceLookup();
    private Map<Object, DataSource> resolvedDataSources = new HashMap<Object, DataSource>();
    private DataSource resolvedDefaultDataSource;

    protected Object determineCurrentLookupKey() {
        return ArtixAdminContextHolder.getConnectionId();
    }

    public void setLenientFallback(boolean lenientFallback) {
        this.lenientFallback = lenientFallback;
    }

    public void setDataSourceLookup(DataSourceLookup dataSourceLookup) {
        this.dataSourceLookup = dataSourceLookup != null ? dataSourceLookup : new JndiDataSourceLookup();
    }

    @Override
    public void put(Object id, DataSource inputDataSource) {
        if (this.resolvedDataSources.containsKey(id)) {
            log.trace("id:{} already in map, don't put", id);
        } else {
            log.trace("put datasource with id={}", id);
            Object lookupKey = this.resolveSpecifiedLookupKey(id);
            DataSource dataSource = this.resolveSpecifiedDataSource(inputDataSource);
            this.resolvedDataSources.put(lookupKey, dataSource);
        }
    }

    protected DataSource resolveSpecifiedDataSource(Object dataSource) {
        if (dataSource instanceof DataSource) {
            return (DataSource)dataSource;
        }
        if (dataSource instanceof String) {
            return this.dataSourceLookup.getDataSource((String)dataSource);
        }
        throw new IllegalArgumentException("Illegal data source value - only [javax.sql.DataSource] and String supported: " + dataSource);
    }

    public Connection getConnection() throws SQLException {
        return this.determineTargetDataSource().getConnection();
    }

    public Connection getConnection(String username, String password) throws SQLException {
        return this.determineTargetDataSource().getConnection(username, password);
    }

    protected DataSource determineTargetDataSource() {
        Assert.notNull(this.resolvedDataSources, (String)"DataSource router not initialized");
        Object lookupKey = this.determineCurrentLookupKey();
        DataSource dataSource = this.resolvedDataSources.get(lookupKey);
        if (dataSource == null && (this.lenientFallback || lookupKey == null)) {
            dataSource = this.resolvedDefaultDataSource;
        }
        if (dataSource == null) {
            throw new IllegalStateException("Cannot determine target DataSource for lookup key [" + lookupKey + "]");
        }
        return dataSource;
    }

    protected Object resolveSpecifiedLookupKey(Object lookupKey) {
        return lookupKey;
    }

    @Override
    public void closeConnections() {
        for (DataSource dataSource : this.resolvedDataSources.values()) {
            if (!(dataSource instanceof ComboPooledDataSource)) continue;
            ((ComboPooledDataSource)dataSource).close();
        }
        this.resolvedDataSources.clear();
    }
}

