/*
 * Decompiled with CFR 0.152.
 */
package su.artix.cashserver.rest.client.entities;

import java.util.List;
import org.springframework.core.ParameterizedTypeReference;
import su.artix.cashserver.core.cashregistry.domain.Cluster;
import su.artix.cashserver.rest.client.RestInvoker;
import su.artix.cashserver.rest.client.RestInvokerManager;

public class ClustersRestClient {
    private static final String CLUSTERS_URL = "clusters";
    private final RestInvokerManager restInvokerManager;

    public ClustersRestClient(RestInvokerManager restInvokerManager) {
        this.restInvokerManager = restInvokerManager;
    }

    public Long countClusters() {
        return this.restInvokerManager.getRestInvoker().invokeGet("clusters/count", Long.class);
    }

    public Boolean existsCluster(String id) {
        return this.restInvokerManager.getRestInvoker().invokeGet(RestInvoker.urlBuild("clusters/{0}/exists", ClustersRestClient.convertClusterId(id)), Boolean.class);
    }

    public List<Cluster> getClusters() {
        ParameterizedTypeReference<List<Cluster>> returnTypeRef = new ParameterizedTypeReference<List<Cluster>>(){};
        return this.restInvokerManager.getRestInvoker().invokeGet(CLUSTERS_URL, returnTypeRef);
    }

    public List<Cluster> getClusters(int page, int size) {
        ParameterizedTypeReference<List<Cluster>> returnTypeRef = new ParameterizedTypeReference<List<Cluster>>(){};
        return this.restInvokerManager.getRestInvoker().invokeGet("clusters?page=" + page + "&size=" + size, returnTypeRef);
    }

    public Cluster getCluster(String id) {
        return this.restInvokerManager.getRestInvoker().invokeGet(RestInvoker.urlBuild("clusters/{0}", ClustersRestClient.convertClusterId(id)), Cluster.class);
    }

    private static String convertClusterId(String id) {
        return "".equals(id) ? "DEFAULT_CLUSTER_ID" : id;
    }
}

