/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.cashadmin.domain.payment;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.annotations.Target;
import ru.ssa.cashadmin.domain.Invent;
import ru.ssa.cashadmin.domain.payment.Supplier;
import ru.ssa.cashadmin.domain.payment.TmcSupplierPK;

@Entity
@Table(name="tmcsupplier")
@MappedSuperclass
public class TmcSupplier
implements Serializable {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    private TmcSupplierPK pk = new TmcSupplierPK();
    @Column(name="tmccode", insertable=false, updatable=false)
    private String tmccode;
    @ManyToOne
    @JoinColumn(name="tmccode", referencedColumnName="code", insertable=false, updatable=false)
    @NotFound(action=NotFoundAction.IGNORE)
    @Target(value=Invent.class)
    @NotNull
    private Invent invent;
    @ManyToOne
    @JoinColumn(name="suppliercode", referencedColumnName="code", insertable=false, updatable=false)
    @NotFound(action=NotFoundAction.IGNORE)
    @NotNull
    private Supplier supplier;
    @Column(name="suppliercode", insertable=false, updatable=false)
    private String supplierCode;
    @NotNull
    @Column(name="agentpaymentobject")
    private Integer agentPaymentobject;

    protected TmcSupplier() {
    }

    public TmcSupplierPK getPk() {
        return this.pk;
    }

    public void setPk(TmcSupplierPK pk) {
        this.pk = pk;
    }

    public String getTmccode() {
        return this.tmccode;
    }

    public void setTmccode(String tmccode) {
        this.tmccode = tmccode;
    }

    public Invent getInvent() {
        return this.invent;
    }

    public void setInvent(Invent invent) {
        this.invent = invent;
        if (invent != null) {
            this.tmccode = invent.getCode();
            this.pk.setTmccode(invent.getCode());
        } else {
            this.tmccode = null;
            this.pk.setTmccode(null);
        }
    }

    public String getSupplierCode() {
        return this.supplierCode;
    }

    public void setSupplierCode(String supplierCode) {
        this.supplierCode = supplierCode;
    }

    public Supplier getSupplier() {
        return this.supplier;
    }

    public void setSupplier(Supplier supplier) {
        this.supplier = supplier;
        if (supplier != null) {
            this.supplierCode = supplier.getCode();
            this.pk.setSupplierCode(supplier.getCode());
        } else {
            this.supplierCode = null;
            this.pk.setSupplierCode(null);
        }
    }

    public Integer getAgentPaymentobject() {
        return this.agentPaymentobject;
    }

    public void setAgentPaymentobject(Integer agentPaymentobject) {
        this.agentPaymentobject = agentPaymentobject;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.pk == null ? 0 : this.pk.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TmcSupplier other = (TmcSupplier)obj;
        return !(this.pk == null ? other.pk != null : !this.pk.equals(other.pk));
    }

    public String toString() {
        return "TmcSupplier [pk=" + this.pk + ", agentPaymentobject=" + this.agentPaymentobject + "]";
    }
}

