/*
 * Decompiled with CFR 0.152.
 */
package org.dozer.classmap;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.dozer.Mapping;
import org.dozer.classmap.ClassMap;
import org.dozer.classmap.ClassMappings;
import org.dozer.classmap.Configuration;
import org.dozer.classmap.DozerClass;
import org.dozer.classmap.generator.BeanMappingGenerator;
import org.dozer.classmap.generator.GeneratorUtils;
import org.dozer.fieldmap.DozerField;
import org.dozer.fieldmap.GenericFieldMap;
import org.dozer.fieldmap.MapFieldMap;
import org.dozer.util.MappingUtils;
import org.dozer.util.ReflectionUtils;

public final class ClassMapBuilder {
    static final List<ClassMappingGenerator> buildTimeGenerators = new ArrayList<ClassMappingGenerator>();
    static final List<ClassMappingGenerator> runTimeGenerators = new ArrayList<ClassMappingGenerator>();

    private ClassMapBuilder() {
    }

    public static ClassMap createDefaultClassMap(Configuration globalConfiguration, Class<?> srcClass, Class<?> destClass) {
        ClassMap classMap = new ClassMap(globalConfiguration);
        classMap.setSrcClass(new DozerClass(srcClass.getName(), srcClass, globalConfiguration.getBeanFactory(), null, null, null, null, globalConfiguration.getMapNull(), globalConfiguration.getMapEmptyString(), false));
        classMap.setDestClass(new DozerClass(destClass.getName(), destClass, globalConfiguration.getBeanFactory(), null, null, null, null, globalConfiguration.getMapNull(), globalConfiguration.getMapEmptyString(), false));
        ClassMapBuilder.generateMapping(classMap, globalConfiguration, buildTimeGenerators);
        return classMap;
    }

    public static void addDefaultFieldMappings(ClassMappings classMappings, Configuration globalConfiguration) {
        Set<Map.Entry<String, ClassMap>> entries = classMappings.getAll().entrySet();
        for (Map.Entry<String, ClassMap> entry : entries) {
            ClassMap classMap = entry.getValue();
            ClassMapBuilder.generateMapping(classMap, globalConfiguration, runTimeGenerators);
        }
    }

    private static void generateMapping(ClassMap classMap, Configuration configuration, List<ClassMappingGenerator> mappingGenerators) {
        if (!classMap.isWildcard()) {
            return;
        }
        for (ClassMappingGenerator generator : mappingGenerators) {
            if (!generator.accepts(classMap) || !generator.apply(classMap, configuration)) continue;
            return;
        }
    }

    private static void addFieldMapping(ClassMap classMap, Configuration configuration, String srcName, String destName) {
        GenericFieldMap fieldMap = new GenericFieldMap(classMap);
        DozerField sourceField = new DozerField(srcName, null);
        DozerField destField = new DozerField(destName, null);
        sourceField.setAccessible(true);
        destField.setAccessible(true);
        fieldMap.setSrcField(sourceField);
        fieldMap.setDestField(destField);
        MappingUtils.applyGlobalCopyByReference(configuration, fieldMap, classMap);
        classMap.addFieldMapping(fieldMap);
    }

    static {
        buildTimeGenerators.add(new AnnotationPropertiesGenerator());
        buildTimeGenerators.add(new AnnotationFieldsGenerator());
        buildTimeGenerators.add(new MapMappingGenerator());
        buildTimeGenerators.add(new BeanMappingGenerator());
        buildTimeGenerators.add(new CollectionMappingGenerator());
        runTimeGenerators.add(new AnnotationPropertiesGenerator());
        runTimeGenerators.add(new AnnotationFieldsGenerator());
        runTimeGenerators.add(new MapMappingGenerator());
        runTimeGenerators.add(new BeanMappingGenerator());
    }

    public static class AnnotationFieldsGenerator
    implements ClassMappingGenerator {
        @Override
        public boolean accepts(ClassMap classMap) {
            return true;
        }

        @Override
        public boolean apply(ClassMap classMap, Configuration configuration) {
            Class<?> srcType = classMap.getSrcClassToMap();
            do {
                for (Field field : srcType.getDeclaredFields()) {
                    Mapping mapping = field.getAnnotation(Mapping.class);
                    String fieldName = field.getName();
                    if (mapping == null) continue;
                    String pairName = mapping.value().trim();
                    ClassMapBuilder.addFieldMapping(classMap, configuration, fieldName, pairName.isEmpty() ? fieldName : pairName);
                }
            } while ((srcType = srcType.getSuperclass()) != null);
            Class<?> destType = classMap.getDestClassToMap();
            do {
                for (Field field : destType.getDeclaredFields()) {
                    Mapping mapping = field.getAnnotation(Mapping.class);
                    String fieldName = field.getName();
                    if (mapping == null) continue;
                    String pairName = mapping.value().trim();
                    ClassMapBuilder.addFieldMapping(classMap, configuration, pairName.isEmpty() ? fieldName : pairName, fieldName);
                }
            } while ((destType = destType.getSuperclass()) != null);
            return false;
        }
    }

    public static class AnnotationPropertiesGenerator
    implements ClassMappingGenerator {
        @Override
        public boolean accepts(ClassMap classMap) {
            return true;
        }

        @Override
        public boolean apply(ClassMap classMap, Configuration configuration) {
            PropertyDescriptor[] destProperties;
            PropertyDescriptor[] srcProperties;
            Class<?> srcType = classMap.getSrcClassToMap();
            for (PropertyDescriptor property : srcProperties = ReflectionUtils.getPropertyDescriptors(srcType)) {
                Method readMethod = property.getReadMethod();
                if (readMethod == null) continue;
                Mapping mapping = readMethod.getAnnotation(Mapping.class);
                String propertyName = property.getName();
                if (mapping == null) continue;
                String pairName = mapping.value().trim();
                GeneratorUtils.addGenericMapping(classMap, configuration, propertyName, pairName.isEmpty() ? propertyName : pairName);
            }
            Class<?> destType = classMap.getDestClassToMap();
            for (PropertyDescriptor property : destProperties = ReflectionUtils.getPropertyDescriptors(destType)) {
                Method readMethod = property.getReadMethod();
                if (readMethod == null) continue;
                Mapping mapping = readMethod.getAnnotation(Mapping.class);
                String propertyName = property.getName();
                if (mapping == null) continue;
                String pairName = mapping.value().trim();
                GeneratorUtils.addGenericMapping(classMap, configuration, pairName.isEmpty() ? propertyName : pairName, propertyName);
            }
            return false;
        }
    }

    public static class CollectionMappingGenerator
    implements ClassMappingGenerator {
        @Override
        public boolean accepts(ClassMap classMap) {
            Class<?> srcClass = classMap.getSrcClassToMap();
            Class<?> destClass = classMap.getDestClassToMap();
            return MappingUtils.isSupportedCollection(srcClass) && MappingUtils.isSupportedCollection(destClass);
        }

        @Override
        public boolean apply(ClassMap classMap, Configuration configuration) {
            GenericFieldMap fieldMap = new GenericFieldMap(classMap);
            DozerField selfReference = new DozerField("this", null);
            fieldMap.setSrcField(selfReference);
            fieldMap.setDestField(selfReference);
            classMap.addFieldMapping(fieldMap);
            return true;
        }
    }

    public static class MapMappingGenerator
    implements ClassMappingGenerator {
        @Override
        public boolean accepts(ClassMap classMap) {
            Class<?> srcClass = classMap.getSrcClassToMap();
            Class<?> destClass = classMap.getDestClassToMap();
            return MappingUtils.isSupportedMap(srcClass) || classMap.getSrcClassMapGetMethod() != null || MappingUtils.isSupportedMap(destClass) || classMap.getDestClassMapGetMethod() != null;
        }

        @Override
        public boolean apply(ClassMap classMap, Configuration configuration) {
            PropertyDescriptor[] properties;
            Class<?> srcClass = classMap.getSrcClassToMap();
            Class<?> destClass = classMap.getDestClassToMap();
            boolean destinationIsMap = false;
            if (MappingUtils.isSupportedMap(srcClass) || classMap.getSrcClassMapGetMethod() != null) {
                properties = ReflectionUtils.getPropertyDescriptors(destClass);
            } else {
                properties = ReflectionUtils.getPropertyDescriptors(srcClass);
                destinationIsMap = true;
            }
            for (PropertyDescriptor property : properties) {
                String fieldName = property.getName();
                if (GeneratorUtils.shouldIgnoreField(fieldName, srcClass, destClass) || destinationIsMap && classMap.getFieldMapUsingSrc(fieldName) != null || !destinationIsMap && classMap.getFieldMapUsingDest(fieldName, true) != null) continue;
                MapFieldMap fieldMap = new MapFieldMap(classMap);
                DozerField srcField = new DozerField(MappingUtils.isSupportedMap(srcClass) ? "this" : fieldName, null);
                srcField.setKey(fieldName);
                if (StringUtils.isNotEmpty((CharSequence)classMap.getSrcClassMapGetMethod()) || StringUtils.isNotEmpty((CharSequence)classMap.getSrcClassMapSetMethod())) {
                    srcField.setMapGetMethod(classMap.getSrcClassMapGetMethod());
                    srcField.setMapSetMethod(classMap.getSrcClassMapSetMethod());
                    srcField.setName("this");
                }
                DozerField destField = new DozerField(MappingUtils.isSupportedMap(destClass) ? "this" : fieldName, null);
                srcField.setKey(fieldName);
                if (StringUtils.isNotEmpty((CharSequence)classMap.getDestClassMapGetMethod()) || StringUtils.isNotEmpty((CharSequence)classMap.getDestClassMapSetMethod())) {
                    destField.setMapGetMethod(classMap.getDestClassMapGetMethod());
                    destField.setMapSetMethod(classMap.getDestClassMapSetMethod());
                    destField.setName("this");
                }
                fieldMap.setSrcField(srcField);
                fieldMap.setDestField(destField);
                classMap.addFieldMapping(fieldMap);
            }
            return true;
        }
    }

    public static interface ClassMappingGenerator {
        public boolean accepts(ClassMap var1);

        public boolean apply(ClassMap var1, Configuration var2);
    }
}

