/*
 * Decompiled with CFR 0.152.
 */
package su.artix.discountmanager.trees;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.ArrayUtils;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.python.core.PyObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import su.artix.artixadmin.connection.ArtixAdminContextHolder;
import su.artix.discountmanager.discountsystem.compare.CompareItem;
import su.artix.discountmanager.discountsystem.compare.DiscountDifferencer;
import su.artix.discountmanager.holders.ViewHolder;
import su.artix.discountmanager.providers.discountsystem.DiscountSystemContentProvider;
import su.artix.discountmanager.trees.HistoryItemPlace;
import su.artix.discountmanager.trees.ListForItemChange;
import su.artix.discountmanager.trees.MutexRule;
import su.artix.discountmanager.views.DiscountGanttChartView;
import su.artix.discountmanager.views.DiscountSystemUndoRedoToolbar;
import su.artix.discountmanager.views.DiscountSystemView;
import su.artix.discountmanager.views.EarnBonusSystemView;
import su.artix.discountmanager.views.LimitBonusSystemView;
import su.artix.discountmanager.views.PeriodicImpactsBonusSystemView;
import su.artix.discountmanager.views.SecondSystemView;
import su.artix.loyaltylib.convertor.discountsystem.DiscountSystem2Yaml;
import su.artix.loyaltylib.convertor.discountsystem.DiscountSystemFromYaml;
import su.artix.loyaltylib.domain.java.discountsystem.Discount;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountCampaign;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountCampaignGroup;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountSystem;
import su.artix.loyaltylib.domain.java.observable.AbstractDiscountModel;
import su.artix.loyaltylib.domain.java.observable.DiscountTreeTypeAction;

public class CustomSystemTreeViewer
extends TreeViewer
implements PropertyChangeListener {
    private static final Logger log = LoggerFactory.getLogger(CustomSystemTreeViewer.class);
    private Map<String, ListForItemChange> changeHistoryListMap = new ConcurrentHashMap<String, ListForItemChange>();
    private Boolean isChanged = false;
    private List<PropertyChangeListener> listeners;
    private final transient PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    private IWorkbenchPart joinedView;
    private String joinedViewID;
    private static final String STATE_KEY = "state";
    private static final int COLLAPSED_ITEM = 0;
    private static final int EXPANDED_ITEM = 1;
    private static final int SELECTED_ITEM = 2;
    private MutexRule mutexRule = new MutexRule();

    protected void handleDispose(DisposeEvent event) {
        ViewHolder.INSTANCE.removeLoadedDiscountSystemView(this.joinedViewID);
        super.handleDispose(event);
    }

    private ListForItemChange getChangeHistoryList(String connectionId) {
        ListForItemChange listForItemChange = this.changeHistoryListMap.get(connectionId);
        if (listForItemChange == null) {
            listForItemChange = new ListForItemChange();
            this.changeHistoryListMap.put(connectionId, listForItemChange);
        }
        return listForItemChange;
    }

    public CustomSystemTreeViewer(Composite parent, IWorkbenchPart joinedView, String joinedViewId) {
        super(parent, 67586);
        this.joinedView = joinedView;
        this.joinedViewID = joinedViewId;
        this.listeners = new ArrayList<PropertyChangeListener>();
        this.listeners.add(this);
        this.getTree().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                String connectionId = ArtixAdminContextHolder.getConnectionId();
                CustomSystemTreeViewer.this.updateUndoRedo(connectionId);
                CustomSystemTreeViewer.this.updateGant();
            }
        });
        ViewHolder.INSTANCE.addLoadedDiscountSystemView(joinedViewId, (IViewPart)joinedView);
    }

    public void saveTreeState() {
        this.isChanged = false;
    }

    public Boolean isChanged() {
        return this.isChanged;
    }

    private int restoreTreeState(TreeItem item, List<Integer> treeState, int indexOfTreeState) {
        Assert.notNull(treeState);
        Assert.notNull((Object)item);
        if (item.getData() == null) {
            return indexOfTreeState;
        }
        int nextIndex = indexOfTreeState + 1;
        int itemState = treeState.get(indexOfTreeState);
        if ((itemState & 1) != 0) {
            this.createChildren((Widget)item);
            item.setExpanded(true);
        }
        if ((itemState & 2) != 0) {
            this.getTree().select(item);
        }
        if (item.getItemCount() > 0) {
            TreeItem[] treeItemArray = item.getItems();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem childItem = treeItemArray[n2];
                nextIndex = this.restoreTreeState(childItem, treeState, nextIndex);
                ++n2;
            }
        }
        return nextIndex;
    }

    private List<Integer> getTreeState(TreeItem item, List<Integer> treeState) {
        Assert.notNull(treeState);
        Assert.notNull((Object)item);
        int itemState = 0;
        if (item.getExpanded()) {
            itemState |= 1;
        }
        if (ArrayUtils.contains((Object[])this.getTree().getSelection(), (Object)item)) {
            itemState |= 2;
        }
        treeState.add(itemState);
        if (item.getItemCount() > 0 && itemState != 0) {
            TreeItem[] treeItemArray = item.getItems();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem childItem = treeItemArray[n2];
                this.getTreeState(childItem, treeState);
                ++n2;
            }
        }
        return treeState;
    }

    private void addHistoryItem(List<Integer> treeState, String connectionId, PyObject discountTree) {
        long point = System.currentTimeMillis();
        try {
            ListForItemChange list = this.getChangeHistoryList(connectionId);
            boolean result = list.add(DiscountSystem2Yaml.getDiscountSystemYaml((PyObject)discountTree), MapUtils.putAll(new HashMap(), (Object[])new Object[]{STATE_KEY, treeState}));
            log.debug("add to history result={}", (Object)result);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            log.warn("Can't save discount change history because: {}", (Object)e.getMessage());
        }
        log.info("history save delta={}", (Object)(System.currentTimeMillis() - point));
    }

    public void refresh() {
        super.refresh();
        String connectionId = ArtixAdminContextHolder.getConnectionId();
        this.updateUndoRedo(connectionId);
    }

    private void updateUndoRedo(String connectionId) {
        DiscountSystemUndoRedoToolbar.setItemPlace(this.getChangeHistoryList(connectionId).getPlaceOfPointer());
    }

    public void add(Object parentElementOrTreePath, Object childElement) {
        if (childElement instanceof AbstractDiscountModel) {
            AbstractDiscountModel model = (AbstractDiscountModel)childElement;
            model.addPropertyChangeListener(this.listeners);
            super.add(parentElementOrTreePath, (Object)model);
        } else {
            super.add(parentElementOrTreePath, childElement);
        }
        this.expandToLevel(parentElementOrTreePath, 1);
    }

    public void remove(Object elementsOrTreePaths) {
        if (elementsOrTreePaths instanceof AbstractDiscountModel) {
            AbstractDiscountModel model = (AbstractDiscountModel)elementsOrTreePaths;
            model.removePropertyChangeListeners();
        } else {
            super.remove(elementsOrTreePaths);
        }
    }

    void setParentsChanged(AbstractDiscountModel adm) {
        adm.setChanged(Boolean.valueOf(true));
        if (adm.getParent() instanceof AbstractDiscountModel) {
            AbstractDiscountModel a = (AbstractDiscountModel)adm.getParent();
            this.setParentsChanged(a);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        AbstractDiscountModel adm;
        log.trace("Discount change event: {}", evt.getNewValue());
        this.isChanged = true;
        if (DiscountTreeTypeAction.SAVE.toString().equals(evt.getPropertyName())) {
            adm = (AbstractDiscountModel)evt.getNewValue();
            this.setParentsChanged(adm);
            this.update(evt.getNewValue(), null);
        } else if (DiscountTreeTypeAction.ADD.toString().equals(evt.getPropertyName())) {
            if (evt.getOldValue() != null) {
                if (evt.getOldValue() instanceof Discount) {
                    Discount discountOld = (Discount)evt.getOldValue();
                    discountOld.getDiscountRate().removePropertyChangeListeners();
                    discountOld.getDiscountObject().removePropertyChangeListeners();
                }
                this.remove(((AbstractDiscountModel)evt.getOldValue()).getParent(), new Object[]{evt.getOldValue()});
            }
            if (evt.getNewValue() != null) {
                adm = (AbstractDiscountModel)evt.getNewValue();
                this.setParentsChanged(adm);
                this.add(((AbstractDiscountModel)evt.getNewValue()).getParent(), evt.getNewValue());
                if (evt.getNewValue() instanceof Discount) {
                    Discount discountNew = (Discount)evt.getNewValue();
                    discountNew.getDiscountRate().addPropertyChangeListener(this.listeners);
                    discountNew.getDiscountObject().addPropertyChangeListener(this.listeners);
                }
                if (adm instanceof DiscountCampaign) {
                    this.updateGant();
                }
            }
        } else if (DiscountTreeTypeAction.REMOVE.toString().equals(evt.getPropertyName())) {
            adm = (AbstractDiscountModel)evt.getNewValue();
            this.setParentsChanged(adm);
            if (evt.getNewValue() != null) {
                if (evt.getNewValue() instanceof Discount) {
                    Discount discount = (Discount)evt.getNewValue();
                    discount.getDiscountRate().removePropertyChangeListeners();
                }
                this.remove(((AbstractDiscountModel)evt.getNewValue()).getParent(), new Object[]{evt.getNewValue()});
            }
            if (adm instanceof DiscountCampaign) {
                this.updateGant();
            }
        } else if (DiscountTreeTypeAction.REFRESH.toString().equals(evt.getPropertyName())) {
            adm = (AbstractDiscountModel)evt.getNewValue();
            this.setParentsChanged(adm);
            if (adm instanceof DiscountCampaign || adm instanceof DiscountCampaignGroup) {
                this.updateGant();
            }
        }
        Object currentObject = ViewHolder.INSTANCE.getSelectionElementFromActiveView();
        if (ViewHolder.INSTANCE.getActiveViewPart() instanceof DiscountSystemView) {
            ((DiscountSystemView)ViewHolder.INSTANCE.getActiveViewPart()).initializePopupMenu(currentObject);
        } else if (ViewHolder.INSTANCE.getActiveViewPart() instanceof EarnBonusSystemView) {
            ((EarnBonusSystemView)ViewHolder.INSTANCE.getActiveViewPart()).initializePopupMenu(currentObject);
        } else if (ViewHolder.INSTANCE.getActiveViewPart() instanceof PeriodicImpactsBonusSystemView) {
            ((PeriodicImpactsBonusSystemView)ViewHolder.INSTANCE.getActiveViewPart()).initializePopupMenu(currentObject);
        } else if (ViewHolder.INSTANCE.getActiveViewPart() instanceof LimitBonusSystemView) {
            ((LimitBonusSystemView)ViewHolder.INSTANCE.getActiveViewPart()).initializePopupMenu(currentObject);
        } else if (ViewHolder.INSTANCE.getActiveViewPart() instanceof SecondSystemView) {
            ((SecondSystemView)ViewHolder.INSTANCE.getActiveViewPart()).initializePopupMenu(currentObject);
        }
        this.addHistoryJob();
        this.refresh();
        this.changeSupport.firePropertyChange(evt);
    }

    private void addHistoryJob() {
        final List<Integer> treeState = this.getTreeState(this.getTree().getItems()[0], new ArrayList<Integer>());
        final String connectionId = ArtixAdminContextHolder.getConnectionId();
        DiscountSystem discountSystem = ((DiscountSystemContentProvider)this.getContentProvider()).getCurrentSystem();
        final PyObject pyTree = DiscountSystem2Yaml.getPyDiscountSystemTree((DiscountSystem)discountSystem);
        Job job = new Job("AddHistoryItem"){

            protected IStatus run(IProgressMonitor monitor) {
                CustomSystemTreeViewer.this.addHistoryItem(treeState, connectionId, pyTree);
                CustomSystemTreeViewer.this.updateUndoRedo(connectionId);
                return Status.OK_STATUS;
            }
        };
        job.setRule((ISchedulingRule)this.mutexRule);
        job.schedule();
    }

    public void setIsChanged(boolean b) {
        this.isChanged = b;
    }

    private void setChangeByCompare(Object parent) {
        if (parent instanceof DiffNode) {
            CompareItem compareItem;
            ITypedElement item = ((DiffNode)parent).getLeft();
            if (item instanceof CompareItem && (compareItem = (CompareItem)item).getDiscountObject() instanceof AbstractDiscountModel) {
                ((AbstractDiscountModel)((CompareItem)((DiffNode)parent).getLeft()).getDiscountObject()).setChanged(Boolean.valueOf(true));
            }
            IDiffElement[] iDiffElementArray = ((DiffNode)parent).getChildren();
            int n = iDiffElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IDiffElement child = iDiffElementArray[n2];
                this.setChangeByCompare(child);
                ++n2;
            }
        }
    }

    private HistoryItemPlace updateTree(String stringDiscount, ListForItemChange currentList) {
        if (stringDiscount == null) {
            return currentList.getPlaceOfPointer();
        }
        List treeState = null;
        Map<String, Object> historyMeta = currentList.getCurrentHistoryMeta();
        if (historyMeta != null) {
            treeState = (List)historyMeta.get(STATE_KEY);
        }
        DiscountSystem system = DiscountSystemFromYaml.getDiscountSystem((String)stringDiscount);
        String idShop = ArtixAdminContextHolder.getConnectionId();
        DiscountSystemContentProvider provider = (DiscountSystemContentProvider)this.getContentProvider();
        provider.getMap().remove(idShop);
        provider.getMap().put(idShop, system);
        provider.addListenerTo((AbstractDiscountModel)system);
        provider.getSystemTreeViewer().refresh();
        IDiffContainer diff = (IDiffContainer)new DiscountDifferencer(provider, (ILabelProvider)this.getLabelProvider()).findDifferences(system, DiscountSystemFromYaml.getDiscountSystem((String)currentList.getFirstValue()));
        provider.getSystemTreeViewer().setIsChanged(diff != null);
        this.setChangeByCompare(diff);
        if (treeState == null) {
            this.expandToLevel(3);
        } else {
            this.createChildren((Widget)this.getTree());
            this.restoreTreeState(this.getTree().getItem(0), treeState, 0);
        }
        this.getTree().showSelection();
        return currentList.getPlaceOfPointer();
    }

    public boolean isHistoryAlreadyInitialized() {
        String connectionId = ArtixAdminContextHolder.getConnectionId();
        return this.getChangeHistoryList(connectionId).isHistoryInitialized();
    }

    public HistoryItemPlace showCurrentChange() {
        String connectionId = ArtixAdminContextHolder.getConnectionId();
        String current = this.getChangeHistoryList(connectionId).getCurrentItem();
        HistoryItemPlace place = this.updateTree(current, this.getChangeHistoryList(connectionId));
        this.updateGant();
        return place;
    }

    public HistoryItemPlace showNextChange() {
        String connectionId = ArtixAdminContextHolder.getConnectionId();
        String next = this.getChangeHistoryList(connectionId).getNextItem();
        HistoryItemPlace place = this.updateTree(next, this.getChangeHistoryList(connectionId));
        this.updateGant();
        return place;
    }

    public HistoryItemPlace showPreviousChange() {
        String connectionId = ArtixAdminContextHolder.getConnectionId();
        String previous = this.getChangeHistoryList(connectionId).getPreviousItem();
        HistoryItemPlace place = this.updateTree(previous, this.getChangeHistoryList(connectionId));
        this.updateGant();
        return place;
    }

    public void addHistoryItemValue(String item) {
        String connectionId = ArtixAdminContextHolder.getConnectionId();
        try {
            this.getChangeHistoryList(connectionId).add(item, null);
        }
        catch (Exception e) {
            log.warn("Can't save discount change history because: {}", (Object)e.getMessage());
        }
    }

    public boolean setInitHistoryItem(String initItem) {
        String connectionId = ArtixAdminContextHolder.getConnectionId();
        return this.getChangeHistoryList(connectionId).setInitialValue(initItem);
    }

    public boolean checkAndSaveDiscountTree(IWorkbenchPart activeViewPart) {
        if (!this.joinedView.equals(activeViewPart) && !this.saveSystemTreeWithRequest()) {
            try {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(this.joinedViewID);
            }
            catch (PartInitException partInitException) {
                throw new RuntimeException(partInitException);
            }
            return false;
        }
        return true;
    }

    public boolean saveSystemTreeWithRequest() {
        boolean success = false;
        if (this.isChanged.booleanValue()) {
            String connectionId = ArtixAdminContextHolder.getConnectionId();
            ListForItemChange historyList = this.getChangeHistoryList(connectionId);
            MessageDialog dialog = new MessageDialog(Display.getCurrent().getActiveShell(), "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0435 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u0432 \u0434\u0438\u0441\u043a\u043e\u043d\u0442\u0435?", null, String.format("\u0412\u044b \u043f\u043e\u043a\u0438\u0434\u0430\u0435\u0442\u0435 \u043e\u043a\u043d\u043e \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0442\u0435\u043a\u0443\u0449\u0435\u0433\u043e \u0434\u0435\u0440\u0435\u0432\u0430 \u0434\u0438\u0441\u043a\u043e\u043d\u0442\u0430 (%s).\n\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f?", this.joinedView.getTitle()), 3, new String[]{"\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c", "\u041d\u0435 \u0441\u043e\u0445\u0440\u0430\u043d\u044f\u0442\u044c", "\u041e\u0442\u043c\u0435\u043d\u0430"}, 0);
            int resultCode = dialog.open();
            switch (resultCode) {
                case 0: {
                    ((DiscountSystemContentProvider)this.getContentProvider()).saveDiscountSystemWithoutDialog();
                    this.saveTreeState();
                    this.refresh();
                    this.isChanged = false;
                    success = true;
                    break;
                }
                case 1: {
                    this.addHistoryItemValue(historyList.getFirstValue());
                    this.updateTree(historyList.getFirstValue(), historyList);
                    success = true;
                    this.isChanged = false;
                    break;
                }
                case 2: {
                    this.isChanged = true;
                    success = false;
                    break;
                }
            }
            log.trace("dialog result code: {}", (Object)resultCode);
        } else {
            success = true;
        }
        return success;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public String getJoinedViewID() {
        return this.joinedViewID;
    }

    private void updateGant() {
        IViewPart partViewPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("su.artix.discountmanager.views.DiscountGanttChartView");
        if (partViewPart != null) {
            ((DiscountGanttChartView)partViewPart).setActiveParentId(this.joinedViewID);
            PropertyChangeEvent changeEvent = new PropertyChangeEvent(this, null, null, null);
            ((PropertyChangeListener)partViewPart).propertyChange(changeEvent);
            log.debug("set active view id={}", (Object)this.joinedViewID);
        }
    }
}

