/*
 * Decompiled with CFR 0.152.
 */
package su.artix.discountmanager.handlers;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import su.artix.artixadmin.connection.ArtixAdminContextHolder;
import su.artix.discountmanager.Activator;
import su.artix.discountmanager.holders.ViewHolder;
import su.artix.discountmanager.providers.discountsystem.DiscountSystemContentProvider;
import su.artix.discountmanager.utils.ErrorMessageFactory;
import su.artix.discountmanagercore.holders.PropertiesHolder;
import su.artix.loyaltylib.convertor.discountsystem.DiscountSystemFromYaml;
import su.artix.loyaltylib.domain.java.discountsystem.Counter;
import su.artix.loyaltylib.domain.java.discountsystem.Coupon;
import su.artix.loyaltylib.domain.java.discountsystem.Discount;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountCampaign;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountCondition;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountSystem;
import su.artix.loyaltylib.domain.java.discountsystem.Gift;
import su.artix.loyaltylib.domain.java.discountsystem.Report;
import su.artix.loyaltylib.domain.java.observable.AbstractDiscountModel;

public class ImportSystemHandler
extends AbstractHandler {
    private static final Logger log = LoggerFactory.getLogger(ImportSystemHandler.class);

    protected DiscountSystemContentProvider getProvider() {
        TreeViewer systemTree = (TreeViewer)ViewHolder.INSTANCE.getActiveViewPart().getSite().getSelectionProvider();
        return (DiscountSystemContentProvider)systemTree.getContentProvider();
    }

    protected String getDiscountModelFromFile() throws Exception {
        String dsSystemString = null;
        FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell(), 4096);
        String[] filterExtensions = new String[]{"*.yaml", "*"};
        String filterPath = PropertiesHolder.INSTANCE.getCommonsProperty("DISCOUNT.PATHTOEXPORTEDFILELIN", "/");
        String platform = SWT.getPlatform();
        if (platform.equals("win32") || platform.equals("wpf")) {
            filterPath = PropertiesHolder.INSTANCE.getCommonsProperty("DISCOUNT.PATHTOEXPORTEDFILEWIN", "C:\\");
            filterExtensions = new String[]{"*.yaml", "*.*"};
        }
        dialog.setFilterExtensions(filterExtensions);
        dialog.setFilterPath(filterPath);
        String file = dialog.open();
        if (file != null) {
            Activator.getDefault().setLoadCursor(true);
            dsSystemString = FileUtils.readFileToString((File)new File(file));
            Activator.getDefault().setLoadCursor(false);
        }
        return dsSystemString;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            String discountFromFile = this.getDiscountModelFromFile();
            if (discountFromFile != null) {
                String idShop = ArtixAdminContextHolder.getConnectionId();
                DiscountSystem discounSystem = DiscountSystemFromYaml.getDiscountSystem((String)discountFromFile);
                this.setChange(discounSystem, true);
                this.getProvider().getMap().remove(idShop);
                this.getProvider().getMap().put(idShop, discounSystem);
                this.getProvider().addListenerTo((AbstractDiscountModel)discounSystem);
                this.getProvider().getSystemTreeViewer().refresh();
                this.getProvider().getSystemTreeViewer().setIsChanged(true);
                this.getProvider().getSystemTreeViewer().addHistoryItemValue(discountFromFile);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            ErrorMessageFactory.exceptionMessage(e);
        }
        return null;
    }

    private void setChange(DiscountSystem ds, boolean value) {
        if (ds != null) {
            ds.setChanged(Boolean.valueOf(value));
            if (ds.getCampaignGroup() != null) {
                ds.getCampaignGroup().setChanged(Boolean.valueOf(value));
                for (DiscountCampaign discountCampaign : ds.getCampaignGroup().getDiscountCampaigns()) {
                    discountCampaign.setChanged(Boolean.valueOf(value));
                    for (Discount discount : discountCampaign.getDiscounts()) {
                        discount.setChanged(Boolean.valueOf(value));
                        discount.getDiscountObject().setChanged(Boolean.valueOf(value));
                        discount.getDiscountRate().setChanged(Boolean.valueOf(value));
                        for (DiscountCondition discountCondition : discount.getDiscountConditions()) {
                            discountCondition.setChanged(Boolean.valueOf(value));
                        }
                        for (Counter counter : discount.getCounters()) {
                            counter.setChanged(Boolean.valueOf(value));
                        }
                        for (Coupon coupon : discount.getCoupons()) {
                            coupon.setChanged(Boolean.valueOf(value));
                        }
                        for (Gift gift : discount.getGifts()) {
                            gift.setChanged(Boolean.valueOf(value));
                        }
                        for (Report report : discount.getReports()) {
                            report.setChanged(Boolean.valueOf(value));
                        }
                    }
                }
            }
        }
    }
}

