/*
 * Decompiled with CFR 0.152.
 */
package su.artix.cashregistry.mock;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;
import su.artix.cashregistry.mock.StubRepository;
import su.artix.cashserver.core.cashregistry.domain.SecurityObject;
import su.artix.cashserver.core.cashregistry.repository.SecurityObjectRepository;

public class SecurityObjectRepositoryMock
extends StubRepository<SecurityObject, String>
implements SecurityObjectRepository {
    private DataSource dataSource;
    private JdbcTemplate jdbcTemplate;

    public SecurityObject findById(String id) {
        this.jdbcTemplate = new JdbcTemplate(this.dataSource);
        return (SecurityObject)this.jdbcTemplate.query("SELECT id, title, parentId FROM securityObject WHERE id=?;", new Object[]{id}, (ResultSetExtractor)new ResultSetExtractor<SecurityObject>(){

            public SecurityObject extractData(ResultSet rs) throws SQLException {
                SecurityObject securityObject = new SecurityObject(rs.getString(1));
                securityObject.setTitle(rs.getString(2));
                if (rs.getString(3) != null) {
                    securityObject.setParent(SecurityObjectRepositoryMock.this.findById(rs.getString(3)));
                }
                return securityObject;
            }
        });
    }

    public List<SecurityObject> findByParentId(String id) {
        this.jdbcTemplate = new JdbcTemplate(this.dataSource);
        return this.jdbcTemplate.query("SELECT id, title, parentId FROM securityObject WHERE parentId=?;", new Object[]{id}, (RowMapper)new RowMapper<SecurityObject>(){

            public SecurityObject mapRow(ResultSet rs, int arg1) throws SQLException {
                SecurityObject securityObject = new SecurityObject(rs.getString(1));
                securityObject.setTitle(rs.getString(2));
                if (rs.getString(3) != null) {
                    securityObject.setParent(SecurityObjectRepositoryMock.this.findById(rs.getString(3)));
                }
                return securityObject;
            }
        });
    }

    public List<SecurityObject> findByClass(String clazz) {
        return Collections.emptyList();
    }

    @Override
    public List<SecurityObject> findAll() {
        this.jdbcTemplate = new JdbcTemplate(this.dataSource);
        return this.jdbcTemplate.query("SELECT id, title, parentId FROM securityObject;", (RowMapper)new RowMapper<SecurityObject>(){

            public SecurityObject mapRow(ResultSet rs, int arg1) throws SQLException {
                SecurityObject securityObject = new SecurityObject(rs.getString(1));
                securityObject.setTitle(rs.getString(2));
                if (rs.getString(3) != null) {
                    securityObject.setParent(SecurityObjectRepositoryMock.this.findById(rs.getString(3)));
                }
                return securityObject;
            }
        });
    }

    @Override
    public void deleteAll() {
        this.jdbcTemplate = new JdbcTemplate(this.dataSource);
        this.jdbcTemplate.update("DELETE FROM securityObject;");
    }

    @Override
    public long count() {
        this.jdbcTemplate = new JdbcTemplate(this.dataSource);
        return this.jdbcTemplate.queryForInt("SELECT COUNT(*) FROM securityObject;");
    }

    @Override
    public boolean exists(String paramID) {
        this.jdbcTemplate = new JdbcTemplate(this.dataSource);
        List rows = this.jdbcTemplate.queryForList("SELECT id FROM securityObject WHERE id=?;", String.class, new Object[]{paramID});
        return !rows.isEmpty();
    }

    @Override
    public <S extends SecurityObject> S save(S arg0) {
        this.jdbcTemplate = new JdbcTemplate(this.dataSource);
        String query = "REPLACE INTO securityObject (id, title, parentId) values (?, ?, ?);";
        this.jdbcTemplate.update(query, new Object[]{arg0.getId(), arg0.getTitle(), arg0.getParent() == null ? null : arg0.getParent().getId()});
        return arg0;
    }

    @Override
    public void delete(String arg0) {
        String query = "DELETE FROM securityObject where id=?;";
        this.jdbcTemplate = new JdbcTemplate(this.dataSource);
        this.jdbcTemplate.update(query, new Object[]{arg0});
    }

    @Override
    public void delete(SecurityObject arg0) {
        if (arg0 != null) {
            this.delete(arg0.getId());
        }
    }

    @Override
    public SecurityObject findOne(String arg0) {
        return this.findById(arg0);
    }

    @Override
    public <S extends SecurityObject> Iterable<S> save(final Iterable<S> arg0) {
        TransactionTemplate transactionTemplate = new TransactionTemplate((PlatformTransactionManager)new DataSourceTransactionManager(this.dataSource));
        transactionTemplate.execute((TransactionCallback)new TransactionCallback<Object>(){

            public Object doInTransaction(TransactionStatus arg) {
                for (SecurityObject object : arg0) {
                    SecurityObjectRepositoryMock.this.save(object);
                }
                return null;
            }
        });
        return arg0;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }
}

