/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security.ruleset;

import com.sun.deploy.ref.AppRef;
import com.sun.deploy.ref.CodeInstance;
import com.sun.deploy.ref.CodeRef;
import com.sun.deploy.security.ruleset.DRSResult;
import com.sun.deploy.security.ruleset.Rule;
import com.sun.deploy.security.ruleset.RuleSetParser;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class DRSHelper {
    private final Rule[] rules;

    public DRSHelper(String string) {
        this(new ByteArrayInputStream(string.getBytes()));
    }

    public DRSHelper(InputStream inputStream) {
        this.rules = new RuleSetParser().parse(inputStream);
    }

    public Rule[] getRules() {
        if (this.rules != null) {
            return (Rule[])this.rules.clone();
        }
        return new Rule[0];
    }

    public Rule findRule(CodeInstance codeInstance) {
        return this.findRule(codeInstance.getAppRef(), codeInstance.getCodeRef());
    }

    public int findIndex(CodeInstance codeInstance) {
        return this.findIndex(codeInstance.getAppRef(), codeInstance.getCodeRef());
    }

    public Rule findRule(AppRef appRef, CodeRef codeRef) {
        for (int i = 0; i < this.rules.length; ++i) {
            if (!this.rules[i].getId().contains(appRef, codeRef)) continue;
            return this.rules[i];
        }
        return null;
    }

    public int findIndex(AppRef appRef, CodeRef codeRef) {
        for (int i = 0; i < this.rules.length; ++i) {
            if (!this.rules[i].getId().contains(appRef, codeRef)) continue;
            return i;
        }
        return -1;
    }

    public static DRSResult[] check(String string, AppRef appRef, CodeRef[] codeRefArray) {
        DRSResult[] dRSResultArray = new DRSResult[codeRefArray.length];
        for (int i = 0; i < codeRefArray.length; ++i) {
            dRSResultArray[i] = DRSHelper.check(string, appRef, codeRefArray[i]);
        }
        return dRSResultArray;
    }

    public static DRSResult check(String string, AppRef appRef, CodeRef codeRef) {
        try {
            DRSHelper dRSHelper = new DRSHelper(string);
            return dRSHelper.check(appRef, codeRef);
        }
        catch (Exception exception) {
            return new DRSResult(exception);
        }
    }

    public DRSResult check(AppRef appRef, CodeRef codeRef) {
        for (int i = 0; i < this.rules.length; ++i) {
            if (!this.rules[i].getId().contains(appRef, codeRef)) continue;
            return new DRSResult(this.rules[i].getAction(), i);
        }
        return new DRSResult();
    }
}

