/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.artixadmin.action.connect;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import ru.ssa.artixadmin.editors.connect.EditConnectXmlFile;
import ru.ssa.artixadmin.view.connect.ConnectTableViewer;
import ru.ssa.cashadmin.domain.Connect;
import ru.ssa.cashadmin.domain.DomainCollections;
import ru.ssa.cashadmin.domain.utils.JaxbUtil;
import su.artix.yuki.images.ArtixAdminImages;

public class ImportConnectAction
extends Action {
    private ConnectTableViewer connectTableViewer;

    public ImportConnectAction(ConnectTableViewer connectTableViewer) {
        super("\u0418&\u043c\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f", ArtixAdminImages.getDefault().getImageDescriptor("plane/16x16/import"));
        this.connectTableViewer = connectTableViewer;
    }

    public void run() {
        FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell());
        String[] extensions = new String[]{"*.xml", "*.*"};
        dialog.setFilterExtensions(extensions);
        String importFilePath = dialog.open();
        List importedConnections = null;
        try {
            if (importFilePath != null) {
                File file = new File(importFilePath);
                DomainCollections importFromXml = JaxbUtil.INSTANCE.importFromXml(file.getCanonicalPath());
                if (importFromXml == null) {
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"\u041e\u0448\u0438\u0431\u043a\u0430", (String)("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0438\u043c\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0444\u0430\u0439\u043b: " + importFilePath + "\n\u041f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435, \u0447\u0442\u043e \u0444\u0430\u0439\u043b \u0438\u043c\u0435\u0435\u0442 \u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442"));
                    return;
                }
                importedConnections = importFromXml.getDomainCollection();
            }
        }
        catch (IOException ex) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"\u041e\u0448\u0438\u0431\u043a\u0430", (String)("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0438\u043c\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0444\u0430\u0439\u043b: " + importFilePath + "\n" + ex.getMessage()));
        }
        if (importedConnections != null && !importedConnections.isEmpty()) {
            Object conns = this.connectTableViewer.getInput();
            if (conns != null && conns instanceof List) {
                List connections = (List)conns;
                for (Connect importedConnect : importedConnections) {
                    int i = 1;
                    for (Connect connect : connections) {
                        if (!connect.getName().equals(importedConnect.getName())) continue;
                        String newName = String.valueOf(importedConnect.getName()) + " \u043a\u043e\u043f\u0438\u044f(" + i++ + ")";
                        while (this.isContains(connections, newName)) {
                            newName = String.valueOf(importedConnect.getName()) + " \u043a\u043e\u043f\u0438\u044f(" + i++ + ")";
                        }
                        importedConnect.setName(newName);
                    }
                }
                connections.addAll(importedConnections);
                this.connectTableViewer.setInput(connections);
                this.connectTableViewer.refresh();
                EditConnectXmlFile.saveConnections(connections);
            } else {
                this.connectTableViewer.setInput(importedConnections);
                this.connectTableViewer.refresh();
                EditConnectXmlFile.saveConnections(importedConnections);
            }
        }
    }

    private boolean isContains(List<Connect> list, String name) {
        for (Connect connect : list) {
            if (!connect.getName().equals(name)) continue;
            return true;
        }
        return false;
    }
}

