/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.artixadmin.view;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.IActivityManager;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ssa.artixadmin.view.DisplayElementDBVersion;
import ru.ssa.cashadmin.LibActivator;

public enum DBVersionViewActivity {
    INSTANCE;

    private static final Logger log;
    private static final String activitySuffix = ".activityDBVersion";
    public static final List<DisplayElementDBVersion> specificViews;

    static {
        log = LoggerFactory.getLogger(DBVersionViewActivity.class);
        specificViews = new ArrayList<DisplayElementDBVersion>();
        specificViews.add(new DisplayElementDBVersion("ru.ssa.artixadmin.view.document.CouponitemTableView", DisplayElementDBVersion.ViewMode.CASH, DisplayElementDBVersion.DBType.DOCUMENT, 48));
        specificViews.add(new DisplayElementDBVersion("ru.ssa.artixadmin.view.document.KkmTableView", DisplayElementDBVersion.ViewMode.CASH, DisplayElementDBVersion.DBType.DOCUMENT, 53));
        specificViews.add(new DisplayElementDBVersion("ru.ssa.artixadmin.view.document.KkmTableView", DisplayElementDBVersion.ViewMode.SERVER, DisplayElementDBVersion.DBType.DOCUMENT, 16));
        specificViews.add(new DisplayElementDBVersion("ru.ssa.artixadmin.view.document.UsersTableView", DisplayElementDBVersion.ViewMode.CASH, DisplayElementDBVersion.DBType.DOCUMENT, 45));
        specificViews.add(new DisplayElementDBVersion("ru.ssa.artixadmin.view.document.UsersTableView", DisplayElementDBVersion.ViewMode.SERVER, DisplayElementDBVersion.DBType.DOCUMENT, 16));
        specificViews.add(new DisplayElementDBVersion("su.artix.discountmanager.views.secondsystemview", DisplayElementDBVersion.ViewMode.CASH, DisplayElementDBVersion.DBType.DICTIONARY, 108));
        specificViews.add(new DisplayElementDBVersion("su.artix.discountmanager.views.secondsystemview", DisplayElementDBVersion.ViewMode.SERVER, DisplayElementDBVersion.DBType.DICTIONARY, 65));
        specificViews.add(new DisplayElementDBVersion("ru.ssa.artixadmin.view.document.GiftTableView", DisplayElementDBVersion.ViewMode.CASH, DisplayElementDBVersion.DBType.DOCUMENT, 135));
        specificViews.add(new DisplayElementDBVersion("ru.ssa.artixadmin.view.document.GiftTableView", DisplayElementDBVersion.ViewMode.SERVER, DisplayElementDBVersion.DBType.DOCUMENT, 131));
        specificViews.add(new DisplayElementDBVersion("ru.ssa.artixadmin.view.document.MedicineTableView", DisplayElementDBVersion.ViewMode.CASH, DisplayElementDBVersion.DBType.DOCUMENT, 136));
        specificViews.add(new DisplayElementDBVersion("ru.ssa.artixadmin.view.document.MedicineTableView", DisplayElementDBVersion.ViewMode.SERVER, DisplayElementDBVersion.DBType.DOCUMENT, 132));
        specificViews.add(new DisplayElementDBVersion("ru.ssa.artixadmin.view.document.FiscaldocumentTableView", DisplayElementDBVersion.ViewMode.CASH, DisplayElementDBVersion.DBType.DOCUMENT, 133));
        specificViews.add(new DisplayElementDBVersion("ru.ssa.artixadmin.view.document.FiscaldocumentTableView", DisplayElementDBVersion.ViewMode.SERVER, DisplayElementDBVersion.DBType.DOCUMENT, 125));
        specificViews.add(new DisplayElementDBVersion("ru.ssa.artixadmin.view.document.FailedmoneyItemTableView", DisplayElementDBVersion.ViewMode.CASH, DisplayElementDBVersion.DBType.DOCUMENT, 153));
        specificViews.add(new DisplayElementDBVersion("ru.ssa.artixadmin.view.document.FailedmoneyItemTableView", DisplayElementDBVersion.ViewMode.SERVER, DisplayElementDBVersion.DBType.DOCUMENT, 167));
        specificViews.add(new DisplayElementDBVersion("ru.ssa.artixadmin.view.document.CashierstatsTableView", DisplayElementDBVersion.ViewMode.CASH, DisplayElementDBVersion.DBType.DOCUMENT, 169));
        specificViews.add(new DisplayElementDBVersion("ru.ssa.artixadmin.view.document.CashierstatsTableView", DisplayElementDBVersion.ViewMode.SERVER, DisplayElementDBVersion.DBType.DOCUMENT, 193));
        specificViews.add(new DisplayElementDBVersion("ru.ssa.artixadmin.view.document.OrganizationTableView", DisplayElementDBVersion.ViewMode.CASH, DisplayElementDBVersion.DBType.DOCUMENT, 172));
        specificViews.add(new DisplayElementDBVersion("ru.ssa.artixadmin.view.document.OrganizationTableView", DisplayElementDBVersion.ViewMode.SERVER, DisplayElementDBVersion.DBType.DOCUMENT, 195));
        specificViews.add(new DisplayElementDBVersion("ru.ssa.artixadmin.view.document.NoteItemTableView", DisplayElementDBVersion.ViewMode.CASH, DisplayElementDBVersion.DBType.DOCUMENT, 176));
        specificViews.add(new DisplayElementDBVersion("ru.ssa.artixadmin.view.document.NoteItemTableView", DisplayElementDBVersion.ViewMode.SERVER, DisplayElementDBVersion.DBType.DOCUMENT, 200));
    }

    public void activate(boolean isCS) {
        IWorkbenchActivitySupport activitySupport = PlatformUI.getWorkbench().getActivitySupport();
        IActivityManager activityManager = activitySupport.getActivityManager();
        HashSet<String> enabledActivities = new HashSet<String>();
        for (Object oldId : activityManager.getEnabledActivityIds()) {
            if (((String)oldId).endsWith(activitySuffix)) continue;
            enabledActivities.add((String)oldId);
        }
        for (DisplayElementDBVersion element : specificViews) {
            log.trace("work with element:{}", (Object)element);
            String activityId = element.getId().concat(activitySuffix);
            if (!activityManager.getActivity(activityId).isDefined() || !this.isActivate(element, isCS)) continue;
            enabledActivities.add(activityId);
        }
        activitySupport.setEnabledActivityIds(enabledActivities);
    }

    private boolean isActivate(DisplayElementDBVersion element, boolean isCS) {
        boolean result = false;
        if ((element.getMode() == DisplayElementDBVersion.ViewMode.BOTH || isCS == (element.getMode() == DisplayElementDBVersion.ViewMode.SERVER)) && (element.getDBType() == DisplayElementDBVersion.DBType.DICTIONARY ? element.getDBVersion() <= LibActivator.getDefault().getDictionaryVersion() : element.getDBType() != DisplayElementDBVersion.DBType.DOCUMENT || element.getDBVersion() <= LibActivator.getDefault().getDocumentVersion())) {
            result = true;
        }
        log.trace("check activiti:{} result={}", (Object)element, (Object)result);
        return result;
    }
}

