/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.artixadmin.view.directory.action;

import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ssa.artixadmin.view.directory.action.DownActionHotKey;
import ru.ssa.artixadmin.view.directory.action.HotKeyInventViewPanel;
import ru.ssa.artixadmin.view.directory.action.HotKeyTableView;
import ru.ssa.artixadmin.view.directory.action.UpActionHotKey;
import ru.ssa.cashadmin.LibActivator;
import ru.ssa.cashadmin.domain.HotKey;
import ru.ssa.cashadmin.domain.HotKeyInvent;
import su.artix.cashserver.security.SecurityKey;
import su.artix.yuki.action.DirectoryEditActionGroup;
import su.artix.yuki.images.ArtixAdminImages;
import su.artix.yuki.provider.LazyContentProvider;
import su.artix.yuki.provider.PojoTableLabelProvider;
import su.artix.yuki.view.DirectoryTableView;
import su.artix.yuki.view.DirectoryViewPanel;

@SecurityKey(title="\u0421\u0435\u0440\u0432\u0438\u0441. \u0413\u043e\u0440\u044f\u0447\u0438\u0435 \u043a\u043b\u0430\u0432\u0438\u0448\u0438. \u041f\u043e\u0437\u0438\u0446\u0438\u0438 \u0433\u043e\u0440\u044f\u0447\u0438\u0445 \u043a\u043b\u0430\u0432\u0438\u0448")
public class HotKeyInventTableView
extends DirectoryTableView<HotKeyInvent> {
    public static final String ID = "ru.ssa.artixadmin.view.directory.HotKeyInventTableView";
    private static final Logger log = LoggerFactory.getLogger(HotKeyInventTableView.class);
    @SecurityKey(title="\u041f\u0435\u0440\u0435\u043c\u0435\u0441\u0442\u0438\u0442\u044c \u0432\u0432\u0435\u0440\u0445")
    private UpActionHotKey upAction;
    @SecurityKey(title="\u041f\u0435\u0440\u0435\u043c\u0435\u0441\u0442\u0438\u0442\u044c \u0432\u043d\u0438\u0437")
    private DownActionHotKey downAction;

    public void createPartControl(Composite parent) {
        this.setPojoClass(HotKeyInvent.class);
        this.setViewPanel((DirectoryViewPanel)new HotKeyInventViewPanel(parent, 0, false));
        this.getSite().setSelectionProvider((ISelectionProvider)this.getViewer());
        LazyContentProvider lazyContentProvider = new LazyContentProvider(HotKeyInvent.class, (TableViewer)this.getViewer());
        lazyContentProvider.setSortProperty("hotkeyinventid");
        ((TableViewer)this.getViewer()).setContentProvider((IContentProvider)lazyContentProvider);
        ((TableViewer)this.getViewer()).setLabelProvider((IBaseLabelProvider)new PojoTableLabelProvider(this.getColumns()));
        this.upAction = new UpActionHotKey((TableViewer)this.getViewer(), ArtixAdminImages.getDefault().getImageDescriptor("plane/16x16/up"));
        this.downAction = new DownActionHotKey((TableViewer)this.getViewer(), ArtixAdminImages.getDefault().getImageDescriptor("plane/16x16/down"));
        ArrayList<Action> customActions = new ArrayList<Action>();
        customActions.add(this.upAction);
        customActions.add(this.downAction);
        this.commonActionGroup = new DirectoryEditActionGroup(HotKeyInvent.class, customActions);
        this.commonActionGroup.removeAction(new String[]{"ru.ssa.artixadmin.action.DirectoryEditAction"});
        this.commonActionGroup.removeAction(new String[]{"ru.ssa.artixadmin.action.DirectoryCopyAction"});
        this.commonActionGroup.fillActionBars(this.getViewSite().getActionBars());
        this.commonActionGroup.setEnabledEditGroupActions(Boolean.valueOf(false));
        this.commonActionGroup.getAddAction().setEnabled(false);
        this.upAction.setEnabled(false);
        this.downAction.setEnabled(false);
        super.createPartControl(parent);
        this.restoreState();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selectionIn) {
        log.trace("selectionChanged part {} selection {}", (Object)part, (Object)selectionIn);
        IStructuredSelection selection = (IStructuredSelection)selectionIn;
        HotKeyInvent hotkeyInvent = (HotKeyInvent)LibActivator.getDefault().getActualClassResolver().getInstance(HotKeyInvent.class);
        if (part instanceof HotKeyTableView) {
            if (selection.size() == 1 && selection.getFirstElement() instanceof HotKey) {
                HotKey hotkey = (HotKey)selection.getFirstElement();
                hotkeyInvent.setHotkey(hotkey);
                this.getViewPanel().setInput((Object)hotkeyInvent);
                this.commonActionGroup.getAddAction().setModel((Object)hotkeyInvent);
                this.commonActionGroup.getAddAction().setEnabled(true);
                this.upAction.setEnabled(false);
                this.downAction.setEnabled(false);
            } else {
                this.commonActionGroup.getAddAction().setEnabled(false);
            }
        }
        if (part instanceof HotKeyInventTableView) {
            if (selection.size() == 1 && selection.getFirstElement() instanceof HotKeyInvent) {
                this.upAction.setEnabled(true);
                this.downAction.setEnabled(true);
            } else {
                this.upAction.setEnabled(false);
                this.downAction.setEnabled(false);
            }
        }
    }

    protected String getID() {
        return ID;
    }

    protected boolean isMaster() {
        return false;
    }
}

