/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.cashadmin.domain;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.annotations.Target;
import ru.ssa.cashadmin.domain.Barcodes;
import ru.ssa.cashadmin.domain.Invent;

@XmlAccessorType(value=XmlAccessType.NONE)
@Entity
@Table(name="tmcscale")
@MappedSuperclass
public class TmcScale {
    @XmlElement
    @NotNull
    @Id
    private String tmcscalecode;
    @XmlTransient
    @ManyToOne
    @JoinColumn(name="tmcscalecode", referencedColumnName="barcode", insertable=false, updatable=false)
    @NotFound(action=NotFoundAction.IGNORE)
    @Target(value=Barcodes.class)
    @NotNull
    private Barcodes barcode;
    @XmlTransient
    @ManyToOne
    @JoinColumn(name="tmccode", referencedColumnName="code", insertable=false, updatable=false)
    @NotFound(action=NotFoundAction.IGNORE)
    @Target(value=Invent.class)
    @NotNull
    private Invent invent;
    @XmlElement
    @Column(name="tmccode")
    @NotNull
    private String tmccode;
    @XmlElement
    private String tmcscalegroupcode;
    private Integer plu;

    protected TmcScale() {
    }

    public void setInvent(Invent invent) {
        this.invent = invent;
        this.tmccode = invent != null ? invent.getCode() : null;
    }

    public void setBarcode(Barcodes barcode) {
        this.barcode = barcode;
        this.tmcscalecode = barcode != null ? barcode.getBarcode() : null;
    }

    public Invent getInvent() {
        return this.invent;
    }

    public String getTmcscalecode() {
        return this.tmcscalecode;
    }

    public void setTmcscalecode(String tmcscalecode) {
        this.tmcscalecode = tmcscalecode;
    }

    public Integer getPlu() {
        return this.plu;
    }

    public void setPlu(Integer plu) {
        this.plu = plu;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.tmccode == null ? 0 : this.tmccode.hashCode());
        result = 31 * result + (this.tmcscalecode == null ? 0 : this.tmcscalecode.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TmcScale other = (TmcScale)obj;
        if (this.tmccode == null ? other.tmccode != null : !this.tmccode.equals(other.tmccode)) {
            return false;
        }
        return !(this.tmcscalecode == null ? other.tmcscalecode != null : !this.tmcscalecode.equals(other.tmcscalecode));
    }

    public String getTmccode() {
        return this.tmccode;
    }

    public void setTmccode(String tmccode) {
        this.tmccode = tmccode;
    }

    public String getTmcscalegroupcode() {
        return this.tmcscalegroupcode;
    }

    public void setTmcscalegroupcode(String tmcscalegroupcode) {
        this.tmcscalegroupcode = tmcscalegroupcode;
    }

    public Barcodes getBarcode() {
        return this.barcode;
    }
}

