/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DragSourceEffect;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;

public class TableDragSourceEffect
extends DragSourceEffect {
    Image dragSourceImage = null;

    public TableDragSourceEffect(Table table) {
        super(table);
    }

    public void dragFinished(DragSourceEvent event) {
        if (this.dragSourceImage != null) {
            this.dragSourceImage.dispose();
        }
        this.dragSourceImage = null;
    }

    public void dragStart(DragSourceEvent event) {
        event.image = this.getDragSourceImage(event);
    }

    Image getDragSourceImage(DragSourceEvent event) {
        int[] model;
        if (this.dragSourceImage != null) {
            this.dragSourceImage.dispose();
        }
        this.dragSourceImage = null;
        Table table = (Table)this.control;
        if (OS.GTK_VERSION < OS.VERSION(2, 2, 0)) {
            return null;
        }
        if (table.isListening(40) || table.isListening(42)) {
            return null;
        }
        int handle = table.handle;
        int selection = OS.gtk_tree_view_get_selection(handle);
        int list = OS.gtk_tree_selection_get_selected_rows(selection, model = OS.GTK_VERSION < OS.VERSION(2, 2, 4) ? new int[1] : null);
        if (list == 0) {
            return null;
        }
        int count = Math.min(10, OS.g_list_length(list));
        Display display = table.getDisplay();
        if (count == 1) {
            int path = OS.g_list_nth_data(list, 0);
            int pixmap = OS.gtk_tree_view_create_row_drag_icon(handle, path);
            this.dragSourceImage = Image.gtk_new(display, 1, pixmap, 0);
        } else {
            int width = 0;
            int height = 0;
            int[] w = new int[1];
            int[] h = new int[1];
            int[] yy = new int[count];
            int[] hh = new int[count];
            int[] pixmaps = new int[count];
            GdkRectangle rect = new GdkRectangle();
            int i = 0;
            while (i < count) {
                int path = OS.g_list_nth_data(list, i);
                OS.gtk_tree_view_get_cell_area(handle, path, 0, rect);
                pixmaps[i] = OS.gtk_tree_view_create_row_drag_icon(handle, path);
                OS.gdk_drawable_get_size(pixmaps[i], w, h);
                width = Math.max(width, w[0]);
                height = rect.y + h[0] - yy[0];
                yy[i] = rect.y;
                hh[i] = h[0];
                ++i;
            }
            int source = OS.gdk_pixmap_new(OS.GDK_ROOT_PARENT(), width, height, -1);
            int gcSource = OS.gdk_gc_new(source);
            int mask = OS.gdk_pixmap_new(OS.GDK_ROOT_PARENT(), width, height, 1);
            int gcMask = OS.gdk_gc_new(mask);
            GdkColor color = new GdkColor();
            color.pixel = 0;
            OS.gdk_gc_set_foreground(gcMask, color);
            OS.gdk_draw_rectangle(mask, gcMask, 1, 0, 0, width, height);
            color.pixel = 1;
            OS.gdk_gc_set_foreground(gcMask, color);
            int i2 = 0;
            while (i2 < count) {
                OS.gdk_draw_drawable(source, gcSource, pixmaps[i2], 0, 0, 0, yy[i2] - yy[0], -1, -1);
                OS.gdk_draw_rectangle(mask, gcMask, 1, 0, yy[i2] - yy[0], width, hh[i2]);
                OS.g_object_unref(pixmaps[i2]);
                ++i2;
            }
            OS.g_object_unref(gcSource);
            OS.g_object_unref(gcMask);
            this.dragSourceImage = Image.gtk_new(display, 1, source, mask);
        }
        OS.g_list_free(list);
        return this.dragSourceImage;
    }
}

