/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.login;

import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.mihalis.opal.login.LoginDialogVerifier;
import org.mihalis.opal.opalDialog.Dialog;
import org.mihalis.opal.utils.ResourceManager;
import org.mihalis.opal.utils.SWTGraphicUtil;

public class LoginDialog {
    private Image image;
    private String description;
    private String login;
    private String password;
    private List<String> autorizedLogin;
    private boolean displayRememberPassword = true;
    private boolean rememberPassword;
    private LoginDialogVerifier verifier;
    private Shell shell;
    private boolean returnedValue;
    private Button buttonOk;

    public boolean open() {
        if (this.verifier == null) {
            throw new IllegalArgumentException("Please set a verifier before opening the dialog box");
        }
        this.buildDialog();
        this.openShell();
        return this.returnedValue;
    }

    private void buildDialog() {
        this.buildShell();
        this.buildImage();
        this.buildDescription();
        this.buildLogin();
        this.buildPassword();
        if (this.displayRememberPassword) {
            this.buildRememberPassword();
        }
        this.buildButtons();
    }

    private void buildShell() {
        this.shell = new Shell(133152);
        this.shell.setText(ResourceManager.getLabel("login"));
        this.shell.setLayout((Layout)new GridLayout(4, false));
    }

    private void buildImage() {
        Canvas canvas = new Canvas((Composite)this.shell, 0x20000000);
        GridData gridData = new GridData(4, 4, true, false, 4, 1);
        gridData.widthHint = 400;
        gridData.heightHint = 60;
        canvas.setLayoutData((Object)gridData);
        canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                paintEvent.gc.drawImage(LoginDialog.this.image == null ? LoginDialog.this.createDefaultImage(paintEvent.width, paintEvent.height) : LoginDialog.this.image, 0, 0);
            }
        });
    }

    private Image createDefaultImage(int n, int n2) {
        Display display = Display.getCurrent();
        Color color = new Color((Device)display, 49, 121, 242);
        Color color2 = new Color((Device)display, 155, 185, 245);
        Color color3 = new Color((Device)display, 53, 123, 242);
        Image image = new Image((Device)display, n, n2);
        GC gC = new GC((Drawable)image);
        gC.setAdvanced(true);
        gC.setAntialias(1);
        gC.setBackground(color);
        gC.fillRectangle(0, 0, n, n2);
        Path path = new Path((Device)display);
        path.moveTo(0.0f, (float)n2 * 0.6f);
        path.cubicTo((float)n * 0.167f, (float)n2 * 1.2f, (float)n * 0.667f, (float)n2 * -0.5f, (float)n, (float)n2 * 0.75f);
        path.lineTo((float)n, (float)n2);
        path.lineTo(0.0f, (float)n2);
        path.lineTo(0.0f, (float)n2 * 0.8f);
        path.close();
        Pattern pattern = new Pattern((Device)display, 0.0f, 0.0f, 1.0f, (float)n2 * 1.2f, color2, color3);
        gC.setBackgroundPattern(pattern);
        gC.fillPath(path);
        Font font = new Font((Device)display, "Arial Bold", 30, 0);
        gC.setFont(font);
        gC.setForeground(display.getSystemColor(1));
        Point point = gC.stringExtent(ResourceManager.getLabel("login"));
        gC.drawString(ResourceManager.getLabel("login"), (int)((float)n * 0.05f), (n2 - point.y) / 2, true);
        font.dispose();
        path.dispose();
        pattern.dispose();
        color.dispose();
        color2.dispose();
        color3.dispose();
        gC.dispose();
        return image;
    }

    private void buildDescription() {
        Label label = new Label((Composite)this.shell, 0);
        GridData gridData = new GridData(4, 1, true, false, 4, 1);
        gridData.verticalIndent = 5;
        gridData.horizontalIndent = 5;
        label.setLayoutData((Object)gridData);
        Font font = SWTGraphicUtil.buildFontFrom((Control)label, 1);
        label.setFont(font);
        SWTGraphicUtil.addDisposer((Widget)label, (Resource)font);
        if (this.description == null || this.description.trim().equals("")) {
            label.setText(" ");
        } else {
            label.setText(this.description);
        }
    }

    private void buildLogin() {
        Label label = new Label((Composite)this.shell, 0);
        GridData gridData = new GridData(3, 3, false, false, 1, 1);
        gridData.horizontalIndent = 35;
        gridData.verticalIndent = 15;
        label.setLayoutData((Object)gridData);
        label.setText(ResourceManager.getLabel("name"));
        if (this.autorizedLogin != null && !this.autorizedLogin.isEmpty()) {
            this.buildLoginCombo();
        } else {
            this.buildLoginText();
        }
    }

    private void buildLoginCombo() {
        final Combo combo = new Combo((Composite)this.shell, 2056);
        combo.setLayoutData((Object)new GridData(4, 3, true, false, 3, 1));
        for (String string : this.autorizedLogin) {
            combo.add(string);
        }
        combo.setText(this.login == null ? "" : this.login);
        combo.setFocus();
        combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                LoginDialog.this.login = combo.getText();
                LoginDialog.this.changeButtonOkState();
            }
        });
    }

    private void buildLoginText() {
        final Text text = new Text((Composite)this.shell, 2048);
        text.setText(this.login == null ? "" : this.login);
        text.setLayoutData((Object)new GridData(4, 3, true, false, 3, 1));
        text.setFocus();
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                LoginDialog.this.login = text.getText();
                LoginDialog.this.changeButtonOkState();
            }
        });
    }

    private void buildPassword() {
        Label label = new Label((Composite)this.shell, 0);
        GridData gridData = new GridData(3, 2, false, false, 1, 1);
        gridData.horizontalIndent = 35;
        label.setLayoutData((Object)gridData);
        label.setText(ResourceManager.getLabel("password"));
        final Text text = new Text((Composite)this.shell, 0x400800);
        text.setText(this.password == null ? "" : this.password);
        text.setLayoutData((Object)new GridData(4, 2, true, false, 3, 1));
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                LoginDialog.this.password = text.getText();
                LoginDialog.this.changeButtonOkState();
            }
        });
    }

    private void changeButtonOkState() {
        boolean bl = this.login != null && !this.login.trim().equals("");
        boolean bl2 = this.password != null && !this.password.trim().equals("");
        this.buttonOk.setEnabled(bl && bl2);
    }

    private void buildRememberPassword() {
        Button button = new Button((Composite)this.shell, 32);
        GridData gridData = new GridData(1, 2, true, false, 4, 1);
        gridData.horizontalIndent = 35;
        button.setLayoutData((Object)gridData);
        button.setText(ResourceManager.getLabel("rememberPassword"));
        button.setSelection(this.rememberPassword);
    }

    private void buildButtons() {
        this.buildOkButton();
        this.buildCancelButton();
    }

    private void buildOkButton() {
        this.buttonOk = new Button((Composite)this.shell, 8);
        GridData gridData = new GridData(3, 2, true, false, 3, 1);
        gridData.verticalIndent = 60;
        gridData.minimumWidth = 80;
        this.buttonOk.setLayoutData((Object)gridData);
        this.buttonOk.setText(ResourceManager.getLabel("Ok"));
        this.buttonOk.setEnabled(false);
        this.buttonOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                try {
                    LoginDialog.this.verifier.authenticate(LoginDialog.this.login, LoginDialog.this.password);
                    LoginDialog.this.returnedValue = true;
                    LoginDialog.this.shell.dispose();
                }
                catch (Exception exception) {
                    Dialog.error(ResourceManager.getLabel("loginFailed"), exception.getMessage());
                    for (Control control : LoginDialog.this.shell.getChildren()) {
                        if (!(control instanceof Text) && !(control instanceof Combo)) continue;
                        control.setFocus();
                        break;
                    }
                }
            }
        });
    }

    private void buildCancelButton() {
        Button button = new Button((Composite)this.shell, 8);
        GridData gridData = new GridData(4, 2, false, false);
        gridData.widthHint = 80;
        gridData.verticalIndent = 60;
        button.setLayoutData((Object)gridData);
        button.setText(ResourceManager.getLabel("Cancel"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                LoginDialog.this.returnedValue = false;
                LoginDialog.this.shell.dispose();
            }
        });
    }

    private void openShell() {
        this.shell.setDefaultButton(this.buttonOk);
        this.shell.pack();
        this.shell.open();
        SWTGraphicUtil.centerShell(this.shell);
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
    }

    public Image getImage() {
        return this.image;
    }

    public String getDescription() {
        return this.description;
    }

    public String getLogin() {
        return this.login == null ? null : this.login.trim();
    }

    public String getPassword() {
        return this.password == null ? null : this.password.trim();
    }

    public List<String> getAutorizedLogin() {
        return this.autorizedLogin;
    }

    public boolean isDisplayRememberPassword() {
        return this.displayRememberPassword;
    }

    public boolean isRememberPassword() {
        return this.rememberPassword;
    }

    public LoginDialogVerifier getVerifier() {
        return this.verifier;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setLogin(String string) {
        this.login = string;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setAutorizedLogin(List<String> list) {
        this.autorizedLogin = list;
    }

    public void setAutorizedLogin(String ... stringArray) {
        this.autorizedLogin = Arrays.asList(stringArray);
    }

    public void setDisplayRememberPassword(boolean bl) {
        this.displayRememberPassword = bl;
    }

    public void setRememberPassword(boolean bl) {
        this.rememberPassword = bl;
    }

    public void setVerifier(LoginDialogVerifier loginDialogVerifier) {
        this.verifier = loginDialogVerifier;
    }
}

