/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.propertyTable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.custom.ControlEditor;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.mihalis.opal.propertyTable.AbstractPTWidget;
import org.mihalis.opal.propertyTable.PTProperty;
import org.mihalis.opal.propertyTable.editor.PTStringEditor;
import org.mihalis.opal.utils.ResourceManager;
import org.mihalis.opal.utils.StringUtil;

class PTWidgetTable
extends AbstractPTWidget {
    private Table table;

    PTWidgetTable() {
    }

    @Override
    protected void buildWidget(Composite composite) {
        this.table = new Table(composite, 65536);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.table.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        final TableColumn tableColumn = new TableColumn(this.table, 0);
        tableColumn.setText(ResourceManager.getLabel("property"));
        final TableColumn tableColumn2 = new TableColumn(this.table, 0);
        tableColumn2.setText(ResourceManager.getLabel("value"));
        this.fillData();
        this.table.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                Rectangle rectangle = PTWidgetTable.this.table.getParent().getClientArea();
                Point point = PTWidgetTable.this.table.computeSize(-1, -1);
                ScrollBar scrollBar = PTWidgetTable.this.table.getVerticalBar();
                int n = rectangle.width - ((PTWidgetTable)PTWidgetTable.this).table.computeTrim((int)0, (int)0, (int)0, (int)0).width - scrollBar.getSize().x;
                if (point.y > rectangle.height + PTWidgetTable.this.table.getHeaderHeight()) {
                    Point point2 = scrollBar.getSize();
                    n -= point2.x;
                }
                tableColumn.pack();
                tableColumn2.setWidth(n - tableColumn.getWidth());
                PTWidgetTable.this.table.removeControlListener((ControlListener)this);
            }
        });
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (PTWidgetTable.this.table.getSelectionCount() == 0 || PTWidgetTable.this.table.getSelection()[0] == null) {
                    return;
                }
                PTWidgetTable.this.updateDescriptionPanel(PTWidgetTable.this.table.getSelection()[0].getData());
            }
        });
    }

    private void fillData() {
        List<PTProperty> list;
        if (this.getParentPropertyTable().sorted) {
            list = new ArrayList<PTProperty>(this.getParentPropertyTable().getPropertiesAsList());
            Collections.sort(list, new Comparator<PTProperty>(){

                @Override
                public int compare(PTProperty pTProperty, PTProperty pTProperty2) {
                    if (pTProperty == null && pTProperty2 == null) {
                        return 0;
                    }
                    if (pTProperty.getName() == null && pTProperty2.getName() != null) {
                        return -1;
                    }
                    if (pTProperty.getName() != null && pTProperty2.getName() == null) {
                        return 1;
                    }
                    return pTProperty.getName().compareTo(pTProperty2.getName());
                }
            });
        } else {
            list = this.getParentPropertyTable().getPropertiesAsList();
        }
        ArrayList arrayList = new ArrayList();
        for (PTProperty pTProperty : list) {
            TableItem tableItem = new TableItem(this.table, 0);
            tableItem.setData((Object)pTProperty);
            tableItem.setText(0, StringUtil.safeToString(pTProperty.getDisplayName()));
            if (pTProperty.getEditor() == null) {
                pTProperty.setEditor(new PTStringEditor());
            }
            final ControlEditor controlEditor = pTProperty.getEditor().render(this, (Item)tableItem, pTProperty);
            tableItem.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent disposeEvent) {
                    if (controlEditor.getEditor() != null) {
                        controlEditor.getEditor().dispose();
                    }
                    controlEditor.dispose();
                }
            });
            if (pTProperty.isEnabled()) continue;
            tableItem.setForeground(this.table.getDisplay().getSystemColor(15));
        }
        this.table.setData(arrayList);
    }

    @Override
    public void refillData() {
        for (TableItem tableItem : this.table.getItems()) {
            tableItem.dispose();
        }
        if (this.table.getData() != null) {
            List list = (List)this.table.getData();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ControlEditor controlEditor = (ControlEditor)iterator.next();
                controlEditor.dispose();
            }
            list.clear();
            this.table.setData(null);
        }
        this.fillData();
    }

    @Override
    public Composite getWidget() {
        return this.table;
    }
}

