/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.systemMonitor;

import java.lang.management.ManagementFactory;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeDataSupport;
import org.mihalis.opal.systemMonitor.Sample;

public class HeapMemorySample
implements Sample {
    private static final String COMMITTED = "committed";
    private static final String USED = "used";
    private static final String HEAP_MEMORY_USAGE = "HeapMemoryUsage";
    private static final String OBJECT_NAME_ATTRIBUTE = "java.lang:type=Memory";
    private final MBeanServerConnection mBeanServerConnection = ManagementFactory.getPlatformMBeanServer();
    private final ObjectName objectName;

    HeapMemorySample() {
        try {
            this.objectName = new ObjectName(OBJECT_NAME_ATTRIBUTE);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public double getValue() {
        try {
            return (double)((Long)((CompositeDataSupport)this.mBeanServerConnection.getAttribute(this.objectName, HEAP_MEMORY_USAGE)).get(USED)).longValue() / 1024.0 / 1024.0;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public double getMaxValue() {
        try {
            return (double)((Long)((CompositeDataSupport)this.mBeanServerConnection.getAttribute(this.objectName, HEAP_MEMORY_USAGE)).get(COMMITTED)).longValue() / 1024.0 / 1024.0;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }
}

