/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.generic;

import com.sun.org.apache.bcel.internal.classfile.ClassElementValue;
import com.sun.org.apache.bcel.internal.classfile.ConstantUtf8;
import com.sun.org.apache.bcel.internal.classfile.ElementValue;
import com.sun.org.apache.bcel.internal.generic.ConstantPoolGen;
import com.sun.org.apache.bcel.internal.generic.ElementValueGen;
import com.sun.org.apache.bcel.internal.generic.ObjectType;
import java.io.DataOutputStream;
import java.io.IOException;

public class ClassElementValueGen
extends ElementValueGen {
    private int idx;

    protected ClassElementValueGen(int typeIdx, ConstantPoolGen cpool) {
        super(99, cpool);
        this.idx = typeIdx;
    }

    public ClassElementValueGen(ObjectType t, ConstantPoolGen cpool) {
        super(99, cpool);
        this.idx = cpool.addUtf8(t.getSignature());
    }

    @Override
    public ElementValue getElementValue() {
        return new ClassElementValue(super.getElementValueType(), this.idx, this.getConstantPool().getConstantPool());
    }

    public ClassElementValueGen(ClassElementValue value, ConstantPoolGen cpool, boolean copyPoolEntries) {
        super(99, cpool);
        this.idx = copyPoolEntries ? cpool.addUtf8(value.getClassString()) : value.getIndex();
    }

    public int getIndex() {
        return this.idx;
    }

    public String getClassString() {
        ConstantUtf8 cu8 = (ConstantUtf8)this.getConstantPool().getConstant(this.idx);
        return cu8.getBytes();
    }

    @Override
    public String stringifyValue() {
        return this.getClassString();
    }

    @Override
    public void dump(DataOutputStream dos) throws IOException {
        dos.writeByte(super.getElementValueType());
        dos.writeShort(this.idx);
    }
}

