/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.artixadmin.view.directory.action;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ssa.cashadmin.LibActivator;
import ru.ssa.cashadmin.domain.HotKeyInvent;
import ru.ssa.cashadmin.excep.ExecuteQueryException;
import su.artix.yuki.model.ModelActivator;
import su.artix.yuki.model.directory.DirectoryEditModel;

class DownActionHotKey
extends Action {
    private static final Logger log = LoggerFactory.getLogger(DownActionHotKey.class);
    private HotKeyInvent model;
    private TableViewer tableViewer;

    private DownActionHotKey() {
        super("\u0423\u0432\u0435\u043b\u0438\u0447\u0435\u043d\u0438\u0435 \u043f\u043e\u0440\u044f\u0434\u043a\u0430");
        this.setToolTipText("\u0423\u0432\u0435\u043b\u0438\u0447\u0435\u043d\u0438\u0435 \u043f\u043e\u0440\u044f\u0434\u043a\u0430 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430");
    }

    public DownActionHotKey(TableViewer tableViewer, ImageDescriptor imageDescriptor) {
        this();
        this.tableViewer = tableViewer;
        this.setImageDescriptor(imageDescriptor);
    }

    public void run() {
        try {
            DirectoryEditModel directoryModel = ModelActivator.getDefault().getModelProvider().getDirectoryModel(HotKeyInvent.class);
            this.model = (HotKeyInvent)((StructuredSelection)this.tableViewer.getSelection()).getFirstElement();
            if (this.model != null && this.model.getHotkey() != null) {
                HotKeyInvent filter = (HotKeyInvent)LibActivator.getDefault().getActualClassResolver().getInstance(HotKeyInvent.class);
                filter.setHotkey(this.model.getHotkey());
                List hotkeyInvents = directoryModel.getList((Object)filter);
                Collections.sort(hotkeyInvents, new Comparator<HotKeyInvent>(){

                    @Override
                    public int compare(HotKeyInvent o1, HotKeyInvent o2) {
                        return o1.getHotkeyinventid().compareTo(o2.getHotkeyinventid());
                    }
                });
                int count = hotkeyInvents.size();
                int downIndex = hotkeyInvents.indexOf(this.model);
                if (downIndex + 1 < count) {
                    int order = this.model.getHotkeyinventid();
                    HotKeyInvent downModel = this.model;
                    while (order == this.model.getHotkeyinventid() && downIndex + 1 < count) {
                        downModel = (HotKeyInvent)hotkeyInvents.get(++downIndex);
                        order = downModel.getHotkeyinventid();
                    }
                    downModel.setHotkeyinventid(this.model.getHotkeyinventid());
                    this.model.setHotkeyinventid(Integer.valueOf(order));
                    directoryModel.doUpdate((Object)this.model);
                    directoryModel.doUpdate((Object)downModel);
                    directoryModel.doRefresh();
                    this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)this.model));
                }
            }
        }
        catch (ExecuteQueryException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

