/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.cashadmin.domain;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.MappedSuperclass;
import javax.persistence.Table;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import ru.ssa.cashadmin.domain.PricesPK;

@Entity
@Table(name="prices")
@MappedSuperclass
public class Prices
implements Serializable {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    private PricesPK pk = new PricesPK();
    @NotNull
    @Size(max=100)
    @Column(insertable=false, updatable=false)
    private String barcode;
    @Size(max=100)
    @Column(insertable=false, updatable=false)
    private String documentid;
    @NotNull
    @Column(insertable=false, updatable=false)
    private Integer doctype;
    @NotNull
    private Date effectivedate;
    @NotNull
    @Min(value=0L)
    @Digits(integer=15, fraction=2)
    private BigDecimal price;
    @NotNull
    @Min(value=0L)
    @Digits(integer=15, fraction=2)
    private BigDecimal minprice;

    protected Prices() {
    }

    public PricesPK getPk() {
        return this.pk;
    }

    public void setPk(PricesPK pk) {
        this.pk = pk;
    }

    public String getBarcode() {
        return this.barcode;
    }

    public void setBarcode(String barcode) {
        this.barcode = barcode;
        if (barcode != null) {
            this.pk.setBarcode(barcode);
        } else {
            this.pk.setBarcode(null);
        }
    }

    public String getDocumentid() {
        return this.documentid;
    }

    public void setDocumentid(String documentid) {
        this.documentid = documentid;
        if (documentid != null) {
            this.pk.setDocumentid(documentid);
        } else {
            this.pk.setDocumentid(null);
        }
    }

    public Integer getDoctype() {
        return this.doctype;
    }

    public void setDoctype(Integer doctype) {
        this.doctype = doctype;
        if (doctype != null) {
            this.pk.setDoctype(doctype);
        } else {
            this.pk.setDoctype(null);
        }
    }

    public Date getEffectivedate() {
        return this.effectivedate;
    }

    public void setEffectivedate(Date effectivedate) {
        this.effectivedate = effectivedate;
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public BigDecimal getMinprice() {
        return this.minprice;
    }

    public void setMinprice(BigDecimal minprice) {
        this.minprice = minprice;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.barcode == null ? 0 : this.barcode.hashCode());
        result = 31 * result + (this.doctype == null ? 0 : this.doctype.hashCode());
        result = 31 * result + (this.documentid == null ? 0 : this.documentid.hashCode());
        result = 31 * result + (this.effectivedate == null ? 0 : this.effectivedate.hashCode());
        result = 31 * result + (this.minprice == null ? 0 : this.minprice.hashCode());
        result = 31 * result + (this.pk == null ? 0 : this.pk.hashCode());
        result = 31 * result + (this.price == null ? 0 : this.price.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Prices other = (Prices)obj;
        if (this.barcode == null ? other.barcode != null : !this.barcode.equals(other.barcode)) {
            return false;
        }
        if (this.doctype == null ? other.doctype != null : !this.doctype.equals(other.doctype)) {
            return false;
        }
        if (this.documentid == null ? other.documentid != null : !this.documentid.equals(other.documentid)) {
            return false;
        }
        if (this.effectivedate == null ? other.effectivedate != null : !this.effectivedate.equals(other.effectivedate)) {
            return false;
        }
        if (this.minprice == null ? other.minprice != null : !this.minprice.equals(other.minprice)) {
            return false;
        }
        if (this.pk == null ? other.pk != null : !this.pk.equals(other.pk)) {
            return false;
        }
        return !(this.price == null ? other.price != null : !this.price.equals(other.price));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Prices [pk=");
        builder.append(this.pk);
        builder.append(", barcode=");
        builder.append(this.barcode);
        builder.append(", documentid=");
        builder.append(this.documentid);
        builder.append(", doctype=");
        builder.append(this.doctype);
        builder.append(", effectivedate=");
        builder.append(this.effectivedate);
        builder.append(", price=");
        builder.append(this.price);
        builder.append(", minprice=");
        builder.append(this.minprice);
        builder.append("]");
        return builder.toString();
    }

    public void setEffectivedateend(Date date) {
    }

    public void initDefault() {
    }
}

