/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class DelayQueue<E extends Delayed>
extends AbstractQueue<E>
implements BlockingQueue<E> {
    private final transient ReentrantLock lock = new ReentrantLock();
    private final PriorityQueue<E> q = new PriorityQueue();
    private Thread leader = null;
    private final Condition available = this.lock.newCondition();

    public DelayQueue() {
    }

    public DelayQueue(Collection<? extends E> collection) {
        this.addAll(collection);
    }

    @Override
    public boolean add(E e) {
        return this.offer(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E e) {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            this.q.offer(e);
            if (this.q.peek() == e) {
                this.leader = null;
                this.available.signal();
            }
            boolean bl = true;
            return bl;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public void put(E e) {
        this.offer(e);
    }

    @Override
    public boolean offer(E e, long l, TimeUnit timeUnit) {
        return this.offer(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            Delayed delayed = (Delayed)this.q.peek();
            if (delayed == null || delayed.getDelay(TimeUnit.NANOSECONDS) > 0L) {
                E e = null;
                return e;
            }
            Delayed delayed2 = (Delayed)this.q.poll();
            return (E)delayed2;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public E take() throws InterruptedException {
        var1_1 = this.lock;
        var1_1.lockInterruptibly();
        block7: while (true) {
            while (true) lbl-1000:
            // 4 sources

            {
                if ((var2_2 = (Delayed)this.q.peek()) == null) {
                    this.available.await();
                    continue block7;
                }
                var3_3 = var2_2.getDelay(TimeUnit.NANOSECONDS);
                if (var3_3 <= 0L) {
                    var5_4 = (Delayed)this.q.poll();
                    return (E)var5_4;
                }
                var2_2 = null;
                if (this.leader != null) {
                    this.available.await();
                    continue;
                }
                this.leader = var5_4 = Thread.currentThread();
                try {
                    this.available.awaitNanos(var3_3);
                }
                finally {
                    if (this.leader != var5_4) continue;
                    this.leader = null;
                    continue;
                }
                break;
            }
            break;
        }
        ** GOTO lbl-1000
        finally {
            if (this.leader == null && this.q.peek() != null) {
                this.available.signal();
            }
            var1_1.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public E poll(long var1_1, TimeUnit var3_2) throws InterruptedException {
        var4_3 = var3_2.toNanos(var1_1);
        var6_4 = this.lock;
        var6_4.lockInterruptibly();
        while (true) lbl-1000:
        // 5 sources

        {
            if ((var7_5 = (Delayed)this.q.peek()) == null) {
                if (var4_3 <= 0L) {
                    var8_7 = null;
                    return var8_7;
                }
                var4_3 = this.available.awaitNanos(var4_3);
                continue;
            }
            var8_6 = var7_5.getDelay(TimeUnit.NANOSECONDS);
            if (var8_6 <= 0L) {
                var10_8 = (Delayed)this.q.poll();
                return (E)var10_8;
            }
            if (var4_3 <= 0L) {
                var10_8 = null;
                return (E)var10_8;
            }
            var7_5 = null;
            if (var4_3 < var8_6 || this.leader != null) {
                var4_3 = this.available.awaitNanos(var4_3);
                continue;
            }
            this.leader = var10_8 = Thread.currentThread();
            try {
                var11_9 = this.available.awaitNanos(var8_6);
                var4_3 -= var8_6 - var11_9;
            }
            finally {
                if (this.leader != var10_8) continue;
                this.leader = null;
                continue;
            }
            break;
        }
        ** GOTO lbl-1000
        finally {
            if (this.leader == null && this.q.peek() != null) {
                this.available.signal();
            }
            var6_4.unlock();
        }
    }

    @Override
    public E peek() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            Delayed delayed = (Delayed)this.q.peek();
            return (E)delayed;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public int size() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            int n = this.q.size();
            return n;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    private E peekExpired() {
        Delayed delayed = (Delayed)this.q.peek();
        return (E)(delayed == null || delayed.getDelay(TimeUnit.NANOSECONDS) > 0L ? null : delayed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super E> collection) {
        if (collection == null) {
            throw new NullPointerException();
        }
        if (collection == this) {
            throw new IllegalArgumentException();
        }
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            E e;
            int n = 0;
            while ((e = this.peekExpired()) != null) {
                collection.add(e);
                this.q.poll();
                ++n;
            }
            int n2 = n;
            return n2;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super E> collection, int n) {
        if (collection == null) {
            throw new NullPointerException();
        }
        if (collection == this) {
            throw new IllegalArgumentException();
        }
        if (n <= 0) {
            return 0;
        }
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            E e;
            int n2;
            for (n2 = 0; n2 < n && (e = this.peekExpired()) != null; ++n2) {
                collection.add(e);
                this.q.poll();
            }
            int n3 = n2;
            return n3;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public void clear() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            this.q.clear();
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public int remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Object[] toArray() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            Object[] objectArray = this.q.toArray();
            return objectArray;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] TArray) {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            T[] TArray2 = this.q.toArray(TArray);
            return TArray2;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object object) {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            boolean bl = this.q.remove(object);
            return bl;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeEQ(Object object) {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            Iterator<E> iterator = this.q.iterator();
            while (iterator.hasNext()) {
                if (object != iterator.next()) continue;
                iterator.remove();
                break;
            }
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr(this.toArray());
    }

    private class Itr
    implements Iterator<E> {
        final Object[] array;
        int cursor;
        int lastRet = -1;

        Itr(Object[] objectArray) {
            this.array = objectArray;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.array.length;
        }

        @Override
        public E next() {
            if (this.cursor >= this.array.length) {
                throw new NoSuchElementException();
            }
            this.lastRet = this.cursor;
            return (Delayed)this.array[this.cursor++];
        }

        @Override
        public void remove() {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            DelayQueue.this.removeEQ(this.array[this.lastRet]);
            this.lastRet = -1;
        }
    }
}

