/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.artixadmin.editors.directory.goods;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolBar;
import ru.ssa.artixadmin.editors.directory.goods.InventEditPanel;
import ru.ssa.artixadmin.editors.directory.goods.PricesEditDialog;
import ru.ssa.artixadmin.provider.goods.PricesContentProvider;
import ru.ssa.artixadmin.view.directory.goods.PricesViewPanel;
import ru.ssa.cashadmin.LibActivator;
import ru.ssa.cashadmin.domain.Invent;
import ru.ssa.cashadmin.domain.Prices;
import ru.ssa.cashadmin.domain.PricesPK;
import su.artix.cashserver.security.SecurityKey;
import su.artix.yuki.action.TableViewerAddAction;
import su.artix.yuki.action.TableViewerEditAction;
import su.artix.yuki.action.TableViewerRemoveAction;
import su.artix.yuki.editors.EditorComposite;
import su.artix.yuki.model.ModelActivator;
import su.artix.yuki.model.directory.DirectoryAction;
import su.artix.yuki.provider.PojoTableLabelProvider;
import su.artix.yuki.view.DirectoryTableViewPanel;

@SecurityKey(title="\u041f\u0435\u0440\u0435\u043e\u0446\u0435\u043d\u043a\u0438 \u0442\u043e\u0432\u0430\u0440\u043e\u0432", parent=InventEditPanel.class)
public class InventPricesEditPanel
extends EditorComposite<Invent>
implements PropertyChangeListener {
    private final Invent model;
    @SecurityKey(title="\u0422\u0430\u0431\u043b\u0438\u0446\u0430")
    private DirectoryTableViewPanel<Prices> viewPanel;
    private PricesContentProvider pricesContentProvider;
    @SecurityKey(title="\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c")
    private TableViewerAddAction<Prices> addAction;
    @SecurityKey(title="\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c")
    private TableViewerEditAction<Prices> editAction;
    @SecurityKey(title="\u0423\u0434\u0430\u043b\u0438\u0442\u044c")
    private TableViewerRemoveAction<Prices> removeAction;

    public InventPricesEditPanel(Composite parent, int style, Invent model) {
        super(parent, style, Invent.class, (Object)model);
        this.model = model;
    }

    public void initialize() {
        GridLayoutFactory.swtDefaults().applyTo((Composite)this);
        PricesPK pricesPK = new PricesPK();
        Prices prices = (Prices)LibActivator.getDefault().getActualClassResolver().getInstance(Prices.class);
        prices.setPk(pricesPK);
        prices.setBarcode(this.model.getBcode());
        this.addAction = new TableViewerAddAction<Prices>(Prices.class, (PropertyChangeListener)this){

            protected void workWithDialog(Dialog dialog) {
                ((PricesEditDialog)dialog).setMap(InventPricesEditPanel.this.getPricesContentProvider().getMap());
            }
        };
        this.addAction.setModel((Object)prices);
        this.editAction = new TableViewerEditAction<Prices>(Prices.class, (PropertyChangeListener)this){

            protected void workWithDialog(Dialog dialog) {
                ((PricesEditDialog)dialog).setMap(InventPricesEditPanel.this.getPricesContentProvider().getMap());
            }
        };
        this.editAction.setEnabled(false);
        this.removeAction = new TableViewerRemoveAction(Prices.class, (PropertyChangeListener)this);
        this.removeAction.setEnabled(false);
        ToolBar toolBar = new ToolBar((Composite)this, 0x820000);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)toolBar);
        ToolBarManager toolBarManager = new ToolBarManager(toolBar);
        toolBarManager.add(this.addAction);
        toolBarManager.add(this.editAction);
        toolBarManager.add(this.removeAction);
        toolBarManager.update(true);
        this.viewPanel = new PricesViewPanel((Composite)this, 0, false){

            public void addEditByDoubleClick() {
                ((TableViewer)this.getViewer()).addDoubleClickListener(new IDoubleClickListener(){

                    public void doubleClick(DoubleClickEvent event) {
                        InventPricesEditPanel.this.editAction.run();
                    }
                });
            }
        };
        this.pricesContentProvider = new PricesContentProvider(this.model, (TableViewer)this.viewPanel.getViewer());
        ((TableViewer)this.viewPanel.getViewer()).setContentProvider((IContentProvider)this.pricesContentProvider);
        ((TableViewer)this.viewPanel.getViewer()).setLabelProvider((IBaseLabelProvider)new PojoTableLabelProvider(this.viewPanel.getColumns()));
        ((TableViewer)this.viewPanel.getViewer()).addSelectionChangedListener(this.editAction);
        ((TableViewer)this.viewPanel.getViewer()).addSelectionChangedListener(this.removeAction);
        ((TableViewer)this.viewPanel.getViewer()).addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                if (selection.getFirstElement() instanceof Prices) {
                    InventPricesEditPanel.this.editAction.setEnabled(true);
                    InventPricesEditPanel.this.removeAction.setEnabled(true);
                } else {
                    InventPricesEditPanel.this.editAction.setEnabled(false);
                    InventPricesEditPanel.this.removeAction.setEnabled(false);
                }
            }
        });
        this.viewPanel.setInput(null);
        super.initialize();
    }

    public void dispose() {
        ((TableViewer)this.viewPanel.getViewer()).removeSelectionChangedListener(this.editAction);
        ((TableViewer)this.viewPanel.getViewer()).removeSelectionChangedListener(this.removeAction);
        ModelActivator.getDefault().getModelProvider().getDirectoryModel(Prices.class).removePropertyChangeListener((PropertyChangeListener)this);
        super.dispose();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Map<Prices, String> map = this.pricesContentProvider.getMap();
        if (evt.getPropertyName().equals(DirectoryAction.ADD.toString())) {
            map.put((Prices)evt.getNewValue(), DirectoryAction.ADD.toString());
        } else if (evt.getPropertyName().equals(DirectoryAction.UPDATE.toString())) {
            map.remove(evt.getOldValue());
            map.put((Prices)evt.getOldValue(), DirectoryAction.REMOVE.toString());
            map.put((Prices)evt.getNewValue(), DirectoryAction.ADD.toString());
        } else if (evt.getPropertyName().equals(DirectoryAction.REMOVE.toString())) {
            map.put((Prices)evt.getNewValue(), DirectoryAction.REMOVE.toString());
        }
        ((TableViewer)this.viewPanel.getViewer()).refresh();
    }

    public PricesContentProvider getPricesContentProvider() {
        return this.pricesContentProvider;
    }
}

