/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.artixadmin.view.directory.goods;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import ru.ssa.artixadmin.view.directory.goods.InventViewPanel;
import ru.ssa.cashadmin.domain.Barcodes;
import ru.ssa.cashadmin.domain.Invent;
import ru.ssa.cashadmin.utils.AdditionalCriteria;
import ru.ssa.cashadmin.utils.ArtixFilter;
import su.artix.artixadmin.connection.ArtixAdminContextHolder;
import su.artix.yuki.model.ModelActivator;
import su.artix.yuki.model.directory.DirectoryAction;
import su.artix.yuki.provider.PojoTableLabelProvider;

public class SearchInventViewPanel
extends Composite
implements PropertyChangeListener {
    private Label searchTextLabel;
    private Text searchTextField;
    private Button barcodeBtn;
    private Button codeBtn;
    private Button nameBtn;
    private Button beginBtn;
    private Button endBtn;
    private Button anywhereBtn;
    private Button fullBtn;
    private Button searchBtn;
    private InventViewPanel viewPanel;
    private List<Invent> result = new ArrayList<Invent>();

    public SearchInventViewPanel(Composite parent, int style) {
        super(parent, style);
        this.createContent();
        ModelActivator.getDefault().getModelProvider().getDirectoryModel(Invent.class).addPropertyChangeListener((PropertyChangeListener)this);
    }

    private void createContent() {
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo((Composite)this);
        this.searchTextLabel = new Label((Composite)this, 0);
        this.searchTextLabel.setText("\u0421\u0442\u0440\u043e\u043a\u0430 \u043f\u043e\u0438\u0441\u043a\u0430:");
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.searchTextLabel);
        this.searchTextField = new Text((Composite)this, 2048);
        this.searchTextField.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 13) {
                    SearchInventViewPanel.this.doSearch();
                }
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo((Control)this.searchTextField);
        Group searchGroup = new Group((Composite)this, 4);
        searchGroup.setText("\u0418\u0441\u043a\u0430\u0442\u044c:");
        searchGroup.setLayout((Layout)new RowLayout(256));
        GridDataFactory.fillDefaults().span(1, 1).grab(false, false).applyTo((Control)searchGroup);
        this.barcodeBtn = new Button((Composite)searchGroup, 32);
        this.barcodeBtn.setText("\u041f\u043e \u0448\u0442\u0440\u0438\u0445-\u043a\u043e\u0434\u0443");
        this.barcodeBtn.setSelection(true);
        this.codeBtn = new Button((Composite)searchGroup, 32);
        this.codeBtn.setText("\u041f\u043e \u043a\u043e\u0434\u0443");
        this.nameBtn = new Button((Composite)searchGroup, 32);
        this.nameBtn.setText("\u041f\u043e \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u044e");
        this.nameBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchInventViewPanel.this.setDefaultAccordance(SearchInventViewPanel.this.nameBtn.getSelection());
            }
        });
        Group accordanceGroup = new Group((Composite)this, 4);
        accordanceGroup.setText("\u0421\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0438\u0435:");
        accordanceGroup.setLayout((Layout)new RowLayout(256));
        GridDataFactory.fillDefaults().span(1, 1).grab(true, false).applyTo((Control)accordanceGroup);
        this.beginBtn = new Button((Composite)accordanceGroup, 16);
        this.beginBtn.setText("\u0412 \u043d\u0430\u0447\u0430\u043b\u0435");
        this.endBtn = new Button((Composite)accordanceGroup, 16);
        this.endBtn.setText("\u0412 \u043a\u043e\u043d\u0446\u0435");
        this.anywhereBtn = new Button((Composite)accordanceGroup, 16);
        this.anywhereBtn.setText("\u041f\u043e \u0447\u0430\u0441\u0442\u0438");
        this.fullBtn = new Button((Composite)accordanceGroup, 16);
        this.fullBtn.setText("\u041f\u043e\u043b\u043d\u043e\u0435");
        this.fullBtn.setSelection(true);
        this.setDefaultAccordance(this.nameBtn.getSelection());
        this.searchBtn = new Button((Composite)this, 8);
        this.searchBtn.setText("\u0418\u0441\u043a\u0430\u0442\u044c");
        this.searchBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchInventViewPanel.this.doSearch();
            }
        });
        Group resultGroup = new Group((Composite)this, 4);
        resultGroup.setText("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 \u043f\u043e\u0438\u0441\u043a\u0430:");
        GridLayoutFactory.swtDefaults().margins(0, 0).applyTo((Composite)resultGroup);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, true).applyTo((Control)resultGroup);
        this.viewPanel = new InventViewPanel((Composite)resultGroup, 0, false, false, false, false);
        ((TableViewer)this.viewPanel.getViewer()).setContentProvider((IContentProvider)new ArrayContentProvider());
        ((TableViewer)this.viewPanel.getViewer()).setLabelProvider((IBaseLabelProvider)new PojoTableLabelProvider(this.viewPanel.getColumns()));
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.viewPanel);
    }

    private void doSearch() {
        this.result.clear();
        if (this.searchTextField.getText() != null && !this.searchTextField.getText().isEmpty()) {
            if (this.barcodeBtn.getSelection() || this.codeBtn.getSelection() || this.nameBtn.getSelection()) {
                List list;
                ArtixFilter filter = new ArtixFilter(Invent.class);
                if (this.barcodeBtn.getSelection()) {
                    ArtixFilter filterBarcodes = new ArtixFilter(Barcodes.class);
                    filterBarcodes.setAdditionalCriteria(new AdditionalCriteria(AdditionalCriteria.Type.EQ, new Object[]{"barcode", this.searchTextField.getText()}));
                    List barcodesList = ModelActivator.getDefault().getModelProvider().getDirectoryModel(Barcodes.class).getList("barcode", true, (Object)filterBarcodes);
                    ArrayList<String> set = new ArrayList<String>();
                    set.add(this.searchTextField.getText());
                    for (Barcodes barcodes : barcodesList) {
                        set.add(barcodes.getCode());
                    }
                    filter.setAdditionalCriteria(new AdditionalCriteria(AdditionalCriteria.Type.IN, new Object[]{"bcode", set.toArray()}));
                    List list2 = ModelActivator.getDefault().getModelProvider().getDirectoryModel(Invent.class).getList("bcode", true, (Object)filter);
                    for (Invent object : list2) {
                        if (this.result.contains(object)) continue;
                        this.result.add(object);
                    }
                }
                if (this.codeBtn.getSelection()) {
                    filter.setAdditionalCriteria(new AdditionalCriteria(AdditionalCriteria.Type.EQ, new Object[]{"code", this.searchTextField.getText()}));
                    list = ModelActivator.getDefault().getModelProvider().getDirectoryModel(Invent.class).getList("code", true, (Object)filter);
                    for (Invent object : list) {
                        if (this.result.contains(object)) continue;
                        this.result.add(object);
                    }
                }
                if (this.nameBtn.getSelection() && this.searchTextField.getText().length() >= 3) {
                    if (this.beginBtn.getSelection()) {
                        filter.setAdditionalCriteria(new AdditionalCriteria(AdditionalCriteria.Type.LIKE_START, new Object[]{"name", this.searchTextField.getText()}));
                    } else if (this.endBtn.getSelection()) {
                        filter.setAdditionalCriteria(new AdditionalCriteria(AdditionalCriteria.Type.LIKE_END, new Object[]{"name", this.searchTextField.getText()}));
                    } else if (this.anywhereBtn.getSelection()) {
                        filter.setAdditionalCriteria(new AdditionalCriteria(AdditionalCriteria.Type.LIKE_ANYWHERE, new Object[]{"name", this.searchTextField.getText()}));
                    } else {
                        filter.setAdditionalCriteria(new AdditionalCriteria(AdditionalCriteria.Type.EQ, new Object[]{"name", this.searchTextField.getText()}));
                    }
                    list = ModelActivator.getDefault().getModelProvider().getDirectoryModel(Invent.class).getList("name", true, (Object)filter);
                    for (Invent object : list) {
                        if (this.result.contains(object)) continue;
                        this.result.add(object);
                    }
                }
                if (this.result.isEmpty()) {
                    MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"\u041f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435", (String)"\u041d\u0438 \u043e\u0434\u043d\u043e\u0439 \u0437\u0430\u043f\u0438\u0441\u0438, \u0443\u0434\u043e\u0432\u043b\u0435\u0442\u0432\u043e\u0440\u044f\u044e\u0449\u0435\u0439 \u0412\u0430\u0448\u0435\u043c\u0443 \u0437\u0430\u043f\u0440\u043e\u0441\u0443, \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e!");
                }
            } else {
                MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"\u041f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435", (String)"\u0427\u0442\u043e\u0431\u044b \u0432\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u043f\u043e\u0438\u0441\u043a \u0442\u043e\u0432\u0430\u0440\u043e\u0432, \u0437\u0430\u0434\u0430\u0439\u0442\u0435 \u043e\u0434\u0438\u043d, \u0438\u043b\u0438 \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u043e \u043a\u0440\u0438\u0442\u0435\u0440\u0438\u0435\u0432 \u043f\u043e\u0438\u0441\u043a\u0430.");
            }
        } else {
            MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"\u041f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435", (String)"\u0427\u0442\u043e\u0431\u044b \u0432\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u043f\u043e\u0438\u0441\u043a \u0442\u043e\u0432\u0430\u0440\u043e\u0432, \u0432\u0432\u0435\u0434\u0438\u0442\u0435 \u043a\u043b\u044e\u0447\u0435\u0432\u043e\u0435 \u0441\u043b\u043e\u0432\u043e \u0432 \u0441\u0442\u0440\u043e\u043a\u0435 \u043f\u043e\u0438\u0441\u043a\u0430.");
        }
        ((TableViewer)this.viewPanel.getViewer()).setInput(this.result);
    }

    private void setDefaultAccordance(boolean accordance) {
        this.beginBtn.setEnabled(accordance);
        this.endBtn.setEnabled(accordance);
        this.anywhereBtn.setEnabled(accordance);
        this.fullBtn.setEnabled(accordance);
        if (accordance) {
            this.beginBtn.setSelection(false);
            this.endBtn.setSelection(false);
            this.anywhereBtn.setSelection(true);
            this.fullBtn.setSelection(false);
        } else {
            this.beginBtn.setSelection(false);
            this.endBtn.setSelection(false);
            this.anywhereBtn.setSelection(false);
            this.fullBtn.setSelection(true);
        }
    }

    public void dispose() {
        ModelActivator.getDefault().getModelProvider().getDirectoryModel(Invent.class).removePropertyChangeListener((PropertyChangeListener)this);
    }

    @Override
    public void propertyChange(final PropertyChangeEvent evt) {
        final String connectionId = ArtixAdminContextHolder.getConnectionId();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ArtixAdminContextHolder.setConnectionId((String)connectionId);
                if (DirectoryAction.UPDATE.toString().equals(evt.getPropertyName())) {
                    if (SearchInventViewPanel.this.result.contains(evt.getNewValue())) {
                        SearchInventViewPanel.this.result.set(SearchInventViewPanel.this.result.indexOf(evt.getNewValue()), (Invent)evt.getNewValue());
                        ((TableViewer)SearchInventViewPanel.this.viewPanel.getViewer()).setInput((Object)SearchInventViewPanel.this.result);
                    } else {
                        SearchInventViewPanel.this.result.clear();
                        SearchInventViewPanel.this.viewPanel.setInput(SearchInventViewPanel.this.result);
                    }
                } else if (DirectoryAction.CHANGE_ID.toString().equals(evt.getNewValue()) || DirectoryAction.REMOVE.toString().equals(evt.getNewValue())) {
                    SearchInventViewPanel.this.result.clear();
                    SearchInventViewPanel.this.viewPanel.setInput(SearchInventViewPanel.this.result);
                }
            }
        });
    }
}

