/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.artixadmin.view.directory.role;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ssa.artixadmin.view.directory.role.RoleCommandViewPanel;
import ru.ssa.artixadmin.view.directory.role.RoleTableView;
import ru.ssa.cashadmin.LibActivator;
import ru.ssa.cashadmin.dao.SessionManager;
import ru.ssa.cashadmin.domain.Command;
import ru.ssa.cashadmin.domain.Role;
import ru.ssa.cashadmin.domain.Rolecommand;
import ru.ssa.cashadmin.domain.utils.RefreshUtil;
import ru.ssa.cashadmin.excep.ExecuteQueryException;
import su.artix.cashserver.security.SecurityKey;
import su.artix.yuki.action.DirectoryEditActionGroup;
import su.artix.yuki.images.ArtixAdminImages;
import su.artix.yuki.model.ModelActivator;
import su.artix.yuki.provider.LazyContentProvider;
import su.artix.yuki.provider.PojoTableLabelProvider;
import su.artix.yuki.view.DirectoryTableView;
import su.artix.yuki.view.DirectoryViewPanel;

@SecurityKey(title="\u0421\u0435\u0440\u0432\u0438\u0441. \u0420\u043e\u043b\u0438. \u041a\u043e\u043c\u0430\u043d\u0434\u044b \u0440\u043e\u043b\u0438")
public class RoleCommandTableView
extends DirectoryTableView<Rolecommand> {
    public static final String ID = "ru.ssa.artixadmin.view.directory.RoleCommandTableView";
    private static final Logger log = LoggerFactory.getLogger(RoleCommandTableView.class);
    @SecurityKey(title="\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043d\u0435 \u0434\u043e\u0441\u0442\u0430\u044e\u0449\u0438\u0435 \u043a\u043e\u043c\u0430\u043d\u0434\u044b")
    private AddNotExistsCommandsAction addNotExistsCommandsAction;

    protected String getID() {
        return ID;
    }

    public void createPartControl(Composite parent) {
        this.setPojoClass(Rolecommand.class);
        this.setViewPanel((DirectoryViewPanel)new RoleCommandViewPanel(parent, 0, false));
        this.getSite().setSelectionProvider((ISelectionProvider)this.getViewer());
        LazyContentProvider lazyContentProvider = new LazyContentProvider(Rolecommand.class, (TableViewer)this.getViewer());
        lazyContentProvider.setSortProperty("id");
        ((TableViewer)this.getViewer()).setContentProvider((IContentProvider)lazyContentProvider);
        ((TableViewer)this.getViewer()).setLabelProvider((IBaseLabelProvider)new PojoTableLabelProvider(this.getColumns()));
        this.addNotExistsCommandsAction = new AddNotExistsCommandsAction();
        ArrayList<AddNotExistsCommandsAction> customActions = new ArrayList<AddNotExistsCommandsAction>();
        customActions.add(this.addNotExistsCommandsAction);
        this.commonActionGroup = new DirectoryEditActionGroup(Rolecommand.class, customActions);
        this.commonActionGroup.fillActionBars(this.getViewSite().getActionBars());
        this.commonActionGroup.getAddAction().setEnabled(false);
        this.addNotExistsCommandsAction.setEnabled(false);
        super.createPartControl(parent);
        this.restoreState();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selectionIn) {
        log.trace("selectionChanged part {} selection {}", (Object)part, (Object)selectionIn);
        IStructuredSelection selection = (IStructuredSelection)selectionIn;
        if (part instanceof RoleTableView) {
            if (selection.size() == 1 && selection.getFirstElement() instanceof Role) {
                Role role = (Role)selection.getFirstElement();
                Rolecommand rolecommand = (Rolecommand)LibActivator.getDefault().getActualClassResolver().getInstance(Rolecommand.class);
                rolecommand.setRole(role);
                this.getViewPanel().setInput((Object)rolecommand);
                this.commonActionGroup.getAddAction().setModel((Object)rolecommand);
                this.commonActionGroup.getAddAction().setEnabled(true);
                this.addNotExistsCommandsAction.setCurrentRole(role);
                this.addNotExistsCommandsAction.setEnabled(true);
            } else {
                this.commonActionGroup.getAddAction().setEnabled(false);
                this.addNotExistsCommandsAction.setEnabled(false);
            }
        }
    }

    protected boolean isMaster() {
        return false;
    }

    private class AddNotExistsCommandsAction
    extends Action {
        private Role currentRole;

        public AddNotExistsCommandsAction() {
            super("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u044e\u0449\u0438\u0435 \u043a\u043e\u043c\u0430\u043d\u0434\u044b");
            this.setImageDescriptor(ArtixAdminImages.getDefault().getImageDescriptor("plane/16x16/command"));
            this.setToolTipText("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u044e\u0449\u0438\u0435 \u043a\u043e\u043c\u0430\u043d\u0434\u044b");
        }

        public void run() {
            try {
                SessionManager.openSession(Role.class);
                this.currentRole = (Role)ModelActivator.getDefault().getModelProvider().getDirectoryModel(Role.class).getById((Object)this.currentRole.getRolecode());
                RefreshUtil.refresh((Object)this.currentRole);
                List currentRolecommands = this.currentRole.getRolecommands();
                ArrayList<Command> currentCommands = new ArrayList<Command>();
                for (Rolecommand rolecommand : currentRolecommands) {
                    currentCommands.add(rolecommand.getCommand());
                }
                SessionManager.closeSession(Role.class);
                List commands = ModelActivator.getDefault().getModelProvider().getDirectoryModel(Command.class).getList();
                for (Command command : commands) {
                    if (currentCommands.contains(command)) continue;
                    Rolecommand rolecommand = (Rolecommand)LibActivator.getDefault().getActualClassResolver().getInstance(Rolecommand.class);
                    rolecommand.setRole(this.currentRole);
                    rolecommand.setCommand(command);
                    rolecommand.setDocumenttype(Integer.valueOf(255));
                    rolecommand.setRule(Boolean.valueOf(true));
                    currentRolecommands.add(rolecommand);
                }
                ModelActivator.getDefault().getModelProvider().getDirectoryModel(Rolecommand.class).saveCollection((Collection)currentRolecommands);
                ModelActivator.getDefault().getModelProvider().getDirectoryModel(Role.class).doUpdate((Object)this.currentRole);
                ModelActivator.getDefault().getModelProvider().getDirectoryModel(Rolecommand.class).doRefresh();
            }
            catch (ExecuteQueryException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }

        public void setCurrentRole(Role currentRole) {
            this.currentRole = currentRole;
        }
    }
}

