/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.artixadmin.view.menutree;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;
import ru.ssa.artixadmin.action.menutree.AddMenuAction;
import ru.ssa.artixadmin.action.menutree.AddMenuActionFromList;
import ru.ssa.artixadmin.action.menutree.AddSubMenuTreeAction;
import ru.ssa.artixadmin.action.menutree.DeleteMenuTreeAction;
import ru.ssa.artixadmin.action.menutree.EditMenuTreeAction;
import ru.ssa.artixadmin.action.menutree.MenuActionGroup;
import ru.ssa.artixadmin.action.menutree.dnd.CopyAction;
import ru.ssa.artixadmin.action.menutree.dnd.MenuTreeDragListener;
import ru.ssa.artixadmin.action.menutree.dnd.MenuTreeDropListener;
import ru.ssa.artixadmin.action.menutree.dnd.MenuTreeTransfer;
import ru.ssa.artixadmin.action.menutree.dnd.PasteAction;
import ru.ssa.artixadmin.provider.menutree.MenuActionContentProvider;
import ru.ssa.artixadmin.provider.menutree.MenuActionLabelProvider;
import ru.ssa.artixadmin.view.menutree.MenuTreeView;
import ru.ssa.cashadmin.domain.advanced.HierarchicalMenuItem;
import su.artix.yuki.images.ArtixAdminImages;
import su.artix.yuki.model.ModelActivator;
import su.artix.yuki.model.menutree.MenuTreeModel;
import su.artix.yuki.view.sort.TableComparator;
import su.artix.yuki.view.sort.TableSorter;

public class MenuActionView
extends ViewPart
implements PropertyChangeListener,
ISelectionListener {
    public static final String ID = "ru.ssa.artixadmin.view.menutree.MenuActionView";
    private MenuTreeModel model;
    private MenuActionGroup menuActionGroup;
    private IAction addSubMenuTreeAction;
    private IAction addMenuAction;
    private IAction addMenuActionFromList;
    private IAction editMenuTreeAction;
    private IAction deleteMenuTreeAction;
    private IAction copyAction;
    private IAction pasteAction;
    private TableViewer tableViewer;
    private TableColumn orderColumn;
    private TableColumn nameColumn;
    private TableColumn commandColumn;
    private TableSorter<HierarchicalMenuItem> tableSorter;
    private final TableComparator<HierarchicalMenuItem> tableComparator = new TableComparator<HierarchicalMenuItem>(){

        public int compare(HierarchicalMenuItem o1, HierarchicalMenuItem o2) {
            if (this.getCurrentTableColumn().equals(MenuActionView.this.orderColumn)) {
                Integer value1 = o1.getOrder();
                Integer value2 = o2.getOrder();
                return super.intCompare(value1, value2);
            }
            if (this.getCurrentTableColumn().equals(MenuActionView.this.nameColumn)) {
                String str1 = o1.getName();
                String str2 = o2.getName();
                return super.stringCompare(str1, str2);
            }
            if (this.getCurrentTableColumn().equals(MenuActionView.this.commandColumn)) {
                String str1 = o1.getCmaction().getCommand().getCommandname();
                String str2 = o2.getCmaction().getCommand().getCommandname();
                return super.stringCompare(str1, str2);
            }
            return 0;
        }
    };
    private final SelectionAdapter sortSelectionAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            MenuActionView.this.tableSorter.setSortTableColumn((TableColumn)e.getSource());
            MenuActionView.this.tableViewer.refresh();
        }
    };
    private TableColumn imageTableColumn;
    private TableViewerColumn imageTableViewerColumn;

    private void enabledPopupMenu(boolean value) {
        this.addSubMenuTreeAction.setEnabled(value);
        this.addMenuAction.setEnabled(value);
        this.addMenuActionFromList.setEnabled(value);
        this.editMenuTreeAction.setEnabled(value);
        this.deleteMenuTreeAction.setEnabled(value);
        this.copyAction.setEnabled(value);
        this.pasteAction.setEnabled(value);
    }

    public void createPartControl(Composite parent) {
        this.getSite().getPage().addSelectionListener((ISelectionListener)this);
        this.model = ModelActivator.getDefault().getModelProvider().getHierarchicalMenuItemModel();
        this.model.setDefaultModel((HierarchicalMenuItem)this.model.getHierarchicalMenu().getRoots().get(0));
        this.model.addPropertyChangeListener((PropertyChangeListener)this);
        this.tableViewer = new TableViewer(parent, 67584);
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                MenuActionView.this.editMenuTreeAction.run();
            }
        });
        this.getSite().setSelectionProvider((ISelectionProvider)this.tableViewer);
        this.tableViewer.getTable().setLinesVisible(true);
        this.tableViewer.getTable().setHeaderVisible(true);
        this.imageTableViewerColumn = new TableViewerColumn(this.tableViewer, 0);
        this.imageTableColumn = this.imageTableViewerColumn.getColumn();
        this.imageTableColumn.setWidth(40);
        TableViewerColumn orderViewerColumn = new TableViewerColumn(this.tableViewer, 0);
        this.orderColumn = orderViewerColumn.getColumn();
        this.orderColumn.setAlignment(0x1000000);
        this.orderColumn.addSelectionListener((SelectionListener)this.sortSelectionAdapter);
        this.orderColumn.setWidth(60);
        this.orderColumn.setText("\u041f\u043e\u0440\u044f\u0434\u043e\u043a");
        TableViewerColumn nameViewerColumn = new TableViewerColumn(this.tableViewer, 0);
        this.nameColumn = nameViewerColumn.getColumn();
        this.nameColumn.addSelectionListener((SelectionListener)this.sortSelectionAdapter);
        this.nameColumn.setWidth(200);
        this.nameColumn.setText("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435");
        TableViewerColumn commandViewerColumn = new TableViewerColumn(this.tableViewer, 0);
        this.commandColumn = commandViewerColumn.getColumn();
        this.commandColumn.addSelectionListener((SelectionListener)this.sortSelectionAdapter);
        this.commandColumn.setWidth(300);
        this.commandColumn.setText("\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435");
        this.menuActionGroup = new MenuActionGroup();
        this.menuActionGroup.fillActionBars(this.getViewSite().getActionBars());
        this.tableSorter = new TableSorter(this.tableComparator, this.orderColumn, null);
        this.tableViewer.setSorter(this.tableSorter);
        this.addSubMenuTreeAction = new AddSubMenuTreeAction(ArtixAdminImages.getDefault().getImageDescriptor("plane/16x16/child_add"));
        this.addMenuAction = new AddMenuAction(ArtixAdminImages.getDefault().getImageDescriptor("plane/16x16/action_add"));
        this.addMenuActionFromList = new AddMenuActionFromList(ArtixAdminImages.getDefault().getImageDescriptor("plane/16x16/action_add"));
        this.editMenuTreeAction = new EditMenuTreeAction(ArtixAdminImages.getDefault().getImageDescriptor("plane/16x16/edit"));
        this.deleteMenuTreeAction = new DeleteMenuTreeAction(ArtixAdminImages.getDefault().getImageDescriptor("plane/16x16/delete"));
        this.copyAction = new CopyAction(ArtixAdminImages.getDefault().getImageDescriptor("copy"));
        this.pasteAction = new PasteAction(ArtixAdminImages.getDefault().getImageDescriptor("paste"));
        MenuManager popupMenu = new MenuManager();
        Menu menu = popupMenu.createContextMenu((Control)this.tableViewer.getTable());
        popupMenu.add(this.addSubMenuTreeAction);
        popupMenu.add(this.addMenuAction);
        popupMenu.add(this.addMenuActionFromList);
        popupMenu.add((IContributionItem)new Separator());
        popupMenu.add(this.editMenuTreeAction);
        popupMenu.add(this.deleteMenuTreeAction);
        popupMenu.add((IContributionItem)new Separator());
        popupMenu.add(this.copyAction);
        popupMenu.add(this.pasteAction);
        this.tableViewer.getTable().setMenu(menu);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new MenuActionLabelProvider());
        this.tableViewer.setContentProvider((IContentProvider)new MenuActionContentProvider());
        this.tableViewer.setInput(null);
        int operations = 3;
        Transfer[] transferTypes = new Transfer[]{MenuTreeTransfer.getInstance()};
        this.tableViewer.addDragSupport(operations, transferTypes, (DragSourceListener)new MenuTreeDragListener((Viewer)this.tableViewer));
        this.tableViewer.addDropSupport(operations, transferTypes, (DropTargetListener)new MenuTreeDropListener((Viewer)this.tableViewer));
    }

    public void dispose() {
        this.getSite().getPage().removeSelectionListener((ISelectionListener)this);
        this.model.removePropertyChangeListener((PropertyChangeListener)this);
    }

    public void setFocus() {
        this.tableViewer.getControl().setFocus();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.tableViewer.refresh();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        IStructuredSelection selectionIn = (IStructuredSelection)selection;
        if (part instanceof MenuActionView) {
            if (selectionIn.getFirstElement() instanceof HierarchicalMenuItem) {
                Clipboard clipboard;
                HierarchicalMenuItem menuItem;
                this.model.setCurrentModel((HierarchicalMenuItem)selectionIn.getFirstElement());
                this.menuActionGroup.setEnabledAll();
                this.enabledPopupMenu(true);
                if (((HierarchicalMenuItem)selectionIn.getFirstElement()).getMenu() == null) {
                    this.addSubMenuTreeAction.setEnabled(false);
                    this.addMenuAction.setEnabled(false);
                    this.addMenuActionFromList.setEnabled(false);
                }
                if ((menuItem = (HierarchicalMenuItem)(clipboard = new Clipboard(Display.getCurrent())).getContents((Transfer)MenuTreeTransfer.getInstance())) != null && !menuItem.getName().equals(this.model.getCurrentModel().getName()) && !menuItem.getCmaction().getCmactioncode().equals(this.model.getCurrentModel().getCmaction().getCmactioncode())) {
                    this.pasteAction.setEnabled(true);
                } else {
                    this.pasteAction.setEnabled(false);
                }
            } else {
                this.menuActionGroup.setDisabledAll();
                this.enabledPopupMenu(false);
                this.addSubMenuTreeAction.setEnabled(true);
                this.addMenuAction.setEnabled(true);
                this.addMenuActionFromList.setEnabled(true);
            }
        }
        if (part instanceof MenuTreeView && selectionIn.getFirstElement() instanceof HierarchicalMenuItem) {
            this.tableViewer.getTable().deselectAll();
            this.tableViewer.refresh();
            this.menuActionGroup.setDisabledAll();
        }
    }
}

