/*
 * Decompiled with CFR 0.152.
 */
package su.artix.discountmanager.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import su.artix.artixadmin.connection.ArtixAdminContextHolder;
import su.artix.discountmanager.Activator;
import su.artix.discountmanager.holders.ViewHolder;
import su.artix.discountmanager.providers.discountsystem.DiscountSystemContentProvider;
import su.artix.discountmanager.trees.CustomSystemTreeViewer;
import su.artix.discountmanager.views.DiscountSystemView;
import su.artix.discountmanager.views.TreeUtils;
import su.artix.discountmanagercore.dao.discountsystem.DiscountSystemDAO;

public class RefreshDiscountSystemHandler
extends AbstractHandler {
    public static final String ID = "su.artix.discountmanager.commands.discountsystem.refresh";
    private static final Logger log = LoggerFactory.getLogger(RefreshDiscountSystemHandler.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        log.debug("Discount System view reloading");
        CustomSystemTreeViewer systemTree = null;
        systemTree = (CustomSystemTreeViewer)ViewHolder.INSTANCE.getViewPart("su.artix.discountmanager.views.discountsystemview").getSite().getSelectionProvider();
        ((DiscountSystemContentProvider)systemTree.getContentProvider()).getMap().remove(ArtixAdminContextHolder.getConnectionId());
        DiscountSystemView dsView = (DiscountSystemView)ViewHolder.INSTANCE.getViewPart("su.artix.discountmanager.views.discountsystemview");
        dsView.setIsChangedView(false);
        DiscountSystemContentProvider contentProvider = (DiscountSystemContentProvider)systemTree.getContentProvider();
        contentProvider.refresh(Activator.getDefault().getBeanByClass(DiscountSystemDAO.class), true);
        systemTree.refresh();
        TreeUtils.expandTreeToGroups(systemTree);
        return null;
    }
}

