/*
 * Decompiled with CFR 0.152.
 */
package su.artix.discountmanager.providers.discountsystem;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.remoting.RemoteAccessException;
import ru.ssa.cashadmin.LibActivator;
import ru.ssa.cashadmin.domain.ShopGroupLabelV63;
import ru.ssa.cashadmin.domain.ShopLabelV63;
import su.artix.artixadmin.connection.ArtixAdminContextHolder;
import su.artix.cashserver.core.cashregistry.domain.ShopGroupLabel;
import su.artix.cashserver.core.cashregistry.domain.ShopLabel;
import su.artix.yuki.model.ModelActivator;
import su.artix.yuki.model.directory.DirectoryEditModel;

public class CachedTags {
    private static final Logger log = LoggerFactory.getLogger(CachedTags.class);
    private static long tagsCount = -1L;
    private static List<ShopLabel> allTags = new ArrayList<ShopLabel>();

    private CachedTags() {
    }

    private static long getTagsCount() {
        long tagsCount = -1L;
        if (ArtixAdminContextHolder.isCashserver()) {
            DirectoryEditModel model = ModelActivator.getDefault().getModelProvider().getDirectoryModel(ShopLabel.class);
            tagsCount = model.getItemCount(null);
        } else if (ShopLabelV63.class.isAssignableFrom(LibActivator.getDefault().getActualClassResolver().getActual(ru.ssa.cashadmin.domain.ShopLabel.class))) {
            DirectoryEditModel model = ModelActivator.getDefault().getModelProvider().getDirectoryModel(ru.ssa.cashadmin.domain.ShopLabel.class);
            tagsCount = model.getItemCount(null);
        }
        return tagsCount;
    }

    public static void init() {
        tagsCount = CachedTags.getTagsCount();
        if (ArtixAdminContextHolder.isCashserver()) {
            try {
                DirectoryEditModel model = ModelActivator.getDefault().getModelProvider().getDirectoryModel(ShopLabel.class);
                allTags = model.getList();
            }
            catch (RemoteAccessException e) {
                log.debug(e.getMessage());
            }
        } else {
            allTags = new ArrayList<ShopLabel>();
            if (ShopLabelV63.class.isAssignableFrom(LibActivator.getDefault().getActualClassResolver().getActual(ru.ssa.cashadmin.domain.ShopLabel.class))) {
                DirectoryEditModel model = ModelActivator.getDefault().getModelProvider().getDirectoryModel(ru.ssa.cashadmin.domain.ShopLabel.class);
                List cashTags = model.getList();
                for (ru.ssa.cashadmin.domain.ShopLabel cashTag : cashTags) {
                    ShopLabel tag = new ShopLabel();
                    ShopLabelV63 cashTagV63 = (ShopLabelV63)cashTag;
                    tag.setCode(cashTagV63.getId());
                    tag.setName(cashTagV63.getName());
                    if (cashTagV63.getTagType() != null) {
                        ShopGroupLabelV63 type = new ShopGroupLabelV63();
                        type.setType(((ShopGroupLabelV63)cashTagV63.getTagType()).getType());
                        ShopGroupLabel groupLabel = new ShopGroupLabel();
                        groupLabel.setName(((ShopGroupLabelV63)cashTagV63.getTagType()).getType());
                        tag.setShopGroupLabel(groupLabel);
                    }
                    allTags.add(tag);
                }
            }
        }
    }

    public static List<ShopLabel> getAllTags() {
        long updatedTagsCount = CachedTags.getTagsCount();
        if (updatedTagsCount != tagsCount) {
            log.trace("New tags count: {}, current: {} - update list", (Object)updatedTagsCount, (Object)tagsCount);
            CachedTags.init();
            tagsCount = updatedTagsCount;
        }
        return allTags;
    }
}

