/*
 * Decompiled with CFR 0.152.
 */
package su.artix.discountmanager.providers.discountsystem;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.BooleanUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import su.artix.artixadmin.connection.ArtixAdminContextHolder;
import su.artix.discountmanager.Activator;
import su.artix.discountmanager.controls.actions.ChangeOwnerDbAction;
import su.artix.discountmanager.trees.CustomSystemTreeViewer;
import su.artix.discountmanager.utils.QuestionMessageFactory;
import su.artix.discountmanagercore.dao.discountsystem.DiscountSystemDAO;
import su.artix.loyaltylib.convertor.discountsystem.DiscountSystem2Yaml;
import su.artix.loyaltylib.domain.java.discountsystem.Counter;
import su.artix.loyaltylib.domain.java.discountsystem.Coupon;
import su.artix.loyaltylib.domain.java.discountsystem.Discount;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountCampaign;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountCampaignGroup;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountCondition;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountObject;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountRate;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountSystem;
import su.artix.loyaltylib.domain.java.discountsystem.Gift;
import su.artix.loyaltylib.domain.java.discountsystem.LegacyObject;
import su.artix.loyaltylib.domain.java.discountsystem.Report;
import su.artix.loyaltylib.domain.java.discountsystem.SimpleObject;
import su.artix.loyaltylib.domain.java.observable.AbstractDiscountModel;
import su.artix.yuki.directory.Directory;

public class DiscountSystemContentProvider
implements ITreeContentProvider {
    private static final Logger log = LoggerFactory.getLogger(DiscountSystemContentProvider.class);
    private DiscountSystemDAO.SystemType systemType;
    private DiscountSystemDAO dao;
    private CustomSystemTreeViewer systemTreeViewer;
    private String currentId;
    private boolean localDBEdit;
    private Map<String, DiscountSystem> map;
    private final Object[] EMPTY_ARRAY = new Object[0];
    private boolean firstInterpreterInit = true;

    public void saveSystem() {
        Activator.getDefault().setLoadCursor(true);
        DiscountSystem unknownSystem = this.getMap().get(this.currentId);
        switch (this.getSystemType()) {
            case DISCOUNT_SYSTEM: {
                this.dao.saveDiscountSystem(unknownSystem, this.localDBEdit);
                break;
            }
            case LIMIT_BONUS_SYSTEM: {
                this.dao.saveLimitBonusSystem(unknownSystem, this.localDBEdit);
                break;
            }
            case EARN_BONUS_SYSTEM: {
                this.dao.saveEarnBonusSystem(unknownSystem, this.localDBEdit);
                break;
            }
            case PERIODIC_IMPACTS_BONUS_SYSTEM: {
                this.dao.savePeriodicImpactsBonusSystem(unknownSystem, this.localDBEdit);
                break;
            }
            case SECOND_SYSTEM: {
                this.dao.saveSecondSystem(unknownSystem, this.localDBEdit);
            }
        }
        this.getSystemTreeViewer().setInitHistoryItem(DiscountSystem2Yaml.getDiscountSystemYaml((DiscountSystem)unknownSystem));
        unknownSystem.setChanged(Boolean.valueOf(false));
        Activator.getDefault().setLoadCursor(false);
    }

    public DiscountSystemContentProvider(DiscountSystemDAO.SystemType systemType) {
        this.setSystemType(systemType);
        this.setMap(new HashMap<String, DiscountSystem>());
    }

    public void dispose() {
    }

    public void saveDiscountSystemWithoutDialog() {
        if (this.getSystemTreeViewer().isChanged().booleanValue()) {
            this.saveSystem();
            this.getSystemTreeViewer().setIsChanged(false);
        }
    }

    public void clearCurrentDiscountSystem() {
        Activator.getDefault().setLoadCursor(true);
        DiscountSystem discountSystem = this.getMap().get(this.currentId);
        discountSystem.deleteGroup();
        Activator.getDefault().setLoadCursor(false);
    }

    public boolean saveDiscountSystem() {
        if (this.getSystemTreeViewer().isChanged().booleanValue()) {
            boolean result = false;
            switch (this.getSystemType()) {
                case DISCOUNT_SYSTEM: {
                    result = QuestionMessageFactory.saveSystemQuestionMessage("\u0434\u0438\u0441\u043a\u043e\u043d\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u044b");
                    break;
                }
                case EARN_BONUS_SYSTEM: {
                    result = QuestionMessageFactory.saveSystemQuestionMessage("\u0431\u043e\u043d\u0443\u0441\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u044b");
                    break;
                }
                case LIMIT_BONUS_SYSTEM: {
                    result = QuestionMessageFactory.saveSystemQuestionMessage("\u0441\u0438\u0441\u0442\u0435\u043c\u044b \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0439");
                    break;
                }
                case SECOND_SYSTEM: {
                    result = QuestionMessageFactory.saveSystemQuestionMessage("\u0434\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0434\u0438\u0441\u043a\u043e\u043d\u0442\u043d\u0430\u044f \u0441\u0438\u0441\u0442\u0435\u043c\u0430");
                }
            }
            if (result) {
                this.getSystemTreeViewer().setIsChanged(false);
                this.saveSystem();
                return true;
            }
            this.getSystemTreeViewer().setIsChanged(false);
            return false;
        }
        return true;
    }

    public void refresh(boolean saveRefreshInHistory) {
        this.refresh(this.dao, saveRefreshInHistory);
    }

    public void refresh(DiscountSystemDAO dao, boolean saveRefreshInHistory) {
        try {
            log.debug("reload ds content provider");
            this.currentId = ArtixAdminContextHolder.getConnectionId();
            this.dao = dao;
            if (!this.getMap().containsKey(this.currentId)) {
                DiscountSystem system;
                this.systemTreeViewer.getTree().setVisible(false);
                if (this.firstInterpreterInit) {
                    ProgressMonitorDialog dialog = new ProgressMonitorDialog(Display.getDefault().getActiveShell());
                    DiscountSystemLoading gbr = new DiscountSystemLoading(this.dao, ArtixAdminContextHolder.getConnectionId());
                    dialog.run(true, false, (IRunnableWithProgress)gbr);
                    this.firstInterpreterInit = false;
                    system = gbr.getSystem();
                } else {
                    system = this.loadSystem(this.dao, saveRefreshInHistory);
                }
                this.addListenerTo((AbstractDiscountModel)system);
                this.getMap().put(this.currentId, system);
                this.systemTreeViewer.getTree().setVisible(true);
                this.setLocalDBEdit(this.dao.isLocalEdit());
                ChangeOwnerDbAction.getInstance().setChecked(this.isLocalDBEdit());
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.setSystemTreeViewer((CustomSystemTreeViewer)viewer);
        try {
            if (newInput instanceof DiscountSystemDAO) {
                this.refresh((DiscountSystemDAO)newInput, true);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public Object[] getElements(Object inputElement) {
        try {
            if (this.dao != null) {
                DiscountSystem ds = this.getMap().get(this.currentId);
                return new Object[]{ds};
            }
            return this.EMPTY_ARRAY;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return this.EMPTY_ARRAY;
        }
    }

    public void addListenerTo(AbstractDiscountModel model) {
        ArrayList<CustomSystemTreeViewer> listeners = new ArrayList<CustomSystemTreeViewer>();
        listeners.add(this.getSystemTreeViewer());
        if (model instanceof DiscountSystem) {
            DiscountSystem system = (DiscountSystem)model;
            system.addPropertyChangeListener(listeners);
            if (system.getCampaignGroup() != null) {
                this.addListenerTo((AbstractDiscountModel)system.getCampaignGroup());
            }
        } else if (model instanceof DiscountCampaignGroup) {
            DiscountCampaignGroup group = (DiscountCampaignGroup)model;
            group.addPropertyChangeListener(listeners);
            for (DiscountCampaign s : group.getDiscountCampaigns()) {
                this.addListenerTo((AbstractDiscountModel)s);
            }
            for (DiscountCampaign s : group.getSubGroups()) {
                this.addListenerTo((AbstractDiscountModel)s);
            }
        } else if (model instanceof DiscountCampaign) {
            DiscountCampaign campaign = (DiscountCampaign)model;
            campaign.addPropertyChangeListener(listeners);
            for (Discount s : campaign.getDiscounts()) {
                this.addListenerTo((AbstractDiscountModel)s);
            }
        } else if (model instanceof Discount) {
            Discount discount = (Discount)model;
            discount.addPropertyChangeListener(listeners);
            for (DiscountCondition s : discount.getDiscountConditions()) {
                this.addListenerTo((AbstractDiscountModel)s);
            }
            if (((Discount)model).getDiscountObject() != null) {
                this.addListenerTo((AbstractDiscountModel)((Discount)model).getDiscountObject());
            }
            if (((Discount)model).getDiscountRate() != null) {
                this.addListenerTo((AbstractDiscountModel)((Discount)model).getDiscountRate());
            }
            for (DiscountCondition s : discount.getCounters()) {
                this.addListenerTo((AbstractDiscountModel)s);
            }
            for (DiscountCondition s : discount.getGifts()) {
                this.addListenerTo((AbstractDiscountModel)s);
            }
            for (DiscountCondition s : discount.getReports()) {
                this.addListenerTo((AbstractDiscountModel)s);
            }
        } else if (model instanceof DiscountRate) {
            DiscountRate discount = (DiscountRate)model;
            discount.addPropertyChangeListener(listeners);
        } else if (model instanceof DiscountCondition) {
            DiscountCondition discount = (DiscountCondition)model;
            discount.addPropertyChangeListener(listeners);
        } else if (model instanceof DiscountObject) {
            DiscountObject discount = (DiscountObject)model;
            discount.addPropertyChangeListener(listeners);
        } else if (model instanceof Counter) {
            Counter counter = (Counter)model;
            counter.addPropertyChangeListener(listeners);
        } else if (model instanceof Gift) {
            Gift gift = (Gift)model;
            gift.addPropertyChangeListener(listeners);
        } else if (model instanceof Report) {
            Report report = (Report)model;
            report.addPropertyChangeListener(listeners);
        }
    }

    public void removeListenerFrom(AbstractDiscountModel model) {
        if (model instanceof DiscountSystem) {
            DiscountSystem system = (DiscountSystem)model;
            system.removePropertyChangeListeners();
            if (system.getCampaignGroup() != null) {
                this.removeListenerFrom((AbstractDiscountModel)system.getCampaignGroup());
            }
        } else if (model instanceof DiscountCampaignGroup) {
            DiscountCampaignGroup group = (DiscountCampaignGroup)model;
            group.removePropertyChangeListeners();
            for (DiscountCampaign s : group.getDiscountCampaigns()) {
                this.removeListenerFrom((AbstractDiscountModel)s);
            }
            for (DiscountCampaign s : group.getSubGroups()) {
                this.removeListenerFrom((AbstractDiscountModel)s);
            }
        } else if (model instanceof DiscountCampaign) {
            DiscountCampaign campaign = (DiscountCampaign)model;
            campaign.removePropertyChangeListeners();
            for (Discount s : campaign.getDiscounts()) {
                this.removeListenerFrom((AbstractDiscountModel)s);
            }
        } else if (model instanceof Discount) {
            Discount discount = (Discount)model;
            discount.removePropertyChangeListener((PropertyChangeListener)this.getSystemTreeViewer());
            for (DiscountCondition s : discount.getDiscountConditions()) {
                this.removeListenerFrom((AbstractDiscountModel)s);
            }
            if (((Discount)model).getDiscountObject() != null) {
                this.removeListenerFrom((AbstractDiscountModel)((Discount)model).getDiscountObject());
            }
            if (((Discount)model).getDiscountRate() != null) {
                this.removeListenerFrom((AbstractDiscountModel)((Discount)model).getDiscountRate());
            }
            for (DiscountCondition s : discount.getCounters()) {
                this.removeListenerFrom((AbstractDiscountModel)s);
            }
            for (DiscountCondition s : discount.getGifts()) {
                this.removeListenerFrom((AbstractDiscountModel)s);
            }
            for (DiscountCondition s : discount.getReports()) {
                this.removeListenerFrom((AbstractDiscountModel)s);
            }
        } else if (model instanceof DiscountRate) {
            DiscountRate discount = (DiscountRate)model;
            discount.removePropertyChangeListeners();
        } else if (model instanceof DiscountCondition) {
            DiscountCondition discount = (DiscountCondition)model;
            discount.removePropertyChangeListeners();
        } else if (model instanceof DiscountObject) {
            DiscountObject discount = (DiscountObject)model;
            discount.removePropertyChangeListeners();
        } else if (model instanceof Counter) {
            Counter counter = (Counter)model;
            counter.removePropertyChangeListeners();
        } else if (model instanceof Gift) {
            Gift gift = (Gift)model;
            gift.removePropertyChangeListeners();
        } else if (model instanceof Report) {
            Report report = (Report)model;
            report.removePropertyChangeListeners();
        }
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof DiscountSystem) {
            if (((DiscountSystem)parentElement).getCampaignGroup() != null) {
                if (!this.getSystemTreeViewer().isChanged().booleanValue()) {
                    ((DiscountSystem)parentElement).getCampaignGroup().setChanged(Boolean.valueOf(false));
                }
                return new Object[]{((DiscountSystem)parentElement).getCampaignGroup()};
            }
            return this.EMPTY_ARRAY;
        }
        if (parentElement instanceof DiscountCampaignGroup) {
            DiscountCampaignGroup dcg = (DiscountCampaignGroup)parentElement;
            ArrayList childs = new ArrayList();
            if (!this.getSystemTreeViewer().isChanged().booleanValue()) {
                for (DiscountCampaign dc : dcg.getDiscountCampaigns()) {
                    dc.setChanged(Boolean.valueOf(false));
                }
                for (DiscountCampaignGroup group : dcg.getSubGroups()) {
                    group.setChanged(Boolean.valueOf(false));
                }
            }
            childs.addAll(dcg.getDiscountCampaigns());
            childs.addAll(dcg.getSubGroups());
            return childs.toArray();
        }
        if (parentElement instanceof DiscountCampaign) {
            DiscountCampaign dc = (DiscountCampaign)parentElement;
            ArrayList childs = new ArrayList();
            if (!this.getSystemTreeViewer().isChanged().booleanValue()) {
                for (Discount d : dc.getDiscounts()) {
                    d.setChanged(Boolean.valueOf(false));
                }
            }
            childs.addAll(dc.getDiscounts());
            return childs.toArray();
        }
        if (parentElement instanceof Discount) {
            Discount discount = (Discount)parentElement;
            ArrayList<Object> childs = new ArrayList<Object>();
            if (!this.getSystemTreeViewer().isChanged().booleanValue()) {
                discount.getDiscountObject().setChanged(Boolean.valueOf(false));
                discount.getDiscountRate().setChanged(Boolean.valueOf(false));
                for (DiscountCondition dc : discount.getDiscountConditions()) {
                    dc.setChanged(Boolean.valueOf(false));
                }
                for (Counter counter : discount.getCounters()) {
                    counter.setChanged(Boolean.valueOf(false));
                }
                for (Coupon coupon : discount.getCoupons()) {
                    coupon.setChanged(Boolean.valueOf(false));
                }
                for (Gift gift : discount.getGifts()) {
                    gift.setChanged(Boolean.valueOf(false));
                }
                for (Report report : discount.getReports()) {
                    report.setChanged(Boolean.valueOf(false));
                }
            }
            childs.add(discount.getDiscountObject());
            childs.addAll(discount.getDiscountConditions());
            if (!(discount.getDiscountObject() instanceof LegacyObject) && !(discount.getDiscountObject() instanceof SimpleObject)) {
                childs.add(discount.getDiscountRate());
            }
            childs.addAll(discount.getCounters());
            childs.addAll(discount.getCoupons());
            childs.addAll(discount.getGifts());
            childs.addAll(discount.getReports());
            return childs.toArray();
        }
        if (parentElement instanceof Counter) {
            ArrayList<String> childs = new ArrayList<String>();
            Counter counter = (Counter)parentElement;
            childs.add("ID: " + counter.getCounterId());
            childs.add("\u0421\u0442\u0430\u0432\u043a\u0430: " + counter.getRate().getNameTreeNode());
            childs.add("\u0421\u0447\u0438\u0442\u0430\u0442\u044c \u0434\u043b\u044f \u043a\u0430\u0436\u0434\u043e\u0439 \u043f\u043e\u0437\u0438\u0446\u0438\u0438: " + (BooleanUtils.isTrue((Boolean)counter.getPosition()) ? "\u0434\u0430" : "\u043d\u0435\u0442"));
            return childs.toArray();
        }
        if (parentElement instanceof Coupon) {
            ArrayList<String> childs = new ArrayList<String>();
            Coupon coupon = (Coupon)parentElement;
            childs.add("\u041d\u043e\u043c\u0435\u0440: " + coupon.getNumber());
            return childs.toArray();
        }
        if (parentElement instanceof Gift) {
            ArrayList<String> childs = new ArrayList<String>();
            Gift gift = (Gift)parentElement;
            childs.add("\u041f\u0440\u0438 \u043f\u043e\u043a\u0443\u043f\u043a\u0435 \u0438\u0437 \u043a\u0430\u0442\u0430\u043b\u043e\u0433\u0430: " + gift.getCatalogCode());
            childs.add("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043f\u043e\u0434\u0430\u0440\u043a\u043e\u0432 \u043e\u0442: " + (gift.getMinCount() == null ? 0 : gift.getMinCount()));
            childs.add("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043f\u043e\u0434\u0430\u0440\u043a\u043e\u0432 \u0434\u043e: " + gift.getCount());
            childs.add("\u041a\u0430\u0441\u0441\u0438\u0440 \u043c\u043e\u0436\u0435\u0442 \u043e\u0442\u043a\u0430\u0437\u0430\u0442\u044c\u0441\u044f \u043e\u0442 \u0432\u044b\u0434\u0430\u0447\u0438: " + (BooleanUtils.isTrue((Boolean)gift.getCanCancel()) ? "\u0434\u0430" : "\u043d\u0435\u0442"));
            childs.add("\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u0442\u044c \u043f\u043e\u0434\u0430\u0440\u043a\u0438 \u043a\u0430\u043a \u0442\u043e\u0432\u0430\u0440: " + (BooleanUtils.isTrue((Boolean)gift.getAsGoods()) ? "\u0434\u0430" : "\u043d\u0435\u0442"));
            return childs.toArray();
        }
        if (parentElement instanceof Report) {
            ArrayList<String> childs = new ArrayList<String>();
            Report report = (Report)parentElement;
            childs.add("\u0422\u0438\u043f \u043e\u0442\u0447\u0435\u0442\u0430: " + Directory.discountXmlType.getDisplayValue((Object)(report.getType() == null ? "xml" : report.getType())));
            if ("name".equals(report.getType())) {
                childs.add("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043e\u0442\u0447\u0435\u0442\u0430: " + report.getValue());
            }
            return childs.toArray();
        }
        return this.EMPTY_ARRAY;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof DiscountSystem) {
            return ((DiscountSystem)element).getCampaignGroup() != null;
        }
        if (element instanceof DiscountCampaignGroup) {
            DiscountCampaignGroup dcg = (DiscountCampaignGroup)element;
            return !dcg.getSubGroups().isEmpty() || !dcg.getDiscountCampaigns().isEmpty();
        }
        if (element instanceof DiscountCampaign) {
            return !((DiscountCampaign)element).getDiscounts().isEmpty();
        }
        if (element instanceof Discount) {
            Discount d = (Discount)element;
            return d.getDiscountObject() != null || !d.getDiscountConditions().isEmpty() || d.getDiscountRate() != null;
        }
        if (element instanceof DiscountObject) {
            return false;
        }
        if (element instanceof DiscountCondition) {
            return false;
        }
        if (element instanceof DiscountRate) {
            return false;
        }
        if (element instanceof Counter) {
            return true;
        }
        if (element instanceof Coupon) {
            return true;
        }
        if (element instanceof Gift) {
            return true;
        }
        return element instanceof Report;
    }

    public void setSystemTreeViewer(CustomSystemTreeViewer treeViewer) {
        this.systemTreeViewer = treeViewer;
    }

    public CustomSystemTreeViewer getSystemTreeViewer() {
        return this.systemTreeViewer;
    }

    public void setMap(Map<String, DiscountSystem> map) {
        this.map = map;
    }

    public Map<String, DiscountSystem> getMap() {
        return this.map;
    }

    public void setSystemType(DiscountSystemDAO.SystemType systemType) {
        this.systemType = systemType;
    }

    public DiscountSystemDAO.SystemType getSystemType() {
        return this.systemType;
    }

    public boolean isLocalDBEdit() {
        return this.localDBEdit;
    }

    public void setLocalDBEdit(boolean localDBEdit) {
        this.localDBEdit = localDBEdit;
    }

    public void changeLocalDbEditValue() {
        this.setLocalDBEdit(!this.isLocalDBEdit());
        this.dao.saveLocalEditValue(this.localDBEdit);
    }

    public DiscountSystem getCurrentSystem() {
        return this.getMap().get(this.currentId);
    }

    private DiscountSystem loadSystem(DiscountSystemDAO dao, boolean saveRefreshInHistory) {
        DiscountSystem system = new DiscountSystem();
        try {
            this.waitPythonInterpreter();
            system = dao.getDiscountSystem(this.getSystemType());
            if (saveRefreshInHistory) {
                this.getSystemTreeViewer().addHistoryItemValue(DiscountSystem2Yaml.getDiscountSystemYaml((DiscountSystem)system));
            }
            log.trace("System loaded: " + system.toString());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        log.debug("System loaded for " + this.currentId);
        return system;
    }

    private void waitPythonInterpreter() throws InterruptedException {
        int i = 0;
        while (i < 10) {
            Job job = Activator.getDefault().getPythonInterpreterInitJob();
            if (job != null && job.getState() == 0) break;
            Thread.sleep(1000L);
            log.trace("waiting python...");
            ++i;
        }
    }

    class DiscountSystemLoading
    implements IRunnableWithProgress {
        DiscountSystem system;
        private DiscountSystemDAO dao;
        private String connectionId;

        public DiscountSystemLoading(DiscountSystemDAO dao, String currentConnectionId) {
            this.dao = dao;
            this.connectionId = currentConnectionId;
        }

        public DiscountSystem getSystem() {
            return this.system;
        }

        public void run(IProgressMonitor monitor) {
            String loadingString;
            ArtixAdminContextHolder.setConnectionId((String)this.connectionId);
            switch (DiscountSystemContentProvider.this.getSystemType()) {
                case DISCOUNT_SYSTEM: {
                    loadingString = "\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u0434\u0438\u0441\u043a\u043e\u043d\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u044b ...";
                    break;
                }
                case EARN_BONUS_SYSTEM: {
                    loadingString = "\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u0431\u043e\u043d\u0443\u0441\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u044b ...";
                    break;
                }
                case LIMIT_BONUS_SYSTEM: {
                    loadingString = "\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u0441\u0438\u0441\u0442\u0435\u043c\u044b \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0439 ...";
                    break;
                }
                case PERIODIC_IMPACTS_BONUS_SYSTEM: {
                    loadingString = "\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u0441\u0438\u0441\u0442\u0435\u043c\u044b \u043f\u0435\u0440\u0438\u043e\u0434\u0438\u0447\u0435\u0441\u043a\u0438\u0445 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u0439...";
                    break;
                }
                case SECOND_SYSTEM: {
                    loadingString = "\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u0434\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0439 \u0434\u0438\u0441\u043a\u043e\u043d\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u044b...";
                    break;
                }
                default: {
                    loadingString = "\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u0434\u0438\u0441\u043a\u043e\u043d\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u044b ...";
                }
            }
            monitor.beginTask(loadingString, -1);
            this.system = DiscountSystemContentProvider.this.loadSystem(this.dao, true);
            monitor.done();
        }
    }
}

