/*
 * Decompiled with CFR 0.152.
 */
package su.artix.yuki.editors;

import org.apache.commons.beanutils.ConstructorUtils;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import su.artix.yuki.directory.GuiActivator;
import su.artix.yuki.editors.AbstractDirectorySelectDialog;
import su.artix.yuki.editors.DirectorySelectDialogState;
import su.artix.yuki.model.UnknownTypeException;

public class DirectorySelectFactory {
    private static final Logger log = LoggerFactory.getLogger(DirectorySelectFactory.class);

    public static <T> AbstractDirectorySelectDialog<T, ?> getSelect(Class<T> base, Shell parentShell, T obj, DirectorySelectDialogState selectDialogState) {
        Class<?> clazz = GuiActivator.getDefault().getCombinationService().getSelectorClass(base);
        if (clazz == null) {
            log.error("DirectorySelectDialog  for class:{} doesn't exist", base);
            throw new UnknownTypeException(obj);
        }
        if (parentShell == null) {
            parentShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        }
        try {
            return (AbstractDirectorySelectDialog)ConstructorUtils.invokeConstructor(clazz, (Object[])new Object[]{parentShell, obj, selectDialogState}, (Class[])new Class[]{Shell.class, base, DirectorySelectDialogState.class});
        }
        catch (Exception e) {
            throw new IllegalStateException("Couldn't create DirectorySelectDialog", e);
        }
    }
}

