/*
 * Decompiled with CFR 0.152.
 */
package su.artix.yuki.provider;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.IIndexableLazyContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TableItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import su.artix.artixadmin.connection.ArtixAdminContextHolder;
import su.artix.yuki.model.ModelActivator;
import su.artix.yuki.model.directory.DirectoryEditModel;
import su.artix.yuki.provider.CiclicQueue;
import su.artix.yuki.provider.ICashedLazyContentProvider;
import su.artix.yuki.provider.IOrderedContentProvider;
import su.artix.yuki.provider.MutexRule;

public class LazyContentProvider<T>
implements IOrderedContentProvider,
ICashedLazyContentProvider,
IIndexableLazyContentProvider {
    private static final Logger log = LoggerFactory.getLogger(LazyContentProvider.class);
    private static final int CACHE_SIZE = 5000;
    private static final int BATCH_SIZE = 150;
    private final Map<Integer, T> cachedRecords;
    private final TableViewer viewer;
    private Object input;
    private final Class<?> clazz;
    private String sortby;
    private boolean ascending = true;
    private MutexRule updateElementRule = new MutexRule();
    private MutexRule fillCashRule = new MutexRule();
    private LinkedBlockingDeque<Integer> updateElementQueue = new CiclicQueue<Integer>(150);
    private LinkedBlockingDeque<Integer> fillCacheQueue = new CiclicQueue<Integer>(3);
    private int last = 0;
    private int last2 = 0;
    private final Lock lock;
    private Job lastFillJob;
    private Job lastUpdateJob;
    private Condition empty;
    private boolean available = false;

    public LazyContentProvider(Class<T> clazz, TableViewer viewer) {
        this.clazz = clazz;
        this.viewer = viewer;
        this.cachedRecords = new ConcurrentHashMap<Integer, T>();
        this.lock = new ReentrantLock();
        this.empty = this.lock.newCondition();
    }

    private void fillCache(int index) {
        if (index >= 0) {
            this.last = index;
            log.debug("filling cash for index {}", (Object)index);
            int minIndex = Math.max(index - 75, 0);
            int maxIndex = index + 75;
            log.debug("from {} to {}(surrogate)", (Object)minIndex, (Object)maxIndex);
            List<T> recordList = this.getRows(minIndex, maxIndex);
            log.debug("returned list size {}", (Object)recordList.size());
            int size = recordList.size();
            int i = minIndex;
            while (i < maxIndex) {
                int current = i - minIndex;
                if (current >= size) break;
                this.cachedRecords.put(i, recordList.get(current));
                ++i;
            }
            log.debug("cache size={}", (Object)this.cachedRecords.size());
            log.trace("end fill cash");
            this.available = true;
        }
    }

    private void clearCache() {
        this.last = 0;
        this.last2 = 0;
        this.cachedRecords.clear();
    }

    public void realRefresh(boolean rowCountChanged) {
        log.trace("real refresh");
        this.available = false;
        this.clearCache();
        if (rowCountChanged) {
            this.updateRowCount();
        }
    }

    @Override
    public void updateRowCount() {
        log.trace("update row count");
        int recordCount = this.getRowCount();
        this.viewer.getTable().setItemCount(recordCount);
    }

    public void dispose() {
        log.trace("dispose");
        if (this.lastFillJob != null) {
            this.lastFillJob.cancel();
        }
        if (this.lastUpdateJob != null) {
            this.lastUpdateJob.cancel();
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        log.trace("oldInput={},newInput={}", oldInput, newInput);
        if (newInput != null) {
            if (!newInput.equals(this.input)) {
                this.input = newInput;
            }
            this.available = false;
            this.updateElementQueue.clear();
            this.fillCacheQueue.clear();
            ((LazyContentProvider)this.viewer.getContentProvider()).realRefresh(true);
        }
    }

    protected void customUpdate(TableItem tableItem) {
    }

    public void updateElement(int index) {
        Job job;
        MDC.put((String)"jobID", (String)("UpdateElement" + this.clazz.getSimpleName()));
        log.trace("update element index={}", (Object)index);
        this.last2 = index;
        String connectionId = ArtixAdminContextHolder.getConnectionId();
        Display display = Display.getCurrent();
        Job[] jobs = Job.getJobManager().find((Object)("UpdateElement" + this.clazz.getSimpleName()));
        this.addToQueue(index);
        if (jobs.length == 0) {
            this.lastUpdateJob = job = new UpdateElementJob("UpdateElement" + this.clazz.getSimpleName(), "\u041e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435 \u0434\u0430\u043d\u043d\u044b\u0445", display);
            log.trace("schedule job for index={}", (Object)index);
            job.setRule((ISchedulingRule)this.updateElementRule);
            job.schedule();
        }
        jobs = Job.getJobManager().find((Object)("FillCashElement" + this.clazz.getSimpleName()));
        this.addToQueue2(index);
        if (jobs.length == 0) {
            this.lastFillJob = job = new FillCashJob("FillCashElement" + this.clazz.getSimpleName(), "\u0412\u044b\u0431\u043e\u0440\u043a\u0430 \u0434\u0430\u043d\u043d\u044b\u0445", connectionId);
            job.setRule((ISchedulingRule)this.fillCashRule);
            job.schedule();
        }
    }

    private void addToQueue(int index) {
        this.updateElementQueue.add(index);
    }

    private void addToQueue2(int index) {
        log.trace("add to fifo FILL elemenet index:{}", (Object)index);
        this.fillCacheQueue.add(index);
    }

    protected int getRowCount() {
        int rowcount = 0;
        this.lock.lock();
        try {
            rowcount = ModelActivator.getDefault().getModelProvider().getDirectoryModel(this.clazz).getItemCount(this.input).intValue();
            log.trace("rowcount={}", (Object)rowcount);
            if (rowcount == 0) {
                this.available = true;
                this.empty.signalAll();
            }
        }
        finally {
            this.lock.unlock();
        }
        return rowcount;
    }

    protected List<T> getRows(int minIndex, int maxIndex) {
        return ModelActivator.getDefault().getModelProvider().getDirectoryModel(this.clazz).getList(this.getSortProperty(), this.isAscending(), this.input, Integer.valueOf(minIndex), Integer.valueOf(maxIndex - minIndex));
    }

    @Override
    public String getSortProperty() {
        return this.sortby;
    }

    @Override
    public void setSortProperty(String sortby) {
        log.trace("setSortProperty");
        this.sortby = sortby;
        this.realRefresh(false);
    }

    @Override
    public boolean isAscending() {
        return this.ascending;
    }

    @Override
    public void setAscending(boolean ascending) {
        log.trace("setAscending");
        this.ascending = ascending;
    }

    @Override
    public void disposeCash() {
        this.realRefresh(true);
    }

    public int findElement(Object element) {
        int res = -1;
        for (Map.Entry<Integer, T> entry : this.cachedRecords.entrySet()) {
            if (!entry.getValue().equals(element)) continue;
            res = entry.getKey();
            break;
        }
        log.trace("findElement index={}", (Object)res);
        return res;
    }

    @Override
    public boolean updateOneItem(Object item) {
        if (item != null) {
            for (Map.Entry<Integer, T> entry : this.cachedRecords.entrySet()) {
                DirectoryEditModel directoryModel;
                Object primaryId;
                if (!entry.getValue().equals(item) || (primaryId = (directoryModel = ModelActivator.getDefault().getModelProvider().getDirectoryModel(this.clazz)).getPrimaryIdValue(item)) == null) continue;
                entry.setValue(directoryModel.getById(primaryId));
                return true;
            }
        }
        return false;
    }

    static /* synthetic */ boolean access$1(LazyContentProvider lazyContentProvider) {
        return lazyContentProvider.available;
    }

    static /* synthetic */ LinkedBlockingDeque access$4(LazyContentProvider lazyContentProvider) {
        return lazyContentProvider.updateElementQueue;
    }

    private class FillCashJob
    extends Job {
        private final String connectionId;
        private boolean cancel;
        private String ID;

        public FillCashJob(String id, String name, String connectionId) {
            super(name);
            this.cancel = false;
            this.ID = id;
            this.connectionId = connectionId;
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected IStatus run(IProgressMonitor monitor) {
            LazyContentProvider.this.lock.lock();
            try {
                block12: {
                    Integer index;
                    block11: {
                        MDC.put((String)"jobID", (String)this.ID);
                        ArtixAdminContextHolder.setConnectionId((String)this.connectionId);
                        if (!true) break block11;
                        index = (Integer)LazyContentProvider.this.fillCacheQueue.pollLast();
                        if (index == null) return Status.OK_STATUS;
                        if (this.cancel) break block12;
                    }
                    do {
                        if (LazyContentProvider.this.cachedRecords.get(index) == null) {
                            LazyContentProvider.this.fillCache(index);
                        } else {
                            Integer delta = index - LazyContentProvider.this.last;
                            if (Math.abs(delta) > 70) {
                                if (delta > 0 && LazyContentProvider.this.cachedRecords.get(index + 75) == null) {
                                    LazyContentProvider.this.fillCache(index + 75);
                                } else if (delta < 0 && LazyContentProvider.this.cachedRecords.get(index - 75) == null) {
                                    LazyContentProvider.this.fillCache(index - 75);
                                }
                            }
                        }
                        index = (Integer)LazyContentProvider.this.fillCacheQueue.pollLast();
                        if (index == null) return Status.OK_STATUS;
                    } while (!this.cancel);
                }
                return Status.OK_STATUS;
            }
            finally {
                LazyContentProvider.this.empty.signalAll();
                LazyContentProvider.this.lock.unlock();
            }
        }

        public boolean belongsTo(Object family) {
            return this.ID.equals(family);
        }

        protected void canceling() {
            super.canceling();
            this.cancel = true;
        }
    }

    private class UpdateElementJob
    extends Job {
        private final Display display;
        private boolean cancel;
        private String ID;

        public UpdateElementJob(String id, String name, Display display) {
            super(name);
            this.cancel = false;
            this.ID = id;
            this.display = display;
        }

        /*
         * Exception decompiling
         */
        protected IStatus run(IProgressMonitor monitor) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public T getAndWait(Integer key) {
            Object value = null;
            try {
                value = LazyContentProvider.this.cachedRecords.get(key);
                if (value == null) {
                    if (Math.abs(LazyContentProvider.this.last2 - key) < 150) {
                        log.debug("WAIT {} value==null size={}", (Object)key, (Object)LazyContentProvider.this.cachedRecords.size());
                    } else {
                        log.debug("return null for {} . last {}", (Object)key, (Object)LazyContentProvider.this.last2);
                    }
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            return value;
        }

        protected void canceling() {
            super.canceling();
            this.cancel = true;
            try {
                LazyContentProvider.this.empty.signal();
            }
            catch (IllegalMonitorStateException e) {
                log.warn(e.getMessage());
            }
        }

        public boolean belongsTo(Object family) {
            return this.ID.equals(family);
        }
    }
}

