/*
 * Decompiled with CFR 0.152.
 */
package su.artix.yuki.view.state;

import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IMemento;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import su.artix.yuki.view.state.PersistState;

public class PersistTreeOrderState
implements PersistState<Tree> {
    private static final Logger log = LoggerFactory.getLogger(PersistTreeOrderState.class);
    private IMemento memento;
    private String id;

    public PersistTreeOrderState(IMemento memento, String id) {
        this.memento = memento;
        this.id = id;
    }

    @Override
    public void saveState(IMemento memento, Tree composite) {
        log.trace("save state");
        IMemento stored = memento.getChild(String.valueOf(this.id) + "_order");
        memento = stored == null ? memento.createChild(String.valueOf(this.id) + "_order") : stored;
        int[] order = composite.getColumnOrder();
        int i = 0;
        while (i < order.length) {
            memento.putInteger("column_" + i, order[i]);
            ++i;
        }
    }

    @Override
    public void restoreState(Tree composite) {
        log.trace("restore state");
        if (this.memento != null) {
            this.memento = this.memento.getChild(String.valueOf(this.id) + "_order");
            if (this.memento != null) {
                int[] order = new int[composite.getColumnCount()];
                int i = 0;
                while (i < composite.getColumnCount()) {
                    Integer w = this.memento.getInteger("column_" + i);
                    if (w != null) {
                        order[i] = w;
                        log.trace("column={},width={}", (Object)i, (Object)w);
                    }
                    ++i;
                }
                composite.setColumnOrder(order);
            }
        }
    }
}

